/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mysql.MysqlElementTypes;
import com.intellij.sql.dialects.mysql.psi.MysqlCreateTableStatementImpl;
import com.intellij.sql.dialects.mysql.psi.MysqlCreateTriggerStatementImpl;
import com.intellij.sql.dialects.mysql.psi.MysqlDelimiterStatementImpl;
import com.intellij.sql.dialects.mysql.psi.MysqlLoadStatementImpl;
import com.intellij.sql.dialects.mysql.psi.MysqlRenameTableStatement;
import com.intellij.sql.dialects.mysql.psi.MysqlShowStatementImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.impl.SqlAlterStatementImpl;
import com.intellij.sql.psi.impl.SqlDmlStatementImpl;
import com.intellij.sql.psi.impl.SqlGenericDefinitionImpl;
import com.intellij.sql.psi.impl.SqlReferenceExpressionImpl;
import com.intellij.sql.psi.impl.SqlStatementImpl;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.sql.psi.impl.parser.SqlElementFactory;
import com.intellij.sql.util.SqlTokenRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MysqlElementFactory
extends SqlElementFactory
implements MysqlElementTypes {
    MysqlElementFactory() {
    }

    @Override
    protected SqlElementFactory.Info getStaticInfo() {
        return LazyData.ourMap;
    }

    static IElementType composite(String name) {
        return MysqlElementFactory.getCompositeType(name, "MYSQL_");
    }

    static SqlTokenType token(String name) {
        return SqlTokenRegistry.getType((String)name);
    }

    @Override
    public PsiElement createCompositeElement(ASTNode node) {
        if (node.getElementType() == SQL_VARIABLE_REFERENCE && node.getText().startsWith("@")) {
            return new MysqlVariableReferenceExpression(node);
        }
        return super.createCompositeElement(node);
    }

    static {
        SqlTokenRegistry.ensureInterfacesAreInitializedInOrder(MysqlElementTypes.Extra.class);
        SqlTokenRegistry.ensureInterfacesAreInitializedInOrder(MysqlElementFactory.class);
    }

    private static class MysqlVariableReferenceExpression
    extends SqlReferenceExpressionImpl
    implements PsiNameIdentifierOwner {
        public MysqlVariableReferenceExpression(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/dialects/mysql/MysqlElementFactory$MysqlVariableReferenceExpression", "<init>"));
            }
            super(node);
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return this.getIdentifier();
        }
    }

    private static class LazyData {
        private static final SqlElementFactory.Info ourMap;

        private LazyData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            SqlElementFactory.Info info = ourMap = new SqlElementFactory.Info();
            synchronized (info) {
                SqlElementFactory.getDefaultRegistrations(ourMap);
                SqlElementFactory.registerImplementation(ourMap, (IElementType)SqlCompositeElementTypes.SQL_CREATE_TABLE_STATEMENT, MysqlCreateTableStatementImpl.class);
                SqlElementFactory.registerImplementation(ourMap, (IElementType)SqlCompositeElementTypes.SQL_CREATE_TRIGGER_STATEMENT, MysqlCreateTriggerStatementImpl.class);
                SqlElementFactory.registerImplementation(ourMap, (IElementType)MysqlElementTypes.MYSQL_RENAME_TABLE_STATEMENT, MysqlRenameTableStatement.class);
                SqlElementFactory.registerImplementation(ourMap, (IElementType)MysqlElementTypes.MYSQL_LOAD_DATA_STATEMENT, MysqlLoadStatementImpl.class);
                SqlElementFactory.registerImplementation(ourMap, (IElementType)MysqlElementTypes.MYSQL_LOAD_XML_STATEMENT, MysqlLoadStatementImpl.class);
                SqlElementFactory.registerImplementation(ourMap, (IElementType)MysqlElementTypes.MYSQL_HANDLER_STATEMENT, SqlDmlStatementImpl.class);
                SqlElementFactory.registerImplementation(ourMap, (IElementType)MysqlElementTypes.MYSQL_DESCRIBE_STATEMENT, SqlDmlStatementImpl.class);
                SqlElementFactory.registerImplementation(ourMap, (IElementType)MysqlElementTypes.MYSQL_DELIMITER_STATEMENT, MysqlDelimiterStatementImpl.class);
                SqlElementFactory.registerImplementation(ourMap, (IElementType)MysqlElementTypes.MYSQL_SHOW_STATEMENT, MysqlShowStatementImpl.class);
                SqlElementFactory.registerImplementation(ourMap, (IElementType)MysqlElementTypes.MYSQL_USER_DEFINITION, SqlGenericDefinitionImpl.class);
                SqlElementFactory.registerImplementation(ourMap, (IElementType)SqlCompositeElementTypes.SQL_ALTER_SCHEMA_STATEMENT, SqlAlterStatementImpl.class);
                SqlElementFactory.registerImplementation(ourMap, (IElementType)SqlCompositeElementTypes.SQL_ALTER_FUNCTION_STATEMENT, SqlAlterStatementImpl.class);
                SqlElementFactory.registerImplementation(ourMap, (IElementType)SqlCompositeElementTypes.SQL_CALL_STATEMENT, SqlStatementImpl.class);
            }
        }
    }
}

