/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlUnionExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlParsingInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, final @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/dialects/mysql/inspections/MysqlParsingInspection", "createAnnotationVisitor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/dialects/mysql/inspections/MysqlParsingInspection", "createAnnotationVisitor"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/dialects/mysql/inspections/MysqlParsingInspection", "createAnnotationVisitor"));
        }
        if (!dialect.getFamilyId().isMysql()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlExpression(SqlExpression o) {
                super.visitSqlExpression(o);
                if (!this.isUnionParenExpression((PsiElement)o)) {
                    return;
                }
                PsiElement parent = o.getParent();
                if (this.isUnionParenExpression(parent)) {
                    return;
                }
                if (parent instanceof SqlJoinExpression || parent instanceof SqlAsExpression) {
                    this.markErrorsFirstJ(o);
                } else {
                    this.markErrorsFirstQ(o);
                }
            }

            private boolean isUnionParenExpression(PsiElement o) {
                return o instanceof SqlUnionExpression || o instanceof SqlParenthesizedExpression && ((SqlParenthesizedExpression)o).getExpressionList().size() == 1;
            }

            private void markErrorsFirstJ(SqlExpression o) {
                List list;
                if (!this.isUnionParenExpression((PsiElement)o)) {
                    return;
                }
                if (o instanceof SqlUnionExpression) {
                    List operands = ((SqlUnionExpression)o).getOperands();
                    if (!operands.isEmpty()) {
                        this.markErrorsFirstJ((SqlExpression)operands.get(0));
                        for (int i2 = 1; i2 < operands.size(); ++i2) {
                            this.markErrors((SqlExpression)operands.get(i2));
                        }
                    }
                } else if (o instanceof SqlParenthesizedExpression && (list = ((SqlParenthesizedExpression)o).getExpressionList()).size() == 1) {
                    this.markErrorsFirstJ((SqlExpression)list.get(0));
                }
            }

            private boolean markErrorsFirstQ(SqlExpression o) {
                List list;
                if (!this.isUnionParenExpression((PsiElement)o)) {
                    return false;
                }
                if (o instanceof SqlUnionExpression) {
                    List operands = ((SqlUnionExpression)o).getOperands();
                    for (SqlExpression operand : operands) {
                        if (!this.markErrors(operand)) continue;
                        return true;
                    }
                } else if (o instanceof SqlParenthesizedExpression && (list = ((SqlParenthesizedExpression)o).getExpressionList()).size() == 1) {
                    return this.markErrors((SqlExpression)list.get(0));
                }
                return false;
            }

            private boolean markErrors(SqlExpression o) {
                List list;
                if (!this.isUnionParenExpression((PsiElement)o)) {
                    return false;
                }
                if (o instanceof SqlUnionExpression) {
                    SqlUnionExpression union = (SqlUnionExpression)o;
                    PsiElement wrongUnion = union.getOpSignElement();
                    for (SqlExpression operand : union.getOperands()) {
                        if (!this.markErrors(operand)) continue;
                        return true;
                    }
                    if (wrongUnion != null) {
                        this.addDescriptor(manager.createProblemDescriptor(wrongUnion, "MySQL won't be able to parse that", true, ProblemHighlightType.WEAK_WARNING, onTheFly, new LocalQuickFix[0]));
                        return true;
                    }
                }
                if (o instanceof SqlParenthesizedExpression && (list = ((SqlParenthesizedExpression)o).getExpressionList()).size() == 1) {
                    return this.markErrors((SqlExpression)list.get(0));
                }
                return false;
            }
        };
    }
}

