/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.code;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.database.editor.DatabaseOpenFileDescriptor;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlDocumentationProvider;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.Functions;
import com.intellij.util.containers.JBIterable;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleLineMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/oracle/code/OracleLineMarkerProvider", "getLineMarkerInfo"));
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/sql/dialects/oracle/code/OracleLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/dialects/oracle/code/OracleLineMarkerProvider", "collectSlowLineMarkers"));
        }
        for (PsiElement e : elements) {
            if (!(e instanceof SqlIdentifier) || !(e.getParent() instanceof SqlReferenceExpression) || !(e.getParent().getParent() instanceof SqlDefinition)) continue;
            JBIterable defs = SyntaxTraverser.psiApi().parents((Object)e).filter(SqlDefinition.class);
            SqlDefinition first = (SqlDefinition)defs.first();
            SqlDefinition second = (SqlDefinition)defs.skip(1).first();
            if (first == null || first.getNameElement() != e.getParent()) continue;
            if (OracleLineMarkerProvider.isPackageOrType(first)) {
                OracleLineMarkerProvider.collectSlowLineMarkers(e, first, first, result2);
                continue;
            }
            if (second == null || !OracleLineMarkerProvider.isPackageOrType(second)) continue;
            OracleLineMarkerProvider.collectSlowLineMarkers(e, first, second, result2);
        }
    }

    private static boolean isPackageOrType(SqlDefinition o) {
        ObjectKind kind = o.getKind();
        return kind == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.BODY;
    }

    private static void collectSlowLineMarkers(@NotNull PsiElement identifier, @NotNull SqlDefinition definition, @NotNull SqlDefinition psiPackage, @NotNull Collection<LineMarkerInfo> result2) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/sql/dialects/oracle/code/OracleLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/sql/dialects/oracle/code/OracleLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/sql/dialects/oracle/code/OracleLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/dialects/oracle/code/OracleLineMarkerProvider", "collectSlowLineMarkers"));
        }
        DbElement fileTarget = null;
        boolean isBody = psiPackage.getKind() == ObjectKind.BODY;
        for (DbElement o : SqlDocumentationProvider.findRelatedViewElements(null, psiPackage)) {
            fileTarget = isBody ? o : (DbElement)o.getDbChildren(DbElement.class, ObjectKind.BODY).first();
            if (fileTarget == null) continue;
            break;
        }
        if (fileTarget == null) {
            return;
        }
        Icon icon = isBody ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.ImplementedMethod;
        String text = isBody ? "Go to specification" : "Go to implementation";
        String actionId = isBody ? "GotoSuperMethod" : "GotoImplementation";
        String tooltip = OracleLineMarkerProvider.composeText(text, actionId);
        LineMarkerInfo info = new LineMarkerInfo((PsiElement)definition, identifier.getTextRange(), icon, 11, Functions.constant((Object)tooltip), (GutterIconNavigationHandler)new MyNavHandler(), GutterIconRenderer.Alignment.RIGHT);
        NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)text, (String)actionId);
        result2.add(info);
    }

    @NotNull
    private static String composeText(@NotNull String start, @NotNull String actionId) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/sql/dialects/oracle/code/OracleLineMarkerProvider", "composeText"));
        }
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/sql/dialects/oracle/code/OracleLineMarkerProvider", "composeText"));
        }
        String postfix = "<br><div style='margin-top: 5px'><font size='2'>Click";
        postfix = postfix + " to navigate</font></div>";
        String string = "<html><body>" + start + postfix + "</body></html>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/oracle/code/OracleLineMarkerProvider", "composeText"));
        }
        return string;
    }

    private static class MyNavHandler
    implements GutterIconNavigationHandler<SqlDefinition> {
        private MyNavHandler() {
        }

        public void navigate(MouseEvent e, SqlDefinition definition) {
            SqlCreateStatement psiPackage = (SqlCreateStatement)PsiTreeUtil.getParentOfType((PsiElement)definition, SqlCreateStatement.class, (boolean)false);
            boolean isBody = psiPackage != null && psiPackage.getKind() == ObjectKind.BODY;
            DbElement fileTarget = null;
            for (DbElement o : SqlDocumentationProvider.findRelatedViewElements(null, (SqlDefinition)psiPackage)) {
                fileTarget = isBody ? o : (DbElement)o.getDbChildren(DbElement.class, ObjectKind.BODY).first();
                if (fileTarget == null) continue;
                break;
            }
            if (fileTarget == null) {
                return;
            }
            VirtualFile file = fileTarget.getVirtualFile();
            if (file != null) {
                int offset = DatabaseOpenFileDescriptor.calcTargetOffset(fileTarget.getProject(), file, (DasObject)definition);
                new DatabaseOpenFileDescriptor(fileTarget.getProject(), file, offset).navigate(true);
            }
        }
    }
}

