/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sybase;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mssql.MssqlDialect;
import com.intellij.sql.dialects.sybase.SybaseOptionalKeywords;
import com.intellij.sql.dialects.sybase.SybaseReservedKeywords;
import com.intellij.sql.dialects.sybase.SybaseTokens;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SybaseDialect
extends SqlLanguageDialectEx {
    public static final SybaseDialect INSTANCE = new SybaseDialect();

    public SybaseDialect() {
        super("Sybase");
    }

    @NotNull
    public String getDisplayName() {
        if ("Sybase" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sybase/SybaseDialect", "getDisplayName"));
        }
        return "Sybase";
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.SybaseDialect sybaseDialect = com.intellij.database.dialects.SybaseDialect.INSTANCE;
        if (sybaseDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sybase/SybaseDialect", "getDatabaseDialect"));
        }
        return sybaseDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map = LazyData.ourFunctionMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sybase/SybaseDialect", "getSupportedFunctions"));
        }
        return map;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(SybaseTokens.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sybase/SybaseDialect", "getKeywords"));
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sybase/SybaseDialect", "getSystemVariables"));
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String referenceName, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/sybase/SybaseDialect", "processReservedEntitiesWithType"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/sybase/SybaseDialect", "processReservedEntitiesWithType"));
        }
        for (ReservedEntity.Typed entity : LazyData.ourTypedEntities) {
            if (SybaseDialect.processReservedEntitiesWithTypeSimple((DasObject)entity, entity.type, referenceName, element, resolve, processor, true, null)) continue;
            return false;
        }
        return MssqlDialect.INSTANCE.processReservedEntitiesWithType(referenceName, element, resolve, processor);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName) {
        ObjectKind type;
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/sql/dialects/sybase/SybaseDialect", "quoteIdentifier"));
        }
        if (newElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "com/intellij/sql/dialects/sybase/SybaseDialect", "quoteIdentifier"));
        }
        PsiElement parent = identifier.getParent();
        Object object = parent instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent).getReferenceElementType().getTargetKind() : (type = parent instanceof SqlDefinition ? ((SqlDefinition)parent).getKind() : null);
        if (type == ObjectKind.VARIABLE) {
            return newElementName.replace(' ', '_');
        }
        return super.quoteIdentifier(identifier, newElementName);
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/dialects/sybase/SybaseDialect", "shouldQuotedTypeReferenceBeChecked"));
        }
        return !this.getKeywords().contains(ref);
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    @Nullable
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource) {
        ObjectName dbname = SybaseDialect.getDatabaseName(dataSource);
        ObjectName schemaName = SybaseDialect.getSchemaName(dataSource);
        DasNamespace namespace = SybaseDialect.getDefaultNamespace(dataSource, dbname);
        if (namespace != null) {
            return SqlDialectImplUtil.createObjectPattern(dataSource, (DasObject)namespace, namespace.getKind() == ObjectKind.SCHEMA ? null : SqlImportUtil.createNode(schemaName, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
        }
        return new TreePattern(SqlImportUtil.createDataSources(dataSource, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbname, SqlImportUtil.createNodeIfNotNull(schemaName, ObjectKind.SCHEMA, new TreePatternNode.Group[0])))));
    }

    @Nullable
    private static ObjectName getSchemaName(@Nullable DbDataSource dataSource) {
        return ObjectName.plain((String)SqlDialectImplUtil.getUserName(SqlImportUtil.getConnectionConfig(dataSource)));
    }

    @Nullable
    private static ObjectName getDatabaseName(@Nullable DbDataSource dataSource) {
        return ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtil.getDatabaseName(SqlImportUtil.getConnectionConfig(dataSource)), (Object)"master")));
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(@Nullable DbDataSource dataSource, @NotNull TreePattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/sql/dialects/sybase/SybaseDialect", "applyImplicitImports"));
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern, dataSource, Collections.singletonList(ObjectName.plain((String)"dbo")), false, SqlImportUtil.DATA_SOURCE, ObjectKind.DATABASE, ObjectKind.SCHEMA);
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sybase/SybaseDialect", "applyImplicitImports"));
        }
        return treePattern;
    }

    @Override
    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @NotNull Iterable<? extends DasNamespace> objects) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/sql/dialects/sybase/SybaseDialect", "forcedContextPattern"));
        }
        ObjectName schemaName = SybaseDialect.getSchemaName(dataSource);
        ObjectName databaseName = SybaseDialect.getDatabaseName(dataSource);
        TreePatternNode.Group[] schemas = schemaName == null ? TreePatternNode.NO_GROUPS : (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(schemaName, ObjectKind.SCHEMA, new TreePatternNode.Group[0])});
        TreePatternNode.Group[] databases = databaseName == null ? TreePatternNode.NO_GROUPS : (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(databaseName, ObjectKind.DATABASE, schemas)});
        TreePattern treePattern = SybaseDialect.forcedContextExpandedToSchemas(dataSource, objects, schemas, databases);
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sybase/SybaseDialect", "forcedContextPattern"));
        }
        return treePattern;
    }

    @Override
    @NotNull
    public TreePattern srcFilePattern(@Nullable DbDataSource dataSource, @NotNull DasNamespace object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/sql/dialects/sybase/SybaseDialect", "srcFilePattern"));
        }
        TreePattern treePattern = this.forcedContextPattern(dataSource, Collections.singletonList(object));
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sybase/SybaseDialect", "srcFilePattern"));
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern forcedContextExpandedToSchemas(@Nullable DbDataSource dataSource, @NotNull Iterable<? extends DasNamespace> objects, TreePatternNode.Group[] schemas, TreePatternNode.Group[] databases) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/sql/dialects/sybase/SybaseDialect", "forcedContextExpandedToSchemas"));
        }
        TreePattern treePattern = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(objects).transform(n -> {
            TreePatternNode.Group[] tail = null;
            if (n.getKind() == ObjectKind.DATABASE) {
                DasNamespace schema = SybaseDialect.getCurrentSchema(n);
                tail = schema == null ? schemas : SqlImportUtil.optAr(SqlImportUtil.createNode(ObjectName.quoted((String)schema.getName()), ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            } else if (n.getKind() == ObjectKind.NONE) {
                tail = databases;
            }
            return SqlDialectImplUtil.createObjectPattern(dataSource, (DasObject)n, tail);
        }));
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sybase/SybaseDialect", "forcedContextExpandedToSchemas"));
        }
        return treePattern;
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final List<ReservedEntity.Typed> ourTypedEntities = SqlDialectImplUtil.loadEntities(INSTANCE);
        static final NullableFunction<String, IElementType> ourReservedTokens = SqlTokenRegistry.getTokenProvider(SybaseReservedKeywords.class);
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SybaseOptionalKeywords.ASE_GO})});
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_OP_CONCAT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_BITWISE_NOT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT_LT, SqlElementTypes.SQL_OP_NOT_GT, SqlElementTypes.SQL_OP_PLUS_EQ, SqlElementTypes.SQL_OP_MINUS_EQ, SqlElementTypes.SQL_OP_MUL_EQ, SqlElementTypes.SQL_OP_DIV_EQ, SqlElementTypes.SQL_OP_MODULO_EQ, SqlElementTypes.SQL_OP_BITWISE_AND_EQ, SqlElementTypes.SQL_OP_BITWISE_OR_EQ, SqlElementTypes.SQL_OP_BITWISE_XOR_EQ, SybaseReservedKeywords.ASE_XMLTEST});
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_THEN, SqlElementTypes.SQL_THEN_CLAUSE, SqlElementTypes.SQL_IF_STATEMENT}, "", "end if", 2, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_IF, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false))));

        private LazyData() {
        }
    }
}

