/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlInspectionBase
extends LocalInspectionTool {
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        String string = SqlInspectionBase.getShortName((String)super.getID());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlInspectionBase", "getID"));
        }
        return string;
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/inspections/SqlInspectionBase", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlInspectionBase", "checkFile"));
        }
        if (!(file instanceof SqlFile)) {
            return null;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        if (dialect == DbSqlUtil.getGenericDialect()) {
            return null;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        final SqlAnnotationVisitor visitor = this.createAnnotationVisitor(dialect, manager, result2, isOnTheFly);
        if (visitor == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof SqlElement) {
                    visitor.myCheckSubtree = false;
                    ((SqlElement)element).accept((SqlVisitor)visitor);
                } else {
                    visitor.myCheckSubtree = true;
                }
                if (visitor.myCheckSubtree) {
                    super.visitElement(element);
                }
            }

            protected void elementFinished(PsiElement element) {
                visitor.elementFinished(element);
            }
        });
        return result2.toArray(new ProblemDescriptor[result2.size()]);
    }

    @Nullable
    protected abstract SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx var1, @NotNull InspectionManager var2, @NotNull List<ProblemDescriptor> var3, boolean var4);

    @NotNull
    public String getGroupDisplayName() {
        String string = SqlMessages.message("sql.inspections.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = StringUtil.getShortName((String)((Object)((Object)this)).getClass().getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlInspectionBase", "getShortName"));
        }
        return string;
    }

    public static class SqlAnnotationVisitor
    extends SqlVisitor {
        private boolean myCheckSubtree;
        protected InspectionManager myManager;
        protected SqlLanguageDialectEx myDialect;
        protected Collection<ProblemDescriptor> myResults;

        public SqlAnnotationVisitor(InspectionManager manager, SqlLanguageDialect dialect, Collection<ProblemDescriptor> results) {
            this.myManager = manager;
            this.myDialect = (SqlLanguageDialectEx)dialect;
            this.myResults = results;
        }

        public void visitSqlElement(SqlElement o) {
            this.myCheckSubtree = true;
        }

        protected void addDescriptor(ProblemDescriptor problemDescriptor) {
            this.myResults.add(problemDescriptor);
        }

        protected boolean shouldNotCheckElement(SqlElement o) {
            return PsiUtilCore.hasErrorElementChild((PsiElement)o.getParent()) || PsiUtilCore.hasErrorElementChild((PsiElement)o) || this.myDialect.mayContainExternalPsi() && SyntaxTraverser.psiApi().parents((Object)o).filter(Conditions.instanceOf((Class[])new Class[]{SqlResultSetExpression.class, IsExternal.class})).first() instanceof IsExternal;
        }

        public void elementFinished(PsiElement element) {
        }
    }
}

