/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbDataSourceLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStorageInspection
extends LocalInspectionTool {
    public static final Key<Boolean> IGNORE_UNSAVED = Key.create((String)"IGNORE_UNSAVED");
    private static final LocalQuickFix[] OLD_STAGING_FIXES = new LocalQuickFix[]{new RevertFix(), new KeepModifiedFix()};
    private static final LocalQuickFix[] INVALID_SOURCES_FIXES = new LocalQuickFix[]{new ReintrospectFix()};

    @NotNull
    public String getShortName() {
        if ("SqlStorageInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlStorageInspection", "getShortName"));
        }
        return "SqlStorageInspection";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/inspections/SqlStorageInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlStorageInspection", "checkFile"));
        }
        VirtualFile vfile = file.getVirtualFile();
        if (!isOnTheFly || !DbSrcUtils.isDbSrcFile(vfile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemDescriptor oldStaging = SqlStorageInspection.checkOldStaging(file, manager, vfile);
        ProblemDescriptor invalidSources = SqlStorageInspection.checkInvalidSources(file, manager, vfile);
        if (oldStaging == null && invalidSources == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (oldStaging == null) {
            return (ProblemDescriptor[])ContainerUtil.ar((Object[])new ProblemDescriptor[]{invalidSources});
        }
        if (invalidSources == null) {
            return (ProblemDescriptor[])ContainerUtil.ar((Object[])new ProblemDescriptor[]{oldStaging});
        }
        return (ProblemDescriptor[])ContainerUtil.ar((Object[])new ProblemDescriptor[]{oldStaging, invalidSources});
    }

    @Nullable
    private static ProblemDescriptor checkOldStaging(@NotNull PsiFile file, @NotNull InspectionManager manager, VirtualFile vfile) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/inspections/SqlStorageInspection", "checkOldStaging"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlStorageInspection", "checkOldStaging"));
        }
        if (SqlStorageInspection.isUnsaved(vfile)) {
            return null;
        }
        DbSrcFileSystem fs = DbSrcFileSystem.getInstance();
        VirtualFile staging = fs.getBaseFile(vfile, true);
        if (staging == null) {
            return null;
        }
        VirtualFile base = fs.getBaseFile(vfile, false);
        if (base == null || base.getTimeStamp() <= staging.getTimeStamp()) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)file, "Object has changed in database", true, OLD_STAGING_FIXES, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Nullable
    private static ProblemDescriptor checkInvalidSources(final @NotNull PsiFile file, final @NotNull InspectionManager manager, VirtualFile vfile) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/inspections/SqlStorageInspection", "checkInvalidSources"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlStorageInspection", "checkInvalidSources"));
        }
        return DbSrcFileSystem.processPath(vfile, new DbSrcFileSystem.ItemProcessor<ProblemDescriptor>(){

            @Override
            public ProblemDescriptor processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
                BasicModel model;
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/sql/inspections/SqlStorageInspection$1", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/sql/inspections/SqlStorageInspection$1", "processFile"));
                }
                DbDataSourceLayout layout = DbSrcStorage.getInstance(project).getLayout(dataSourceId);
                DbSrcStorageDsMetadata.MetaData res = layout.getMetaData(path);
                if (res == null) {
                    return null;
                }
                LocalDataSource dataSource = DbSrcUtils.findDataSource(project, dataSourceId);
                if (dataSource == null) {
                    return null;
                }
                BasicSourceAware object = DbSrcUtils.findObject(path, dataSource.getModel(), BasicSourceAware.class, true);
                BasicModel basicModel = model = object == null ? null : object.getModel();
                if (model == null) {
                    return null;
                }
                int version = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(model.getRdbms(), object.getKind());
                if (res.introContentVersion == version) {
                    return null;
                }
                return manager.createProblemDescriptor((PsiElement)file, "Object source code may be invalid.", true, INVALID_SOURCES_FIXES, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        });
    }

    private static boolean isUnsaved(VirtualFile vfile) {
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(vfile);
        return documentManager.isFileModified(vfile) && !Boolean.TRUE.equals(IGNORE_UNSAVED.get((UserDataHolder)document));
    }

    private static class KeepModifiedFix
    extends IntentionAndQuickFixAction {
        private KeepModifiedFix() {
        }

        @NotNull
        public String getName() {
            if ("Keep modified" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlStorageInspection$KeepModifiedFix", "getName"));
            }
            return "Keep modified";
        }

        @NotNull
        public String getFamilyName() {
            if ("Keep modified" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlStorageInspection$KeepModifiedFix", "getFamilyName"));
            }
            return "Keep modified";
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlStorageInspection$KeepModifiedFix", "applyFix"));
            }
            VirtualFile vfile = file.getVirtualFile();
            if (!DbSrcUtils.isDbSrcFile(vfile)) {
                return;
            }
            DbSrcFileSystem fs = DbSrcFileSystem.getInstance();
            VirtualFile staging = fs.getBaseFile(vfile, true);
            if (staging == null) {
                return;
            }
            VirtualFile base = fs.getBaseFile(vfile, false);
            if (base == null) {
                return;
            }
            FileSystemInterface stagingFs = (FileSystemInterface)ObjectUtils.tryCast((Object)staging.getFileSystem(), FileSystemInterface.class);
            if (stagingFs == null) {
                return;
            }
            try {
                stagingFs.setTimeStamp(staging, base.getTimeStamp());
                VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{staging, vfile});
                DbSrcUtils.refresh();
                FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{vfile});
            }
            catch (IOException e) {
                DatabaseNotifications.REFACTORING_GROUP.createNotification("Failed to update staging file for " + vfile.getUrl(), MessageType.INFO).notify(file.getProject());
            }
        }

        public boolean startInWriteAction() {
            return false;
        }
    }

    private static class RevertFix
    extends IntentionAndQuickFixAction {
        private RevertFix() {
        }

        @NotNull
        public String getName() {
            if ("Revert local changes" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlStorageInspection$RevertFix", "getName"));
            }
            return "Revert local changes";
        }

        @NotNull
        public String getFamilyName() {
            if ("Revert local changes" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlStorageInspection$RevertFix", "getFamilyName"));
            }
            return "Revert local changes";
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlStorageInspection$RevertFix", "applyFix"));
            }
            VirtualFile vfile = file.getVirtualFile();
            if (!DbSrcUtils.isDbSrcFile(vfile)) {
                return;
            }
            try {
                DbSrcUtils.removeFromStorage((Iterable<VirtualFile>)JBIterable.of((Object)vfile), true);
            }
            catch (IOException e) {
                DatabaseNotifications.REFACTORING_GROUP.createNotification("Failed to revert " + vfile.getUrl(), MessageType.INFO).notify(file.getProject());
            }
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    private static class ReintrospectFix
    extends IntentionAndQuickFixAction {
        private ReintrospectFix() {
        }

        @NotNull
        public String getName() {
            if ("Synchronize" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlStorageInspection$ReintrospectFix", "getName"));
            }
            return "Synchronize";
        }

        @NotNull
        public String getFamilyName() {
            if ("Synchronize" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlStorageInspection$ReintrospectFix", "getFamilyName"));
            }
            return "Synchronize";
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlStorageInspection$ReintrospectFix", "isAvailable"));
            }
            VirtualFile vfile = file.getVirtualFile();
            LocalDataSource dataSource = DbSrcUtils.isDbSrcFile(vfile) ? DbSrcUtils.findDataSource(vfile) : null;
            return dataSource != null && DbImplUtil.canConnectTo(dataSource) && DataSourceSyncManager.getInstance().isAbleToPerform(dataSource);
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            LocalDataSource dataSource;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlStorageInspection$ReintrospectFix", "applyFix"));
            }
            VirtualFile vfile = file.getVirtualFile();
            LocalDataSource localDataSource = dataSource = DbSrcUtils.isDbSrcFile(vfile) ? DbSrcUtils.findDataSource(vfile) : null;
            if (dataSource == null) {
                return;
            }
            DataSourceUiUtil.performAutoSyncTask(project, dataSource);
        }
    }
}

