/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.PsiTable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTypeInspection
extends SqlInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("inspection.name.type", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlTypeInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/inspections/SqlTypeInspection", "createAnnotationVisitor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlTypeInspection", "createAnnotationVisitor"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/inspections/SqlTypeInspection", "createAnnotationVisitor"));
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlAsExpression(SqlAsExpression o) {
                super.visitSqlAsExpression(o);
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                SqlExpression expression = o.getExpression();
                SqlType type = expression.getSqlType();
                SqlType asType = o.getSqlType();
                if (!(expression instanceof SqlTableExpression) || type != SqlTableTypeBase.EMPTY_TABLE) {
                    this.checkTypesMatching(type, asType, (PsiElement)o.getNameElement());
                }
                this.checkNamesUnique(o.getColumnAliasList(), null);
                if (asType instanceof SqlTableType) {
                    this.checkColumnAliasesRequired((SqlTableType)asType, o.getNameElement());
                }
            }

            private void checkColumnAliasesRequired(SqlTableType type, SqlIdentifier elementToHighlight) {
                THashSet s = new THashSet();
                for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
                    String name = type.getColumnName(i2);
                    if (!StringUtil.isNotEmpty((String)name) || s.add((Object)name)) continue;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)elementToHighlight, SqlMessages.message("column.aliases.required", type.getDisplayName()), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    break;
                }
            }

            public void visitSqlCreateViewStatement(SqlCreateViewStatement o) {
                SqlType type;
                super.visitSqlCreateViewStatement(o);
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                SqlExpression expression = o.getExpression();
                SqlType sqlType = type = expression != null ? expression.getSqlType() : null;
                if (type != null && type != SqlTableTypeBase.EMPTY_TABLE) {
                    this.checkTypesMatching(type, (SqlType)SqlTableTypeBase.createType((PsiTable)o, null), (PsiElement)o.getNameElement());
                }
                this.checkNamesUnique(Arrays.asList(o.getColumnAliases()), (SqlCreateStatement)o);
            }

            public void visitSqlCreateTableStatement(SqlCreateTableStatement o) {
                super.visitSqlCreateTableStatement(o);
                this.checkNamesUnique(ContainerUtil.filter((Collection)o.getColumns(), (Condition)new FilteringIterator.InstanceOf(SqlDefinition.class)), (SqlCreateStatement)o);
            }

            public void visitSqlUnaryExpression(SqlUnaryExpression o) {
                super.visitSqlUnaryExpression(o);
                IElementType sign = o.getOpSign();
                if (!SqlTypeInspection.isOperatorSupported(sign, this.myDialect)) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(o.getOpSignElement(), SqlMessages.message("operator.0.not.supported.by.dialect.1", sign.toString(), this.myDialect.getDisplayName()), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            public void visitSqlBinaryExpression(SqlBinaryExpression o) {
                super.visitSqlBinaryExpression(o);
                IElementType sign = o.getOpSign();
                if (!SqlTypeInspection.isOperatorSupported(sign, this.myDialect)) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(o.getOpSignElement(), SqlMessages.message("operator.0.not.supported.by.dialect.1", sign.toString(), this.myDialect.getDisplayName()), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            private void checkNamesUnique(List<? extends SqlDefinition> definitions, @Nullable SqlCreateStatement qualifyingStatement) {
                if (definitions.isEmpty()) {
                    return;
                }
                THashMap toMark = ContainerUtil.newTroveMap();
                THashMap toMark2 = ContainerUtil.newTroveMap();
                THashMap map = ContainerUtil.newTroveMap();
                for (SqlDefinition sqlDefinition : definitions) {
                    SqlNameElement nameElement;
                    SqlElement oldElement;
                    boolean isPlain = SqlImplUtil.hasPlainIdentifier(sqlDefinition, this.myDialect.getDatabaseDialect());
                    String name = this.myDialect.getCasing(sqlDefinition.getKind(), (DasObject)sqlDefinition).choose(isPlain).apply(sqlDefinition.getName());
                    if (!StringUtil.isNotEmpty((String)name) || (oldElement = (SqlElement)map.put(name, nameElement = sqlDefinition.getNameElement())) == null) continue;
                    boolean added = false;
                    if (PsiTreeUtil.isAncestor((PsiElement)qualifyingStatement, (PsiElement)oldElement, (boolean)true)) {
                        toMark.put(oldElement, name);
                        added = true;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)qualifyingStatement, (PsiElement)nameElement, (boolean)true)) {
                        toMark.put(nameElement, name);
                        added = true;
                    }
                    if (added || qualifyingStatement == null) continue;
                    SqlNameElement element = qualifyingStatement.getNameElement();
                    ContainerUtil.putIfNotNull((Object)element, (Object)name, (Map)toMark2);
                }
                for (PsiElement psiElement : toMark.keySet()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(psiElement, SqlMessages.message("already.exists", toMark.get(psiElement)), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
                for (PsiElement psiElement : toMark2.keySet()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(psiElement, SqlMessages.message("duplicate.column", toMark2.get(psiElement)), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            private void checkTypesMatching(@NotNull SqlType type1, @NotNull SqlType type2, PsiElement anchor2) {
                int count2;
                if (type1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/sql/inspections/SqlTypeInspection$1", "checkTypesMatching"));
                }
                if (type2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/sql/inspections/SqlTypeInspection$1", "checkTypesMatching"));
                }
                if (type1 == SqlType.UNKNOWN || type2 == SqlType.UNKNOWN) {
                    return;
                }
                if (type1 instanceof SqlTableTypeBase.UnresolvedRefType || type2 instanceof SqlTableTypeBase.UnresolvedRefType) {
                    return;
                }
                int count1 = type1 instanceof SqlTableType ? ((SqlTableType)type1).getColumnCount() : 1;
                int n = count2 = type2 instanceof SqlTableType ? ((SqlTableType)type2).getColumnCount() : 1;
                if (count1 != count2 && !this.myDialect.getFamilyId().isPostgres() && anchor2 != null && anchor2.isPhysical()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(anchor2, SqlMessages.message("incompatible.types", type2.getDisplayName(), type1.getDisplayName()), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }
        };
    }

    private static boolean isOperatorSupported(IElementType sign, SqlLanguageDialectEx dialect) {
        DatabaseFamilyId familyId = dialect.getFamilyId();
        return familyId != DatabaseFamilyId.UNKNOWN || dialect.isOperatorSupported(sign);
    }
}

