/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DataType;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AliasedSqlTableType
extends SqlTableTypeBase {
    private final SqlTableType myType;
    private final String myAliasName;
    private final List<? extends SqlNameElement> myNewColumns;
    private final PsiElement myAliasElement;

    public AliasedSqlTableType(SqlTableType type, String aliasName, @Nullable PsiElement aliasElement, List<? extends SqlNameElement> newColumns) {
        this.myType = type;
        this.myAliasName = aliasName;
        this.myNewColumns = newColumns;
        this.myAliasElement = aliasElement;
    }

    @Override
    @Nullable
    public PsiElement getTypeElement() {
        return this.myType.getTypeElement();
    }

    @Nullable
    public PsiElement getColumnQualifier(int i2) {
        return this.myAliasElement;
    }

    @Override
    @Nullable
    public String getTypeName() {
        return this.myAliasName;
    }

    public int getColumnCount() {
        return this.myNewColumns.isEmpty() ? this.myType.getColumnCount() : this.myNewColumns.size();
    }

    public String getColumnName(int i2) {
        return this.myNewColumns.isEmpty() ? this.myType.getColumnName(i2) : this.myNewColumns.get(i2).getName();
    }

    public SqlType getColumnType(int i2) {
        return this.myNewColumns.isEmpty() ? this.myType.getColumnType(i2) : (i2 < this.myType.getColumnCount() ? this.myType.getColumnType(i2) : UNKNOWN);
    }

    public DataType getDataType(int i2) {
        return this.myNewColumns.isEmpty() ? this.myType.getDataType(i2) : (i2 < this.myType.getColumnCount() ? this.myType.getDataType(i2) : DataType.UNKNOWN);
    }

    @NotNull
    public PsiElement getColumnElement(int i2) {
        PsiElement psiElement = this.myNewColumns.isEmpty() ? this.myType.getColumnElement(i2) : (PsiElement)this.myNewColumns.get(i2);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/AliasedSqlTableType", "getColumnElement"));
        }
        return psiElement;
    }

    public PsiElement getSourceColumnElement(int i2) {
        return this.myNewColumns.isEmpty() ? this.myType.getSourceColumnElement(i2) : (i2 < this.myType.getColumnCount() ? this.myType.getSourceColumnElement(i2) : null);
    }

    @Override
    @Nullable
    public String getColumnTypeAlias(int i2) {
        return this.myAliasName;
    }

    @Override
    @Nullable
    public SqlType getConcreteType() {
        return this.myType.getConcreteType();
    }
}

