/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlDefinitionImpl;
import org.jetbrains.annotations.NotNull;

public class SqlConstraintDefinitionImpl
extends SqlDefinitionImpl
implements SqlConstraintDefinition {
    public SqlConstraintDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlConstraintDefinitionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlConstraintDefinition((SqlConstraintDefinition)this);
    }

    public SqlReferenceExpression getNameElement() {
        return this.findReferenceByType(SqlCompositeElementTypes.SQL_CONSTRAINT_REFERENCE);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = SqlDbElementType.CONSTRAINT;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlConstraintDefinitionImpl", "getKind"));
        }
        return objectKind;
    }

    public <T> T getConstraintParameter(Key<T> key) {
        if (key == CHECK_EXPRESSION) {
            for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof SqlExpression) || child.getNode().getElementType() == SqlCompositeElementTypes.SQL_CONSTRAINT_REFERENCE) continue;
                return (T)child;
            }
            return null;
        }
        throw new AssertionError((Object)(key + " parameter invalid"));
    }

    @NotNull
    public SqlConstraintDefinition.Type getConstraintType() {
        IElementType type = this.getNode().getElementType();
        if (type == SqlCompositeElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION) {
            SqlConstraintDefinition.Type type2 = SqlConstraintDefinition.Type.NOT_NULL;
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlConstraintDefinitionImpl", "getConstraintType"));
            }
            return type2;
        }
        if (type == SqlCompositeElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION) {
            SqlConstraintDefinition.Type type3 = SqlConstraintDefinition.Type.NULLABLE;
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlConstraintDefinitionImpl", "getConstraintType"));
            }
            return type3;
        }
        if (type == SqlCompositeElementTypes.SQL_CHECK_CONSTRAINT_DEFINITION) {
            SqlConstraintDefinition.Type type4 = SqlConstraintDefinition.Type.CHECK;
            if (type4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlConstraintDefinitionImpl", "getConstraintType"));
            }
            return type4;
        }
        if (type == SqlCompositeElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION) {
            SqlConstraintDefinition.Type type5 = SqlConstraintDefinition.Type.DEFAULT;
            if (type5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlConstraintDefinitionImpl", "getConstraintType"));
            }
            return type5;
        }
        SqlConstraintDefinition.Type type6 = SqlConstraintDefinition.Type.OTHER;
        if (type6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlConstraintDefinitionImpl", "getConstraintType"));
        }
        return type6;
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlCreateStatement statement;
        if (this.getConstraintType() == SqlConstraintDefinition.Type.CHECK && (statement = (SqlCreateStatement)PsiTreeUtil.getParentOfType((PsiElement)this, SqlCreateStatement.class, (boolean)true)) != null) {
            if (!processor.execute((PsiElement)statement, state)) {
                return false;
            }
            if (!statement.processDeclarations(processor, state, (PsiElement)statement, place)) {
                return false;
            }
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }
}

