/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiTable;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTargetContextProvider;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTriggerStub;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCreateTriggerStatementImpl
extends SqlStubbedDefinitionImpl<SqlTriggerStub>
implements SqlCreateTriggerStatement {
    public SqlCreateTriggerStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl", "<init>"));
        }
        super(node);
    }

    public SqlCreateTriggerStatementImpl(SqlTriggerStub stub) {
        super(stub, SqlCompositeElementTypes.SQL_CREATE_TRIGGER_STATEMENT);
    }

    @Override
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlCompositeElementTypes.SQL_TRIGGER_REFERENCE;
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlCreateTriggerStatement((SqlCreateTriggerStatement)this);
    }

    public SqlReferenceExpression getTargetContextExpression() {
        SqlTriggerStub stub = (SqlTriggerStub)this.getStub();
        if (stub != null) {
            return stub.getTableReference();
        }
        SqlOnTargetClauseImpl target = (SqlOnTargetClauseImpl)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_ON_TARGET_CLAUSE);
        return target == null ? null : (SqlReferenceExpression)ObjectUtils.tryCast((Object)target.getTargetExpression(), SqlReferenceExpression.class);
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlReferenceExpression expression = this.getTargetContextExpression();
        if (lastParent.getParent() == this && expression != null && expression != lastParent) {
            if (!this.processFakeDefinitions(processor, state, lastParent, place)) {
                return false;
            }
            if (lastParent instanceof SqlAsExpression) {
                return false;
            }
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    public String getTableName() {
        SqlReferenceExpression ref = this.getTargetContextExpression();
        return ref == null ? null : ref.getName();
    }

    public DasTable getTable() {
        SqlReferenceExpression ref = this.getTargetContextExpression();
        PsiElement resolve = ref == null ? null : ref.resolve();
        return resolve instanceof DasTable ? (DasTable)resolve : null;
    }

    @Nullable
    public SqlExpression getTriggerProcedure() {
        return null;
    }

    protected boolean processFakeDefinitions(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        return true;
    }

    public static class FakeSynonym
    extends SqlFileImpl.FakeDefinition
    implements SqlAsExpression,
    SqlIdentifier {
        private final PsiElement myTarget;

        public FakeSynonym(@NotNull PsiElement parent, @Nullable PsiElement target, @NotNull String name) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeSynonym", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeSynonym", "<init>"));
            }
            super(parent, name, name);
            this.myTarget = target;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = SqlDbElementType.LOCAL_ALIAS;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeSynonym", "getKind"));
            }
            return objectKind;
        }

        @NotNull
        public SqlIdentifier getNameElement() {
            FakeSynonym fakeSynonym = this;
            if (fakeSynonym == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeSynonym", "getNameElement"));
            }
            return fakeSynonym;
        }

        @Nullable
        public SqlReferenceExpression getTargetContextExpression() {
            SqlTargetContextProvider trig = (SqlTargetContextProvider)ObjectUtils.tryCast((Object)this.getParent(), SqlTargetContextProvider.class);
            return trig == null ? null : trig.getTargetContextExpression();
        }

        @NotNull
        public SqlType getSqlType() {
            if (this.myTarget instanceof PsiTable) {
                SqlTableType sqlTableType = SqlTableTypeBase.createType((PsiTable)this.myTarget, (PsiElement)this);
                if (sqlTableType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeSynonym", "getSqlType"));
                }
                return sqlTableType;
            }
            SqlReferenceExpression expression = this.getTargetContextExpression();
            Object object = expression == null ? SqlType.UNKNOWN : expression.getSqlType();
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeSynonym", "getSqlType"));
            }
            return object;
        }

        @NotNull
        public SqlExpression getExpression() {
            SqlExpression sqlExpression = (SqlExpression)ObjectUtils.chooseNotNull((Object)this.getTargetContextExpression(), (Object)((Object)this));
            if (sqlExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeSynonym", "getExpression"));
            }
            return sqlExpression;
        }

        @NotNull
        public List<SqlColumnAliasDefinition> getColumnAliasList() {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeSynonym", "getColumnAliasList"));
            }
            return list;
        }

        public TextRange getNameRange() {
            return TextRange.EMPTY_RANGE;
        }

        @Nullable
        public String getNamePrefix() {
            return null;
        }

        @Override
        public FakeSynonym setName(@NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeSynonym", "setName"));
            }
            super.setName(name);
            return this;
        }

        @Override
        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = (PsiElement)ObjectUtils.chooseNotNull((Object)this.myTarget, (Object)ObjectUtils.chooseNotNull((Object)this.getTargetContextExpression(), (Object)this.getNameElement()));
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeSynonym", "getNavigationElement"));
            }
            return psiElement;
        }
    }

    public static class FakeTablesHandler {
        private final PsiElement myProvider;
        private final PsiElement myTarget;
        private final FakeSynonym[] mySynonyms;

        public FakeTablesHandler(@NotNull PsiElement provider, @Nullable PsiElement target, String ... names) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeTablesHandler", "<init>"));
            }
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeTablesHandler", "<init>"));
            }
            this.myProvider = provider;
            this.myTarget = target;
            this.mySynonyms = new FakeSynonym[names.length];
            for (int i2 = 0; i2 < names.length; ++i2) {
                this.mySynonyms[i2] = new FakeSynonym(provider, this.myTarget, names[i2]);
            }
        }

        public FakeTablesHandler(@NotNull PsiElement provider, String ... names) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeTablesHandler", "<init>"));
            }
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeTablesHandler", "<init>"));
            }
            this(provider, (PsiElement)null, names);
        }

        public boolean processSimple(PsiScopeProcessor processor, ResolveState state) {
            for (FakeSynonym synonym : this.mySynonyms) {
                if (processor.execute((PsiElement)synonym, state)) continue;
                return false;
            }
            return true;
        }

        public boolean processAliased(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
            if (lastParent instanceof SqlAsExpression) {
                return this.processSimple(processor, state);
            }
            boolean[] marks = new boolean[this.mySynonyms.length];
            SqlAsExpression[] aliases = (SqlAsExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)this.myProvider, SqlAsExpression.class);
            if (aliases == null) {
                return this.processSimple(processor, state);
            }
            for (SqlAsExpression expr : aliases) {
                String name = expr.getNameElement().getName();
                for (int i2 = 0; i2 < this.mySynonyms.length; ++i2) {
                    if (!this.mySynonyms[i2].getName().equalsIgnoreCase(name)) continue;
                    marks[i2] = true;
                }
            }
            for (int i3 = 0; i3 < this.mySynonyms.length; ++i3) {
                if (marks[i3] || processor.execute((PsiElement)this.mySynonyms[i3], state)) continue;
                return false;
            }
            return true;
        }
    }
}

