/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.google.common.collect.Iterables;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCursorDefinitionImpl;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionCallExpressionImpl
extends SqlExpressionImpl
implements SqlFunctionCallExpression,
NavigationItem {
    public SqlFunctionCallExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlFunctionCallExpression((SqlFunctionCallExpression)this);
    }

    @Nullable
    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getCallableExpression(), SqlReferenceExpression.class);
    }

    @NotNull
    public SqlExpression getCallableExpression() {
        SqlExpression sqlExpression = (SqlExpression)this.findNotNullChildByClass(SqlExpression.class);
        if (sqlExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getCallableExpression"));
        }
        return sqlExpression;
    }

    public SqlExpressionList getParameterList() {
        return (SqlExpressionList)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_EXPRESSION_LIST);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlTableType type;
        boolean ensureTable;
        SqlReferenceExpression nameElement;
        SqlFunctionDefinition.Prototype prototype = SqlFunctionsUtil.chooseTheBestPrototype(this, true);
        if (prototype != null) {
            SqlType sqlType;
            SqlFunctionDefinition.Type returnType = prototype.getReturnType();
            SqlType sqlType2 = sqlType = returnType == null ? null : returnType.getSqlType();
            if (sqlType != null) {
                SqlType sqlType3 = sqlType;
                if (sqlType3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
                }
                return sqlType3;
            }
            if (returnType instanceof SqlFunctionDefinition.ParamType) {
                int index = ((SqlFunctionDefinition.ParamType)returnType).getIndex();
                SqlExpressionList parameterList = this.getParameterList();
                List params2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)parameterList, SqlCompositeElement.class);
                if (index > 0 && index <= params2.size()) {
                    SqlCompositeElement element = (SqlCompositeElement)params2.get(index - 1);
                    SqlType paramType = SqlFunctionCallExpressionImpl.getParamType((SqlElement)element);
                    if ("CAST".equalsIgnoreCase(prototype.getFunction().getName()) && params2.get(0) instanceof SqlExpression) {
                        SqlTableType sqlTableType = SqlTableTypeBase.createType((SqlElement)params2.get(0), paramType, null, (PsiElement)this);
                        if (sqlTableType == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
                        }
                        return sqlTableType;
                    }
                    SqlType sqlType4 = paramType;
                    if (sqlType4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
                    }
                    return sqlType4;
                }
                if (index == 0) {
                    SqlPrimitiveType curType = SqlType.UNKNOWN;
                    for (SqlCompositeElement param : params2) {
                        SqlType type2 = SqlFunctionCallExpressionImpl.getParamType((SqlElement)param);
                        if (curType == SqlType.UNKNOWN) {
                            curType = type2;
                            continue;
                        }
                        if (curType != SqlType.INTEGER || type2 != SqlType.REAL) continue;
                        curType = SqlType.REAL;
                    }
                    SqlPrimitiveType sqlPrimitiveType = curType;
                    if (sqlPrimitiveType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
                    }
                    return sqlPrimitiveType;
                }
            }
        }
        PsiElement resolve = (nameElement = this.getNameElement()) == null ? null : nameElement.getReference().resolve();
        Object target = resolve instanceof DbElement ? ((DbElement)resolve).getDelegate() : resolve;
        boolean bl = ensureTable = this.getParent() instanceof SqlFromClause || this.getParent() instanceof SqlAsExpression && this.getParent().getParent() instanceof SqlFromClause;
        if (target instanceof SqlFileImpl.FakeDefinition) {
            target = ((SqlFileImpl.FakeDefinition)((Object)target)).delegates().first();
        }
        if (target instanceof DasRoutine) {
            SqlType sqlType = SqlFunctionCallExpressionImpl.createRoutineType(resolve, (DasRoutine)target, ensureTable, (PsiElement)this);
            if (sqlType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
            }
            return sqlType;
        }
        if (target instanceof SqlCreateTypeStatement && (type = ((SqlCreateTypeStatement)target).getSqlType()) != null) {
            SqlTableType sqlTableType = ensureTable ? SqlTableTypeBase.ensureTableType((SqlType)type, (SqlElement)this, (PsiElement)this) : type;
            if (sqlTableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
            }
            return sqlTableType;
        }
        if (target instanceof SqlTypedDefinition) {
            SqlExpression initializer;
            SqlTypedDefinition definition = (SqlTypedDefinition)target;
            SqlTypeElement typeElement = definition.getTypeElement();
            if (typeElement != null) {
                SqlType type3 = typeElement.findSqlType();
                if (type3 == SqlType.UNKNOWN) {
                    SqlType sqlType = SqlImplUtil.getSqlDialectSafe((PsiElement)this).getDefinitionType(definition, nameElement.getTextOffset());
                    if (sqlType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
                    }
                    return sqlType;
                }
                SqlType sqlType = type3;
                if (sqlType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
                }
                return sqlType;
            }
            if (target instanceof SqlVariableDefinition && (initializer = ((SqlVariableDefinition)target).getInitializer()) != null) {
                SqlType sqlType = initializer.getSqlType();
                if (sqlType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
                }
                return sqlType;
            }
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
        }
        return sqlPrimitiveType;
    }

    public static SqlType createRoutineType(@NotNull PsiElement resolve, @NotNull DasRoutine target, boolean ensureTable, @NotNull PsiElement qualifier) {
        if (resolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "createRoutineType"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "createRoutineType"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "createRoutineType"));
        }
        DasArgument retArg = target.getReturnArgument();
        JBIterable outArgs = JBIterable.from((Iterable)target.getArguments()).filter(DasUtil.OUTPUT_ARGUMENT).append((Iterable)ContainerUtil.createMaybeSingletonList((Object)retArg));
        return SqlFunctionCallExpressionImpl.createType(resolve, (Iterable<? extends DasArgument>)outArgs, ensureTable, qualifier);
    }

    @NotNull
    private static SqlType getParamType(SqlElement element) {
        Object object = element instanceof SqlTypeElement ? ((SqlTypeElement)element).findSqlType() : (element instanceof SqlExpression ? ((SqlExpression)element).getSqlType() : SqlType.UNKNOWN);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getParamType"));
        }
        return object;
    }

    private static SqlType createType(@NotNull PsiElement routine2, @NotNull Iterable<? extends DasArgument> args, boolean ensureTable, @NotNull PsiElement qualifier) {
        if (routine2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "createType"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "createType"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "createType"));
        }
        int size = Iterables.size(args);
        ArrayList columns = ContainerUtil.newArrayListWithCapacity((int)size);
        for (DasArgument dasArgument : args) {
            SqlType sqlType;
            SqlTypeElement typeElement = dasArgument instanceof SqlTypedDefinition ? ((SqlTypedDefinition)dasArgument).getTypeElement() : null;
            SqlType sqlType2 = sqlType = typeElement != null ? typeElement.findSqlType() : SqlFunctionCallExpressionImpl.getSqlType(routine2, qualifier, dasArgument.getDataType());
            if (size == 1 && typeElement != null) {
                SqlType res;
                Object object = res = ensureTable ? SqlTableTypeBase.ensureTableType(sqlType, (SqlElement)typeElement, qualifier) : sqlType;
                if (sqlType instanceof SqlTableType) {
                    SqlReferenceExpression element = ((SqlFunctionCallExpression)qualifier).getNameElement();
                    res = ((SqlTableType)res).alias(element != null ? element.getName() : null, qualifier, Collections.emptyList());
                }
                return res;
            }
            columns.add(new SqlImplUtil.Column(dasArgument.getName(), sqlType, (PsiElement)(dasArgument instanceof PsiElement ? (PsiElement)dasArgument : new FakeParameter(qualifier, dasArgument)), null));
        }
        if (!ensureTable && columns.size() == 1) {
            return ((SqlImplUtil.Column)columns.get((int)0)).type;
        }
        return SqlImplUtil.createType(columns, qualifier);
    }

    private static SqlType getSqlType(@NotNull PsiElement routine2, @NotNull PsiElement element, @NotNull DataType dataType) {
        if (routine2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
        }
        if (dataType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
        }
        SqlPrimitiveType primitiveType = SqlType.findByJdbcType((int)dataType.jdbcType);
        if (primitiveType != SqlType.UNKNOWN || dataType == DataType.UNKNOWN) {
            return primitiveType;
        }
        SqlTypeElement type = SqlPsiElementFactory.createDataTypeFromText(dataType.getSpecification(), SqlImplUtil.getSqlDialectSafe(element), routine2, true);
        if ((type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)type, SqlTypeElement.class)) == null) {
            return SqlType.UNKNOWN;
        }
        SqlReferenceImpl.IGNORE_DATA_SOURCES.set((UserDataHolder)type.getContainingFile(), (Object)true);
        return type.findSqlType();
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                SqlReferenceExpression nameElement = SqlFunctionCallExpressionImpl.this.getNameElement();
                return nameElement == null ? null : nameElement.getName();
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return null;
            }
        };
    }

    @Nullable
    public SqlFunctionDefinition getFunctionDefinition() {
        SqlReferenceExpression nameElement = this.getNameElement();
        if (nameElement == null) {
            return null;
        }
        String functionName = nameElement.getName();
        return SqlImplUtil.getSqlDialectSafe((PsiElement)this).getSupportedFunctions().get(functionName);
    }

    @Override
    public ObjectKind getExpectedReferenceTargetType(SqlElement referenceElement) {
        return referenceElement == this.getNameElement() && this.getFirstChild() != this.getLastChild() ? ObjectKind.ROUTINE : super.getExpectedReferenceTargetType(referenceElement);
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (!SqlFunctionCallExpressionImpl.processNamedArgument((Processor<PsiElement>)((Processor)e -> processor.execute(e, state)), this.getNameElement(), place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    public static boolean processNamedArgument(Processor<PsiElement> processor, SqlReferenceExpression ref, PsiElement place) {
        SqlNamedParameterValueExpression expr = (SqlNamedParameterValueExpression)((Object)ObjectUtils.tryCast((Object)(place == null ? null : place.getParent()), SqlNamedParameterValueExpression.class));
        if (expr != null && place == expr.getLOperand()) {
            SqlFunctionCallExpressionImpl.processParameters(ref, processor, place);
            return false;
        }
        return true;
    }

    public static boolean processParameters(@Nullable SqlReferenceExpression fooRef, Processor<PsiElement> processor, final PsiElement place) {
        if (fooRef == null) {
            return true;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)fooRef);
        Case casing = dialect.getCasing((ObjectKind)ObjectKind.ARGUMENT, null).plain;
        SqlFunctionDefinition definition = dialect.getSupportedFunctions().get(fooRef.getName());
        if (definition != null) {
            JBIterable names = ((JBTreeTraverser)new JBTreeTraverser(SqlFunctionCallExpressionImpl::getParameters).withRoots((Iterable)JBIterable.of((Object[])definition.getPrototypes()))).filter(SqlFunctionDefinition.SimpleParameter.class).transform(p -> p.getName());
            for (String name : names) {
                if (processor.process((Object)new FakeParameter((PsiElement)fooRef, casing.apply(name), null){

                    @Override
                    @NotNull
                    public PsiElement getNavigationElement() {
                        PsiElement psiElement = place;
                        if (psiElement == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$2", "getNavigationElement"));
                        }
                        return psiElement;
                    }
                })) continue;
                return false;
            }
        }
        for (ResolveResult res : fooRef.multiResolve(false)) {
            PsiElement origin = res.getElement();
            PsiElement resolve = origin instanceof DbElement ? ((DbElement)origin).getDelegate() : origin;
            DasRoutine routine2 = (DasRoutine)ObjectUtils.tryCast((Object)resolve, DasRoutine.class);
            SqlCursorDefinitionImpl curs = (SqlCursorDefinitionImpl)((Object)ObjectUtils.tryCast((Object)resolve, SqlCursorDefinitionImpl.class));
            if (dialect.getFamilyId().isOracle() && curs != null) {
                for (SqlParameterDefinition parameter : SqlImplUtil.childrenIt((PsiElement)curs).filter(SqlParameterDefinition.class)) {
                    if (processor.process((Object)parameter)) continue;
                    return false;
                }
            }
            if (routine2 == null || dialect.getFamilyId().isTransactSql() && routine2.getRoutineKind() == DasRoutine.Kind.FUNCTION) continue;
            if (resolve instanceof SqlProcedureDefinitionImpl) {
                SqlProcedureDefinitionImpl procedure = (SqlProcedureDefinitionImpl)resolve;
                Iterable<SqlParameterDefinition> parameters = procedure.getArguments();
                for (SqlParameterDefinition parameter : parameters) {
                    if (processor.process((Object)parameter)) continue;
                    return false;
                }
                continue;
            }
            for (SqlParameterDefinition parameter : DasUtil.getParameters((DasRoutine)routine2)) {
                if (processor.process((Object)new FakeParameter((PsiElement)fooRef, casing.apply(parameter.getName()), parameter){

                    @Override
                    @NotNull
                    public PsiElement getNavigationElement() {
                        PsiElement psiElement = place;
                        if (psiElement == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$3", "getNavigationElement"));
                        }
                        return psiElement;
                    }
                })) continue;
                return false;
            }
        }
        return true;
    }

    private static Iterable<? extends SqlFunctionDefinition.Parameter> getParameters(SqlFunctionDefinition.Parameter p) {
        return p instanceof SqlFunctionDefinition.ParameterBlock ? JBIterable.of((Object[])((SqlFunctionDefinition.ParameterBlock)p).getParams()) : JBIterable.empty();
    }

    public static class FakeParameter
    extends SqlFileImpl.FakeDefinition {
        private final PsiElement myParent;
        private final Object myDelegate;

        public FakeParameter(@NotNull PsiElement parent, @NotNull DasArgument parameter) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter", "<init>"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter", "<init>"));
            }
            this(parent, StringUtil.notNullize((String)parameter.getName()), parameter);
        }

        public FakeParameter(@NotNull PsiElement parent, @NotNull String name, @Nullable Object delegate) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter", "<init>"));
            }
            super(parent, name, null);
            this.myParent = parent;
            this.myDelegate = delegate;
        }

        public int getTextOffset() {
            return this.myParent.getTextOffset();
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.ARGUMENT;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter", "getKind"));
            }
            return objectKind;
        }

        @Override
        public String getTypeName() {
            if (this.myDelegate instanceof DasTypedObject) {
                DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe(this.getParent()).getDatabaseDialect();
                return new DdlBuilder().applyCodeStyle(this.getProject()).withDialect(dialect).type((DasTypedObject)this.myDelegate).getStatement();
            }
            return super.getTypeName();
        }

        @Override
        public Icon getIcon() {
            return DatabaseIcons.Col;
        }
    }
}

