/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlStubbedDefinitionImpl<T extends SqlNamedElementStub<?>>
extends SqlStubbedElement<T>
implements SqlDefinition,
ItemPresentation,
StubBasedPsiElement<T> {
    private volatile String myCachedName;
    private volatile short myCachedPosition;

    public SqlStubbedDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl", "<init>"));
        }
        super(node);
        this.myCachedPosition = (short)-1;
    }

    public SqlStubbedDefinitionImpl(T stub) {
        super(stub, stub.getStubType());
        this.myCachedPosition = (short)-1;
    }

    public SqlStubbedDefinitionImpl(T stub, @NotNull IStubElementType nodeType) {
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl", "<init>"));
        }
        super(stub, nodeType);
        this.myCachedPosition = (short)-1;
    }

    public ItemPresentation getPresentation() {
        return this;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return DbPresentation.getIcon((DasObject)this);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        if (this instanceof SqlCreateStatement) {
            visitor.visitSqlCreateStatement((SqlCreateStatement)this);
        } else {
            visitor.visitSqlDefinition((SqlDefinition)this);
        }
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedName = null;
        this.myCachedPosition = (short)-1;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl", "setName"));
        }
        this.getNode();
        SqlNameElement element = this.getNameElement();
        if (element != null) {
            element.setName(name);
        }
        return this;
    }

    @Override
    @NotNull
    public String getName() {
        String cached = this.myCachedName;
        if (cached != null) {
            String string = cached;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl", "getName"));
            }
            return string;
        }
        SqlNameElement element = this.getNameElement();
        String name = element == null ? null : element.getName();
        this.myCachedName = (String)ObjectUtils.notNull((Object)name, (Object)SqlImplUtil.NULL_STRING);
        if (this.myCachedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl", "getName"));
        }
        return this.myCachedName;
    }

    public short getPosition() {
        short cached = this.myCachedPosition;
        if (cached >= 0) {
            return cached;
        }
        short count = 1;
        for (PsiElement element : SqlImplUtil.childrenIt(this.getParent())) {
            if (element == this) {
                short s = count;
                this.myCachedPosition = s;
                return s;
            }
            count = (short)(count + 1);
        }
        this.myCachedPosition = 0;
        return 0;
    }

    @NotNull
    public String getDisplayOrder() {
        String string = String.valueOf(this.getPosition());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl", "getDisplayOrder"));
        }
        return string;
    }

    @Nullable
    protected abstract SqlReferenceElementType getExpectedNameReferenceElementType();

    public SqlNameElement getNameElement() {
        SqlNamedElementStub stub = (SqlNamedElementStub)this.getStub();
        SqlReferenceElementType refType = this.getExpectedNameReferenceElementType();
        if (stub != null) {
            return stub.getNameReference(refType);
        }
        if (refType != null) {
            return (SqlNameElement)this.findChildByType((IElementType)refType);
        }
        return (SqlNameElement)this.findChildByClass(SqlReferenceExpression.class);
    }

    @NotNull
    public ObjectKind getKind() {
        SqlReferenceElementType refType = this.getExpectedNameReferenceElementType();
        if (refType != null) {
            ObjectKind objectKind = refType.getTargetKind();
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl", "getKind"));
            }
            return objectKind;
        }
        SqlNameElement element = this.getNameElement();
        if (!(element instanceof SqlReferenceExpression)) {
            String msg = this.getContainingFile().getLanguage() + "/" + ((Object)((Object)this)).getClass().getSimpleName() + "/" + this.getNode().getElementType() + ": " + element;
            throw new AssertionError((Object)msg);
        }
        ObjectKind objectKind = ((SqlReferenceExpression)element).getReferenceElementType().getTargetKind();
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl", "getKind"));
        }
        return objectKind;
    }

    public String getPresentableText() {
        return StringUtil.notNullize((String)this.getName(), (String)"<unknown>");
    }

    public String getLocationString() {
        return this.getContainingFile().getName();
    }

    public Icon getIcon(boolean open) {
        return this.getIcon();
    }

    public int getTextOffset() {
        this.getNode();
        SqlNameElement nameElement = this.getNameElement();
        if (nameElement != null) {
            return nameElement.getTextOffset();
        }
        return super.getTextOffset();
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getNameElement();
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlExpression qualifier;
        SqlNameElement nameElement = this.getNameElement();
        if (lastParent != nameElement && nameElement instanceof SqlReferenceExpression && PsiTreeUtil.isAncestor((PsiElement)this, (PsiElement)lastParent, (boolean)true) && (qualifier = ((SqlReferenceExpression)nameElement).getQualifierExpression()) instanceof SqlReferenceExpression && !SqlImplUtil.processQualifier((SqlReferenceExpression)qualifier, processor, state, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    @Nullable
    public String getComment() {
        if (this.getStub() != null) {
            return null;
        }
        SqlStringLiteralExpression comment = (SqlStringLiteralExpression)PsiTreeUtil.findChildOfType((PsiElement)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COMMENT_CLAUSE), SqlStringLiteralExpression.class);
        if (comment == null) {
            return null;
        }
        SqlStringTokenElement token = SqlStringLiteralManipulator.getStringToken(comment);
        return token == null ? null : token.getTokenText();
    }

    public DasObject getDbParent() {
        if (this instanceof DasTableChild) {
            return ((DasTableChild)this).getTable();
        }
        Couple<SqlFileImpl.FakeDefinition> m = SqlImplUtil.getMirror(this);
        if (m.first != null) {
            return (DasObject)m.first;
        }
        if (m.second != null) {
            return ((SqlFileImpl.FakeDefinition)((Object)m.second)).getDbParent();
        }
        for (PsiElement e = this.getContext(); e != null; e = e.getContext()) {
            if (e instanceof SqlDefinition) {
                m = SqlImplUtil.getMirror((SqlDefinition)e);
                return m.second != null ? (DasObject)m.second : (DasObject)e;
            }
            if (e instanceof DasObject) {
                return (DasObject)e;
            }
            if (e instanceof SqlFileImpl) {
                return ((SqlFileImpl)e).findDbParent(this);
            }
            if (e instanceof PsiFile) break;
        }
        return null;
    }

    @NotNull
    public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl", "getDbChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl", "getDbChildren"));
        }
        if (this instanceof DasTableChild) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl", "getDbChildren"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = SqlImplUtil.childrenIt((PsiElement)this).filter(DasObject.class).filter(DasUtil.byKind((ObjectKind)kind)).filter(clazz);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl", "getDbChildren"));
        }
        return jBIterable;
    }

    @Nullable
    public PsiReference getReference() {
        SqlIdentifier nameElement = (SqlIdentifier)ObjectUtils.tryCast((Object)this.getNameElement(), SqlIdentifier.class);
        if (nameElement == null) {
            return null;
        }
        PsiReferenceBase ref = PsiReferenceBase.createSelfReference((PsiElement)this, (PsiElement)this);
        ref.setRangeInElement(nameElement.getNameRange().shiftRight(nameElement.getStartOffsetInParent()));
        return ref;
    }
}

