/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.frames;

import java.util.Vector;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpAccept;
import org.w3c.www.http.HttpAcceptCharset;
import org.w3c.www.http.HttpAcceptEncoding;
import org.w3c.www.http.HttpAcceptLanguage;
import org.w3c.www.http.HttpEntityTag;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpInvalidValueException;
import org.w3c.www.http.HttpMessage;
import org.w3c.www.http.HttpTokenList;
import org.w3c.www.mime.LanguageTag;
import org.w3c.www.mime.MimeType;

public class NegotiatedFrame
extends HTTPFrame {
    private static Class httpFrameClass = null;
    private static Class negotiatedFrameClass = null;
    public static String NEGOTIATED_ICON_P;
    public static String DEFAULT_NEGOTIATED_ICON;
    protected static String STATE_NEG;
    private static final boolean debug = false;
    private static final double REQUIRED_QUALITY = 1.0E-4;
    protected HttpTokenList vary = null;
    private boolean vary_done = false;
    protected static int ATTR_VARIANTS;
    protected static int ATTR_PUT_POLICY;
    protected static int ATTR_PARANOID_VARIANT_CHECK;
    private boolean b_charset = true;
    private boolean b_type = true;
    private boolean b_language = true;
    private boolean b_encoding = true;

    public synchronized void setValue(int n, Object object) {
        if (n == ATTR_VARIANTS) {
            super.setValue(n, (Object)this.checkVariants((String[])object));
        } else {
            super.setValue(n, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpTokenList getVary() {
        if (this.vary_done) {
            return this.vary;
        }
        this.vary_done = true;
        this.b_charset = false;
        this.b_type = false;
        this.b_language = false;
        this.b_encoding = false;
        ResourceReference[] resourceReferenceArray = null;
        try {
            resourceReferenceArray = this.getVariantResources();
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
        if (resourceReferenceArray == null || resourceReferenceArray.length < 2) {
            return null;
        }
        NegotiatedFrame negotiatedFrame = this;
        synchronized (negotiatedFrame) {
            Object object;
            int n;
            int n2 = 0;
            HTTPFrame hTTPFrame = null;
            FramedResource framedResource = null;
            do {
                try {
                    framedResource = (FramedResource)resourceReferenceArray[n2].unsafeLock();
                    hTTPFrame = (HTTPFrame)framedResource.getFrame(httpFrameClass);
                }
                catch (InvalidResourceException invalidResourceException) {
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    resourceReferenceArray[n2].unlock();
                }
            } while (hTTPFrame == null && ++n2 < resourceReferenceArray.length);
            if (resourceReferenceArray.length - n2 < 1) {
                return null;
            }
            String string = hTTPFrame.getContentLanguage();
            String string2 = hTTPFrame.getContentEncoding();
            String string3 = hTTPFrame.getCharset();
            MimeType mimeType = hTTPFrame.getContentType();
            HTTPFrame hTTPFrame2 = null;
            for (n = n2; n < resourceReferenceArray.length; ++n) {
                try {
                    framedResource = (FramedResource)resourceReferenceArray[n].unsafeLock();
                    hTTPFrame2 = (HTTPFrame)framedResource.unsafeGetFrame(httpFrameClass);
                    if (string != null) {
                        if (!string.equals(hTTPFrame2.getContentLanguage())) {
                            this.b_language = true;
                        }
                    } else if (hTTPFrame2.getContentLanguage() != null) {
                        this.b_language = true;
                    }
                    if (string2 != null) {
                        if (!string2.equals(hTTPFrame2.getContentEncoding())) {
                            this.b_encoding = true;
                        }
                    } else if (hTTPFrame2.getContentEncoding() != null) {
                        this.b_encoding = true;
                    }
                    if (string3 != null) {
                        if (!string3.equals(hTTPFrame2.getCharset())) {
                            this.b_charset = true;
                        }
                    } else if (hTTPFrame2.getCharset() != null) {
                        this.b_charset = true;
                    }
                    if (mimeType != null) {
                        object = hTTPFrame2.getContentType();
                        if (object == null || mimeType.match((MimeType)object) == 4) continue;
                        this.b_type = true;
                        continue;
                    }
                    if (hTTPFrame2.getContentType() == null) continue;
                    this.b_type = true;
                    continue;
                }
                catch (InvalidResourceException invalidResourceException) {
                    continue;
                }
                finally {
                    resourceReferenceArray[n].unlock();
                }
            }
            n = 0;
            if (this.b_language) {
                ++n;
            }
            if (this.b_charset) {
                ++n;
            }
            if (this.b_encoding) {
                ++n;
            }
            if (this.b_type) {
                ++n;
            }
            if (n == 0) {
                return null;
            }
            object = new String[n];
            n2 = 0;
            if (this.b_type) {
                object[n2++] = "Accept";
            }
            if (this.b_encoding) {
                object[n2++] = "Accept-Encoding";
            }
            if (this.b_language) {
                object[n2++] = "Accept-Language";
            }
            if (this.b_charset) {
                object[n2] = "Accept-Charset";
            }
            this.vary = HttpFactory.makeStringList(object);
        }
        return this.vary;
    }

    public String getIcon() {
        String string = super.getIcon();
        if (string == null) {
            string = this.getServer().getProperties().getString(NEGOTIATED_ICON_P, DEFAULT_NEGOTIATED_ICON);
            this.setValue(ATTR_ICON, (Object)string);
        }
        return string;
    }

    public String[] getVariantNames() {
        return (String[])this.getValue(ATTR_VARIANTS, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] checkVariants(String[] stringArray) {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>(stringArray.length);
        ResourceReference resourceReference = null;
        ResourceReference resourceReference2 = this.resource.getParent();
        try {
            objectArray = (Object[])resourceReference2.unsafeLock();
            for (int i = 0; i < stringArray.length; ++i) {
                resourceReference = objectArray.lookup(stringArray[i]);
                if (resourceReference != null) {
                    try {
                        FramedResource framedResource = (FramedResource)resourceReference.unsafeLock();
                        NegotiatedFrame negotiatedFrame = (NegotiatedFrame)framedResource.getFrame(negotiatedFrameClass);
                        if (negotiatedFrame != null) continue;
                        vector.addElement(stringArray[i]);
                        continue;
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        continue;
                    }
                    finally {
                        resourceReference.unlock();
                    }
                }
                vector.addElement(stringArray[i]);
            }
        }
        catch (InvalidResourceException invalidResourceException) {
        }
        finally {
            resourceReference2.unlock();
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setVariants(String[] stringArray) {
        this.setValue(ATTR_VARIANTS, (Object)stringArray);
        this.vary_done = false;
    }

    public boolean getPutPolicy() {
        Boolean bl = (Boolean)this.getValue(ATTR_PUT_POLICY, null);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void setPutPolicy(Boolean bl) {
        this.setValue(ATTR_PUT_POLICY, (Object)bl);
    }

    public void setPutPolicy(boolean bl) {
        this.setValue(ATTR_PUT_POLICY, (Object)new Boolean(bl));
    }

    public boolean getParanoidVariantCheck() {
        Boolean bl = (Boolean)this.getValue(ATTR_PARANOID_VARIANT_CHECK, (Object)Boolean.FALSE);
        return bl;
    }

    public void setParanoidVariantCheck(boolean bl) {
        this.setValue(ATTR_PARANOID_VARIANT_CHECK, (Object)new Boolean(bl));
    }

    public ResourceReference[] getVariantResources() throws ProtocolException {
        String[] stringArray = this.getVariantNames();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        if (this.getParanoidVariantCheck()) {
            stringArray = this.checkVariants(stringArray);
        }
        ResourceReference[] resourceReferenceArray = new ResourceReference[stringArray.length];
        ResourceReference resourceReference = this.resource.getParent();
        try {
            int n2;
            DirectoryResource directoryResource = (DirectoryResource)resourceReference.unsafeLock();
            int n3 = 0;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                resourceReferenceArray[n2] = directoryResource.lookup(stringArray[n2]);
                if (resourceReferenceArray[n2] != null) continue;
                ++n3;
            }
            if (n3 > 0) {
                n2 = stringArray.length - n3;
                if (n2 < 1) {
                    ResourceReference[] resourceReferenceArray2 = null;
                    return resourceReferenceArray2;
                }
                String[] stringArray2 = new String[n2];
                int n4 = 0;
                int n5 = 0;
                while (n5 < resourceReferenceArray.length) {
                    if (resourceReferenceArray[n5] != null) {
                        stringArray2[n4++] = stringArray[n5++];
                        continue;
                    }
                    ++n5;
                }
                this.setVariants(stringArray2);
                ResourceReference[] resourceReferenceArray3 = this.getVariantResources();
                return resourceReferenceArray3;
            }
            if (n > stringArray.length) {
                this.setVariants(stringArray);
            }
        }
        catch (InvalidResourceException invalidResourceException) {
            throw new HTTPException("invalid parent for negotiation");
        }
        finally {
            resourceReference.unlock();
        }
        return resourceReferenceArray;
    }

    protected void printNegotiationState(String string, Vector vector) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean negotiateContentEncoding(Vector vector, Request request) throws ProtocolException {
        if (!request.hasAcceptEncoding() || !this.b_encoding) {
            for (int i = 0; i < vector.size(); ++i) {
                VariantState variantState = (VariantState)vector.elementAt(i);
                variantState.setContentEncodingQuality(1.0);
            }
        } else {
            HttpAcceptEncoding[] httpAcceptEncodingArray = request.getAcceptEncoding();
            for (int i = 0; i < vector.size(); ++i) {
                VariantState variantState = (VariantState)vector.elementAt(i);
                ResourceReference resourceReference = variantState.getResource();
                try {
                    FramedResource framedResource = (FramedResource)resourceReference.unsafeLock();
                    HTTPFrame hTTPFrame = (HTTPFrame)framedResource.unsafeGetFrame(httpFrameClass);
                    if (hTTPFrame == null) continue;
                    String string = (String)hTTPFrame.unsafeGetValue(ATTR_CONTENT_ENCODING, null);
                    if (string == null) {
                        string = "identity";
                        variantState.setContentEncodingQuality(1.0);
                    } else {
                        variantState.setContentEncodingQuality(0.01);
                    }
                    int n = -1;
                    for (int j = 0; j < httpAcceptEncodingArray.length; ++j) {
                        if (httpAcceptEncodingArray[j].getEncoding().equals(string)) {
                            n = j;
                            break;
                        }
                        if (!httpAcceptEncodingArray[j].getEncoding().equals("*")) continue;
                        n = j;
                    }
                    if (n < 0) continue;
                    variantState.setContentEncodingQuality(httpAcceptEncodingArray[n].getQuality() - (double)n * 0.001);
                    continue;
                }
                catch (InvalidResourceException invalidResourceException) {
                    continue;
                }
                finally {
                    resourceReference.unlock();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean negotiateCharsetQuality(Vector vector, Request request) {
        if (!request.hasAcceptCharset() || !this.b_charset) {
            for (int i = 0; i < vector.size(); ++i) {
                VariantState variantState = (VariantState)vector.elementAt(i);
                variantState.setCharsetQuality(1.0);
            }
        } else {
            HttpAcceptCharset[] httpAcceptCharsetArray = request.getAcceptCharset();
            for (int i = 0; i < vector.size(); ++i) {
                VariantState variantState = (VariantState)vector.elementAt(i);
                ResourceReference resourceReference = variantState.getResource();
                try {
                    FramedResource framedResource = (FramedResource)resourceReference.unsafeLock();
                    HTTPFrame hTTPFrame = (HTTPFrame)framedResource.unsafeGetFrame(httpFrameClass);
                    if (hTTPFrame == null) continue;
                    MimeType mimeType = (MimeType)hTTPFrame.unsafeGetValue(ATTR_CONTENT_TYPE, null);
                    String string = mimeType.getParameterValue("charset");
                    if (string == null) {
                        string = "ISO-8859-1";
                    }
                    double d = 0.0;
                    boolean bl = false;
                    for (int j = 0; j < httpAcceptCharsetArray.length; ++j) {
                        String string2 = httpAcceptCharsetArray[j].getCharset();
                        if (string2.equals("*")) {
                            bl = true;
                            if (d != 0.0) continue;
                            d = httpAcceptCharsetArray[j].getQuality() - 0.001 * (double)j;
                            continue;
                        }
                        if (string2.equals("ISO-8859-1")) {
                            bl = true;
                        }
                        if (!string2.equals(string) || !(httpAcceptCharsetArray[j].getQuality() > d)) continue;
                        d = httpAcceptCharsetArray[j].getQuality() - 0.001 * (double)j;
                    }
                    if (!bl && string.equals("ISO-8859-1")) {
                        d = 1.0 - 0.001 * (double)httpAcceptCharsetArray.length;
                    }
                    variantState.setCharsetQuality(d);
                    continue;
                }
                catch (InvalidResourceException invalidResourceException) {
                    continue;
                }
                finally {
                    resourceReference.unlock();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean negotiateLanguageQuality(Vector vector, Request request) throws ProtocolException {
        if (!request.hasAcceptLanguage() || !this.b_language) {
            for (int i = 0; i < vector.size(); ++i) {
                VariantState variantState = (VariantState)vector.elementAt(i);
                variantState.setLanguageQuality(1.0);
            }
        } else {
            VariantState variantState;
            int n;
            int n2;
            HttpAcceptLanguage[] httpAcceptLanguageArray = request.getAcceptLanguage();
            LanguageTag[] languageTagArray = new LanguageTag[httpAcceptLanguageArray.length];
            for (n2 = 0; n2 < httpAcceptLanguageArray.length; ++n2) {
                languageTagArray[n2] = new LanguageTag(httpAcceptLanguageArray[n2].getLanguage());
            }
            n2 = 0;
            for (n = 0; n < vector.size(); ++n) {
                variantState = (VariantState)vector.elementAt(n);
                ResourceReference resourceReference = variantState.getResource();
                try {
                    FramedResource framedResource = (FramedResource)resourceReference.unsafeLock();
                    HTTPFrame hTTPFrame = (HTTPFrame)framedResource.getFrame(httpFrameClass);
                    if (hTTPFrame == null) continue;
                    String string = (String)hTTPFrame.unsafeGetValue(ATTR_CONTENT_LANGUAGE, null);
                    if (string == null) {
                        variantState.setLanguageQuality(-1.0);
                        continue;
                    }
                    n2 = 1;
                    LanguageTag languageTag = new LanguageTag(string);
                    int n3 = -1;
                    int n4 = -1;
                    for (int i = 0; i < httpAcceptLanguageArray.length; ++i) {
                        int n5 = languageTag.match(languageTagArray[i]);
                        if (n5 <= n3) continue;
                        n3 = n5;
                        n4 = i;
                    }
                    if (n4 < 0) {
                        variantState.setLanguageQuality(0.01);
                        continue;
                    }
                    variantState.setLanguageQuality(httpAcceptLanguageArray[n4].getQuality() - (double)n4 * 0.001);
                    continue;
                }
                catch (InvalidResourceException invalidResourceException) {
                    continue;
                }
                finally {
                    resourceReference.unlock();
                }
            }
            if (n2 != 0) {
                for (n = 0; n < vector.size(); ++n) {
                    variantState = (VariantState)vector.elementAt(n);
                    if (!(variantState.getLanguageQuality() < 0.0)) continue;
                    variantState.setLanguageQuality(0.5);
                }
            } else {
                for (n = 0; n < vector.size(); ++n) {
                    variantState = (VariantState)vector.elementAt(n);
                    variantState.setLanguageQuality(1.0);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean negotiateContentType(Vector vector, Request request) throws ProtocolException {
        if (!request.hasAccept() || !this.b_type) {
            for (int i = 0; i < vector.size(); ++i) {
                VariantState variantState = (VariantState)vector.elementAt(i);
                variantState.setQuality(1.0);
            }
        } else {
            HttpAccept[] httpAcceptArray = request.getAccept();
            for (int i = 0; i < vector.size(); ++i) {
                VariantState variantState = (VariantState)vector.elementAt(i);
                ResourceReference resourceReference = variantState.getResource();
                try {
                    FramedResource framedResource = (FramedResource)resourceReference.unsafeLock();
                    HTTPFrame hTTPFrame = (HTTPFrame)framedResource.unsafeGetFrame(httpFrameClass);
                    if (hTTPFrame == null) continue;
                    MimeType mimeType = (MimeType)hTTPFrame.unsafeGetValue(ATTR_CONTENT_TYPE, null);
                    int n = -1;
                    int n2 = -1;
                    for (int j = 0; j < httpAcceptArray.length; ++j) {
                        try {
                            int n3 = mimeType.match(httpAcceptArray[j].getMimeType());
                            if (n3 <= n) continue;
                            n = n3;
                            n2 = j;
                            continue;
                        }
                        catch (HttpInvalidValueException httpInvalidValueException) {
                            // empty catch block
                        }
                    }
                    if (n2 < 0) {
                        variantState.setQuality(0.0);
                        continue;
                    }
                    variantState.setQuality(httpAcceptArray[n2].getQuality() - (double)n2 * 0.001);
                    continue;
                }
                catch (InvalidResourceException invalidResourceException) {
                    continue;
                }
                finally {
                    resourceReference.unlock();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceReference negotiate(Request request) throws ProtocolException {
        Object object;
        ResourceReference[] resourceReferenceArray = this.getVariantResources();
        if (resourceReferenceArray == null) {
            try {
                this.getResource().delete();
            }
            catch (MultipleLockException multipleLockException) {}
            finally {
                Reply reply = request.makeReply(404);
                reply.setContent("<h1>Document not found</h1><p>The document " + request.getURL() + " has no acceptable variants " + "(probably deleted).");
                throw new HTTPException(reply);
            }
        }
        if (resourceReferenceArray.length < 2) {
            if (resourceReferenceArray.length == 0) {
                try {
                    this.getResource().delete();
                }
                catch (MultipleLockException multipleLockException) {}
                finally {
                    Reply reply = request.makeReply(404);
                    reply.setContent("<h1>Document not found</h1><p>The document " + request.getURL() + " has no acceptable variants " + "(probably deleted).");
                    throw new HTTPException(reply);
                }
            }
            return resourceReferenceArray[0];
        }
        Vector<VariantState> vector = new Vector<VariantState>(resourceReferenceArray.length);
        for (int i = 0; i < resourceReferenceArray.length; ++i) {
            double d = 1.0;
            try {
                object = (FramedResource)resourceReferenceArray[i].unsafeLock();
                HTTPFrame hTTPFrame = (HTTPFrame)((Resource)object).unsafeGetFrame(httpFrameClass);
                if (hTTPFrame == null) continue;
                if (hTTPFrame.unsafeDefinesAttribute(ATTR_QUALITY)) {
                    d = hTTPFrame.unsafeGetQuality();
                }
                if (!(d > 1.0E-4)) continue;
                vector.addElement(new VariantState(resourceReferenceArray[i], d));
                continue;
            }
            catch (InvalidResourceException invalidResourceException) {
                continue;
            }
            finally {
                resourceReferenceArray[i].unlock();
            }
        }
        if (this.negotiateContentEncoding(vector, request)) {
            return ((VariantState)vector.elementAt(0)).getResource();
        }
        if (this.negotiateCharsetQuality(vector, request)) {
            return ((VariantState)vector.elementAt(0)).getResource();
        }
        if (this.negotiateLanguageQuality(vector, request)) {
            return ((VariantState)vector.elementAt(0)).getResource();
        }
        if (this.negotiateContentType(vector, request)) {
            return ((VariantState)vector.elementAt(0)).getResource();
        }
        double d = 1.0E-4;
        int n = 0;
        while (n < vector.size()) {
            object = (VariantState)vector.elementAt(n);
            if (((VariantState)object).getQ() > d) {
                for (int i = n; i > 0; --i) {
                    vector.removeElementAt(0);
                }
                d = ((VariantState)object).getQ();
                n = 1;
                continue;
            }
            if (((VariantState)object).getQ() < d) {
                vector.removeElementAt(n);
                continue;
            }
            ++n;
        }
        if (d == 1.0E-4) {
            Reply reply = request.makeReply(406);
            object = new HtmlGenerator("No acceptable");
            ((HtmlGenerator)object).append("<P>The resource cannot be served according to the headers sent</P>");
            reply.setStream((HtmlGenerator)object);
            throw new HTTPException(reply);
        }
        if (vector.size() == 1) {
            return ((VariantState)vector.elementAt(0)).getResource();
        }
        Reply reply = request.makeReply(300);
        object = new HtmlGenerator("Multiple choice for " + this.resource.getIdentifier());
        ((HtmlGenerator)object).append("<ul>");
        for (int i = 0; i < vector.size(); ++i) {
            VariantState variantState = (VariantState)vector.elementAt(i);
            String string = null;
            ResourceReference resourceReference = variantState.getResource();
            try {
                string = resourceReference.unsafeLock().getIdentifier();
                ((HtmlGenerator)object).append("<li><a href=\"" + string + "\">" + string + "</a>" + " Q= " + variantState.getQ());
                continue;
            }
            catch (InvalidResourceException invalidResourceException) {
                continue;
            }
            finally {
                resourceReference.unlock();
            }
        }
        reply.setStream((HtmlGenerator)object);
        reply.setHeaderValue(Reply.H_VARY, (HeaderValue)this.getVary());
        throw new HTTPException(reply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResourceReference negotiatePut(Request request) throws ProtocolException, ResourceException {
        Object object;
        ResourceReference[] resourceReferenceArray;
        block53: {
            int n;
            String[] stringArray;
            String[] stringArray2;
            int n2;
            Object object2;
            block54: {
                Object object3;
                block52: {
                    resourceReferenceArray = this.getVariantResources();
                    if (resourceReferenceArray == null || resourceReferenceArray.length == 0) {
                        try {
                            this.getResource().delete();
                        }
                        catch (MultipleLockException multipleLockException) {}
                        finally {
                            Reply reply = request.makeReply(404);
                            reply.setContent("<h1>Document not found</h1><p>The document " + request.getURL() + " has no acceptable variants " + "(probably deleted).");
                            throw new HTTPException(reply);
                        }
                    }
                    HttpEntityTag httpEntityTag = request.getETag();
                    object3 = request.getIfMatch();
                    if (object3 == null && httpEntityTag != null) {
                        object3 = new HttpEntityTag[]{httpEntityTag};
                    } else if (httpEntityTag != null) {
                        object2 = new HttpEntityTag[((HttpEntityTag[])object3).length + 1];
                        System.arraycopy(object3, 0, object2, 0, ((HttpEntityTag[])object3).length);
                        object2[((HttpEntityTag[])object3).length] = httpEntityTag;
                        object3 = object2;
                    }
                    if (object3 != null) break block52;
                    if (this.getPutPolicy()) {
                        object2 = request.makeReply(404);
                        ((Reply)object2).setContent("<h1>Document not found</h1><p>The document " + request.getURL() + " has no acceptable variants " + " for a PUT, as no ETags were sent");
                        throw new HTTPException((Reply)object2);
                    }
                    n2 = resourceReferenceArray.length;
                    object2 = request.getContentType();
                    stringArray2 = request.getContentEncoding();
                    stringArray = request.getContentLanguage();
                    if (object2 == null && stringArray2 == null && stringArray == null) break block53;
                    break block54;
                }
                int n3 = 0;
                while (true) {
                    block50: {
                        block49: {
                            if (n3 >= resourceReferenceArray.length) {
                                Reply reply = request.makeReply(404);
                                reply.setContent("<h1>Document not found</h1><p>The document " + request.getURL() + " has no acceptable variants " + "according to the ETag sent");
                                throw new HTTPException(reply);
                            }
                            try {
                                object2 = (FramedResource)resourceReferenceArray[n3].unsafeLock();
                                HTTPFrame hTTPFrame = (HTTPFrame)((Resource)object2).getFrame(httpFrameClass);
                                if (hTTPFrame == null) break block49;
                                HttpEntityTag httpEntityTag = hTTPFrame.getETag();
                                if (httpEntityTag == null) {
                                    resourceReferenceArray[n3].unlock();
                                    break block50;
                                }
                                for (int i = 0; i < ((HttpEntityTag[])object3).length; ++i) {
                                    if (httpEntityTag.getTag().equals(object3[i].getTag())) {
                                        ResourceReference resourceReference = resourceReferenceArray[n3];
                                        resourceReferenceArray[n3].unlock();
                                        return resourceReference;
                                    }
                                    try {
                                        continue;
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        // empty catch block
                                        break;
                                    }
                                }
                            }
                            catch (InvalidResourceException invalidResourceException) {
                                resourceReferenceArray[n3].unlock();
                                catch (Throwable throwable) {
                                    resourceReferenceArray[n3].unlock();
                                    throw throwable;
                                }
                            }
                        }
                        resourceReferenceArray[n3].unlock();
                    }
                    ++n3;
                }
            }
            block29: for (n = 0; n < resourceReferenceArray.length; ++n) {
                if (resourceReferenceArray[n] == null) continue;
                ResourceReference resourceReference = resourceReferenceArray[n];
                try {
                    int n4;
                    this.resource = (FramedResource)resourceReference.unsafeLock();
                    HTTPFrame hTTPFrame = (HTTPFrame)this.resource.getFrame(httpFrameClass);
                    if (hTTPFrame == null) {
                        --n2;
                        resourceReferenceArray[n] = null;
                        continue;
                    }
                    if (object2 != null && ((object = hTTPFrame.getContentType()) == null || ((MimeType)object).match((MimeType)object2) != 4)) {
                        --n2;
                        resourceReferenceArray[n] = null;
                        continue;
                    }
                    if (stringArray != null) {
                        object = hTTPFrame.getContentLanguage();
                        --n2;
                        resourceReferenceArray[n] = null;
                        if (object == null) continue;
                        for (n4 = 0; n4 < stringArray.length; ++n4) {
                            if (!((String)object).equals(stringArray[n4])) continue;
                            ++n2;
                            resourceReferenceArray[n] = resourceReference;
                            break;
                        }
                    }
                    if (stringArray2 == null) continue;
                    object = hTTPFrame.getContentEncoding();
                    --n2;
                    resourceReferenceArray[n] = null;
                    if (object == null) continue;
                    for (n4 = 0; n4 < stringArray2.length; ++n4) {
                        if (!((String)object).equals(stringArray[n4])) continue;
                        ++n2;
                        resourceReferenceArray[n] = resourceReference;
                        continue block29;
                    }
                    continue;
                }
                catch (InvalidResourceException invalidResourceException) {
                    continue;
                }
                finally {
                    resourceReference.unlock();
                }
            }
            if (n2 == 1) {
                for (n = 0; n < resourceReferenceArray.length; ++n) {
                    if (resourceReferenceArray[n] == null) continue;
                    return resourceReferenceArray[n];
                }
            }
            if (n2 <= 0) {
                Reply reply = request.makeReply(404);
                reply.setContent("<h1>Document not found</h1><p>The document " + request.getURL() + " has no acceptable variants " + " for a PUT");
                throw new HTTPException(reply);
            }
        }
        object = request.makeReply(300);
        HtmlGenerator htmlGenerator = new HtmlGenerator("Multiple choice for " + this.resource.getIdentifier());
        htmlGenerator.append("<ul>");
        int n = 0;
        while (true) {
            if (n >= resourceReferenceArray.length) {
                ((Reply)object).setStream(htmlGenerator);
                ((HttpMessage)object).setHeaderValue(Reply.H_VARY, (HeaderValue)this.getVary());
                throw new HTTPException((Reply)object);
            }
            if (resourceReferenceArray[n] != null) {
                try {
                    String string = resourceReferenceArray[n].unsafeLock().getIdentifier();
                    htmlGenerator.append("<li><a href=\"" + string + "\">" + string + "</a>");
                }
                catch (InvalidResourceException invalidResourceException) {
                }
                finally {
                    resourceReferenceArray[n].unlock();
                }
            }
            ++n;
        }
    }

    public void registerResource(FramedResource framedResource) {
        super.registerOtherResource(framedResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lookup(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        ResourceReference resourceReference;
        Object object;
        Object object2;
        if (lookupState.isDirectory() && (object2 = (String)((HttpMessage)(object = (Request)lookupState.getRequest())).getState("org.w3c.jigsaw.frames.HTTPFrame.cl")) == null) {
            lookupResult.setTarget(null);
            return true;
        }
        object = this.getFrames();
        if (object != null) {
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (object[i] == null || !((ResourceFrame)object[i]).lookup(lookupState, lookupResult)) continue;
                return true;
            }
        }
        if (lookupState.hasMoreComponents()) {
            lookupResult.setTarget(null);
            return false;
        }
        object2 = lookupState.getRequest();
        Request request = (Request)object2;
        String string = request.getMethod();
        try {
            resourceReference = string.equals("PUT") ? this.negotiatePut(request) : this.negotiate(request);
        }
        catch (ResourceException resourceException) {
            return false;
        }
        if (resourceReference != null) {
            try {
                FramedResource framedResource = (FramedResource)resourceReference.unsafeLock();
                framedResource.lookup(lookupState, lookupResult);
            }
            catch (InvalidResourceException invalidResourceException) {
            }
            finally {
                resourceReference.unlock();
            }
        }
        request.setState(STATE_NEG, resourceReference);
        lookupResult.setTarget(this.getResourceReference());
        return true;
    }

    public ReplyInterface perform(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        Object object;
        ReplyInterface replyInterface = this.performFrames(requestInterface);
        if (replyInterface != null) {
            return replyInterface;
        }
        if (!this.checkRequest(requestInterface)) {
            return null;
        }
        Request request = (Request)requestInterface;
        ResourceReference resourceReference = request.hasState(STATE_NEG) ? (ResourceReference)request.getState(STATE_NEG) : (((String)(object = request.getMethod())).equals("PUT") ? this.negotiatePut(request) : this.negotiate(request));
        if (resourceReference == null) {
            object = request.makeReply(500);
            ((Reply)object).setContent("Error negotiating among resource's variants.");
            throw new HTTPException((Reply)object);
        }
        try {
            object = (FramedResource)resourceReference.unsafeLock();
            Reply reply = (Reply)((FramedResource)object).perform(request);
            reply.setHeaderValue(Reply.H_VARY, (HeaderValue)this.getVary());
            HTTPFrame hTTPFrame = (HTTPFrame)((Resource)object).unsafeGetFrame(httpFrameClass);
            if (hTTPFrame != null) {
                reply.setContentLocation(hTTPFrame.getURL(request).toExternalForm());
                Reply reply2 = reply;
                return reply2;
            }
            try {
                Reply reply3 = request.makeReply(500);
                reply3.setContent("Error negotiating : selected resource has no HTTPFrame");
                throw new HTTPException(reply3);
            }
            catch (InvalidResourceException invalidResourceException) {
                reply = request.makeReply(500);
                reply.setContent("Error negotiating : Invalid selected resource");
                throw new HTTPException(reply);
            }
        }
        finally {
            resourceReference.unlock();
        }
    }

    static {
        try {
            httpFrameClass = Class.forName("org.w3c.jigsaw.frames.HTTPFrame");
        }
        catch (Exception exception) {
            throw new RuntimeException("No HTTPFrame class found.");
        }
        try {
            negotiatedFrameClass = Class.forName("org.w3c.jigsaw.frames.NegotiatedFrame");
        }
        catch (Exception exception) {
            throw new RuntimeException("No NegotiatedFrame class found.");
        }
        NEGOTIATED_ICON_P = "org.w3c.jigsaw.frames.negotiated.icon";
        DEFAULT_NEGOTIATED_ICON = "generic.gif";
        STATE_NEG = "org.w3c.jigsaw.frames.Negotiated";
        ATTR_VARIANTS = -1;
        ATTR_PUT_POLICY = -1;
        ATTR_PARANOID_VARIANT_CHECK = -1;
        Attribute attribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.frames.NegotiatedFrame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        attribute = new StringArrayAttribute("variants", null, 2);
        ATTR_VARIANTS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new BooleanAttribute("strict_put", new Boolean(true), 2);
        ATTR_PUT_POLICY = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new BooleanAttribute("paranoid_variant_check", new Boolean(false), 2);
        ATTR_PARANOID_VARIANT_CHECK = AttributeRegistry.registerAttribute(clazz, attribute);
    }

    class VariantState {
        ResourceReference variant = null;
        double qs = 0.0;
        double qe = 0.0;
        double qc = 0.0;
        double ql = 0.0;
        double q = 0.0;
        double Q = 0.0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            try {
                Resource resource = this.variant.unsafeLock();
                String string = resource.getIdentifier();
                if (string == null) {
                    string = "<noname>";
                }
                String string2 = "[" + string + " qc=" + this.qc + " qs=" + this.qs + " qe=" + this.qe + " ql=" + this.ql + " q =" + this.q + " Q =" + this.getQ() + "]";
                return string2;
            }
            catch (InvalidResourceException invalidResourceException) {
                String string = "invalid";
                return string;
            }
            finally {
                this.variant.unlock();
            }
        }

        void setCharsetQuality(double d) {
            this.qc = d;
        }

        double getCharsetQuality() {
            return this.qc;
        }

        void setContentEncodingQuality(double d) {
            this.qe = d;
        }

        void setContentEncodingQuality(HttpAcceptEncoding httpAcceptEncoding) {
            this.qe = httpAcceptEncoding.getQuality();
        }

        double getContentEncodingQuality() {
            return this.qe;
        }

        void setQuality(double d) {
            this.q = d;
        }

        void setQuality(HttpAccept httpAccept) {
            this.q = httpAccept.getQuality();
        }

        void setLanguageQuality(double d) {
            this.ql = d;
        }

        void setLanguageQuality(HttpAcceptLanguage httpAcceptLanguage) {
            this.ql = httpAcceptLanguage.getQuality();
        }

        double getLanguageQuality() {
            return this.ql;
        }

        ResourceReference getResource() {
            return this.variant;
        }

        double getQ() {
            return this.qe * this.q * this.qs * this.ql * this.qc;
        }

        VariantState(ResourceReference resourceReference, double d) {
            this.qs = d;
            this.variant = resourceReference;
        }
    }
}

