/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.upgrade;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.w3c.tools.resources.upgrade.StringArrayAttribute;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;

public class MimeTypeArrayAttribute
extends StringArrayAttribute {
    public static String[] toStringArray(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof MimeType[]) {
            MimeType[] mimeTypeArray = (MimeType[])object;
            String[] stringArray = new String[mimeTypeArray.length];
            for (int i = 0; i < mimeTypeArray.length; ++i) {
                stringArray[i] = mimeTypeArray[i].toString();
            }
            return stringArray;
        }
        return null;
    }

    public boolean checkValue(Object object) {
        return object instanceof MimeType[] || object instanceof String[];
    }

    public int getPickleLength(Object object) {
        return super.getPickleLength(MimeTypeArrayAttribute.toStringArray(object));
    }

    public void pickle(DataOutputStream dataOutputStream, Object object) throws IOException {
        super.pickle(dataOutputStream, MimeTypeArrayAttribute.toStringArray(object));
    }

    public Object unpickle(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        MimeType[] mimeTypeArray = new MimeType[n];
        for (int i = 0; i < n; ++i) {
            try {
                mimeTypeArray[i] = new MimeType(dataInputStream.readUTF());
                continue;
            }
            catch (MimeTypeFormatException mimeTypeFormatException) {
                mimeTypeArray[i] = null;
            }
        }
        return mimeTypeArray;
    }

    public MimeTypeArrayAttribute(String string, MimeType[] mimeTypeArray, Integer n) {
        super(string, MimeTypeArrayAttribute.toStringArray(mimeTypeArray), n);
        this.type = "[Lorg.w3c.www.mime.MimeType;";
    }
}

