/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mux;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.www.mux.MuxMessage;
import org.w3c.www.mux.MuxSession;
import org.w3c.www.mux.MuxStream;

class MuxReader
extends Thread {
    private static final boolean debug = true;
    MuxStream stream = null;
    InputStream in = null;
    MuxMessage msg = null;
    MuxMessage nmsg = null;
    protected int msgflags = -1;
    protected int msgsessid = -1;
    protected int msglen = -1;
    protected int msgllen = -1;
    protected int msgpad = -1;
    protected int msgbytes = -1;
    protected boolean msgisctrl = false;
    protected int msgctrlop = -1;
    protected boolean nextAvailable = false;
    protected MuxSession msgsess = null;
    protected byte[] buffer = null;
    protected int midbuflength = -1;
    int bufptr = 0;
    int buflen = 0;
    protected boolean alive = true;

    private final int computeWord(byte by, byte by2, byte by3, byte by4) {
        return (by4 & 0xFF) << 24 | (by3 & 0xFF) << 16 | (by2 & 0xFF) << 8 | by & 0xFF;
    }

    private final boolean parseMuxWord0(byte by, byte by2, byte by3, byte by4, MuxMessage muxMessage) {
        muxMessage.flags = this.computeWord(by, by2, by3, by4);
        muxMessage.sessid = (muxMessage.flags & 0x3FC0000) >> 18;
        muxMessage.len = muxMessage.flags & 0x3FFFF;
        return (muxMessage.flags & Integer.MIN_VALUE) != 0;
    }

    private final void parseMuxWord1(byte by, byte by2, byte by3, byte by4, MuxMessage muxMessage) {
        muxMessage.llen = this.computeWord(by, by2, by3, by4);
    }

    private final boolean setupControlMessage(MuxMessage muxMessage) {
        muxMessage.isctrl = (muxMessage.flags & 0x40000000) == 0x40000000;
        if (muxMessage.isctrl) {
            int n = -1;
            muxMessage.ctrlop = (muxMessage.flags & 0x3C000000) >> 26;
            switch (muxMessage.ctrlop) {
                case 0: {
                    muxMessage.bytes = muxMessage.llen;
                    n = muxMessage.llen & 7;
                    muxMessage.pad = n != 0 ? 8 - n : 0;
                    muxMessage.hsize = 8;
                    break;
                }
                case 1: {
                    muxMessage.bytes = muxMessage.llen;
                    n = muxMessage.llen & 7;
                    muxMessage.pad = n != 0 ? 8 - n : 0;
                    muxMessage.hsize = 8;
                    break;
                }
                case 2: {
                    muxMessage.bytes = 0;
                    muxMessage.pad = 0;
                    muxMessage.hsize = 8;
                    break;
                }
                case 3: {
                    muxMessage.bytes = 0;
                    muxMessage.pad = 0;
                    muxMessage.hsize = 8;
                }
            }
            return true;
        }
        return false;
    }

    private final void setupLongMessage(MuxMessage muxMessage) {
        if (this.setupControlMessage(muxMessage)) {
            return;
        }
        int n = -1;
        muxMessage.bytes = muxMessage.llen;
        n = muxMessage.llen & 7;
        muxMessage.pad = n != 0 ? 8 - n : 0;
        muxMessage.hsize = 8;
    }

    private final void setupMessage(MuxMessage muxMessage) {
        if (this.setupControlMessage(muxMessage)) {
            return;
        }
        if ((muxMessage.flags & 0x20000000) != 0) {
            muxMessage.bytes = 0;
            muxMessage.pad = 0;
        } else {
            int n = -1;
            muxMessage.bytes = muxMessage.len;
            n = muxMessage.len & 3;
            muxMessage.pad = n != 0 ? 4 - n : 0;
        }
        muxMessage.hsize = 4;
    }

    private final void parseMuxHeader(MuxMessage muxMessage) throws IOException {
        while (this.buflen < 4) {
            this.fillBuffer();
        }
        boolean bl = this.parseMuxWord0(this.buffer[this.bufptr], this.buffer[this.bufptr + 1], this.buffer[this.bufptr + 2], this.buffer[this.bufptr + 3], muxMessage);
        if (bl) {
            while (this.buflen < 4) {
                this.fillBuffer();
            }
            this.parseMuxWord1(this.buffer[this.bufptr + 4], this.buffer[this.bufptr + 5], this.buffer[this.bufptr + 6], this.buffer[this.bufptr + 7], muxMessage);
            this.setupLongMessage(muxMessage);
        } else {
            this.setupMessage(muxMessage);
        }
    }

    private final boolean parseMuxHeaderAhead(int n, int n2, MuxMessage muxMessage) {
        int n3 = -1;
        if (n2 < 4) {
            return false;
        }
        boolean bl = this.parseMuxWord0(this.buffer[n], this.buffer[n + 1], this.buffer[n + 2], this.buffer[n + 3], muxMessage);
        if (bl) {
            if (n2 < 8) {
                return false;
            }
            this.parseMuxWord1(this.buffer[n + 4], this.buffer[n + 5], this.buffer[n + 6], this.buffer[n + 7], muxMessage);
            this.setupLongMessage(muxMessage);
        } else {
            this.setupMessage(muxMessage);
        }
        return true;
    }

    private final void setCurrent(MuxMessage muxMessage) {
        this.msgflags = muxMessage.flags;
        this.msgsessid = muxMessage.sessid;
        this.msglen = muxMessage.len;
        this.msgllen = muxMessage.llen;
        this.msgpad = muxMessage.pad;
        this.msgbytes = muxMessage.bytes;
        this.msgisctrl = muxMessage.isctrl;
        this.msgctrlop = muxMessage.ctrlop;
    }

    private final void fillBuffer() throws IOException {
        if (this.buflen == 0) {
            this.bufptr = 0;
        } else if (this.bufptr > this.midbuflength) {
            System.arraycopy(this.buffer, this.bufptr, this.buffer, 0, this.buflen);
            this.bufptr = 0;
        }
        int n = this.bufptr + this.buflen;
        int n2 = this.in.read(this.buffer, n, this.buffer.length - n);
        if (n2 > 0) {
            this.buflen += n2;
            System.out.println("MuxReader.fillBuffer: " + this.buflen + " bytes.");
        } else if (n2 < 0) {
            this.stream.error((Object)this, "Gracefull close.");
            throw new EOFException("Gracefull close.");
        }
        System.out.println("MuxReader: got " + n2 + " bytes.");
    }

    protected void readMessage() throws IOException {
        int n = -1;
        if (this.nextAvailable) {
            this.setCurrent(this.nmsg);
            this.bufptr += this.nmsg.hsize;
            this.buflen -= this.nmsg.hsize;
            this.nextAvailable = false;
        } else {
            this.parseMuxHeader(this.msg);
            this.bufptr += this.msg.hsize;
            this.buflen -= this.msg.hsize;
            this.setCurrent(this.msg);
        }
        int n2 = this.bufptr + this.msgbytes + this.msgpad;
        this.nextAvailable = n2 < this.bufptr + this.buflen;
        if (this.nextAvailable) {
            this.nextAvailable = this.parseMuxHeaderAhead(n2, this.bufptr + this.buflen - n2, this.nmsg);
        }
        System.out.println("[readMessage] bufptr=" + this.bufptr + ", f=" + Integer.toString(this.msgflags, 16) + ", i=" + this.msgsessid + ", l=" + this.msglen + ", s=" + this.msgbytes);
    }

    private final int readMessageBody() throws IOException {
        System.out.println("readMessageBody: " + this.msgbytes + " bytes avail.");
        if (this.msgbytes > 0) {
            if (this.buflen <= 0) {
                this.fillBuffer();
            }
            if (this.msgbytes > this.buflen) {
                this.msgbytes -= this.buflen;
                return this.buflen;
            }
            int n = this.msgbytes;
            this.msgbytes = 0;
            return n;
        }
        if (this.msgpad > 0) {
            while (this.buflen <= this.msgpad) {
                this.fillBuffer();
            }
            this.bufptr += this.msgpad;
            this.buflen -= this.msgpad;
        }
        return 0;
    }

    protected String msgToString() throws IOException {
        if (this.buffer.length < this.msglen) {
            throw new RuntimeException("String doesn't hold in buffer !");
        }
        while (this.buflen < this.msglen) {
            this.fillBuffer();
        }
        String string = new String(this.buffer, 0, this.bufptr, this.msglen);
        this.bufptr += this.msglen;
        this.buflen -= this.msglen;
        return string;
    }

    protected int[] msgShortArrayToIntArray() throws IOException {
        if (this.buffer.length < this.msglen) {
            throw new RuntimeException("ShortArray doesn't hold in buffer !");
        }
        while (this.buflen < this.msglen) {
            this.fillBuffer();
        }
        int[] nArray = new int[this.msglen >> 1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (this.buffer[this.bufptr] | this.buffer[this.bufptr + 1] << 8) & 0xFFFF;
            this.bufptr += 2;
        }
        this.buflen -= this.msglen;
        return nArray;
    }

    protected void handleControlMessage() throws IOException {
        switch (this.msgctrlop) {
            case 0: {
                String string = this.msgToString();
                this.stream.ctrlDefineString(this.msglen, string);
                break;
            }
            case 1: {
                int[] nArray = this.msgShortArrayToIntArray();
                this.stream.ctrlDefineStack(this.msgsessid, nArray);
                break;
            }
            case 2: {
                this.stream.ctrlMuxControl(this.msgsessid, this.msglen);
                break;
            }
            case 3: {
                this.stream.ctrlSendCredit(this.msgsessid, this.msgllen);
            }
        }
    }

    protected void dispatchMessage() throws IOException {
        block6: {
            block4: {
                block5: {
                    this.msgsess = this.stream.lookupSession(this.msgflags, this.msgsessid, this.msglen, this.msgllen);
                    if (this.msgsess == null) break block4;
                    if (!this.msgisctrl) break block5;
                    this.handleControlMessage();
                    break block6;
                }
                boolean bl = this.nextAvailable && this.nmsg.sessid == this.msgsessid;
                int n = 0;
                while ((n = this.readMessageBody()) > 0) {
                    this.msgsess.pushInput(this.buffer, this.bufptr, n, bl);
                    this.bufptr += n;
                    this.buflen -= n;
                }
                if ((this.msgflags & 0x10000000) == 0x10000000) {
                    this.msgsess.notifyFIN();
                }
                if ((this.msgflags & 0x8000000) == 0x8000000) {
                    this.msgsess.notifyRST();
                }
                if ((this.msgflags & 0x4000000) != 0x4000000) break block6;
                this.msgsess.notifyPUSH();
                break block6;
            }
            int n = -1;
            while ((n = this.readMessageBody()) > 0) {
                this.bufptr += n;
                this.buflen -= n;
            }
        }
    }

    protected synchronized void shutdown() {
        this.alive = false;
        this.buffer = null;
        this.stop();
    }

    public void run() {
        try {
            while (this.alive) {
                this.readMessage();
                this.dispatchMessage();
                this.msgflags = 0;
                this.msgsessid = 0;
                this.msglen = 0;
                this.msgllen = 0;
                this.msgpad = 0;
                this.msgisctrl = false;
                this.msgctrlop = -1;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            this.stream.error((Object)this, iOException);
        }
    }

    MuxReader(MuxStream muxStream, InputStream inputStream) throws IOException {
        this.stream = muxStream;
        this.in = inputStream;
        this.buffer = new byte[4096];
        this.bufptr = 0;
        this.buflen = 0;
        this.midbuflength = 2048;
        this.msg = new MuxMessage();
        this.nmsg = new MuxMessage();
        this.setName("MuxReader");
    }
}

