/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.ResolvingConverter;
import org.jetbrains.annotations.Nullable;

public abstract class IncludeFileResolvingConverter
extends ResolvingConverter<PsiFile>
implements CustomReferenceConverter {
    public String toString(@Nullable PsiFile psiFile, ConvertContext context) {
        if (psiFile == null) {
            return null;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        VirtualFile root = IncludeFileResolvingConverter.getRootForFile(file, context);
        if (root == null) {
            return null;
        }
        return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
    }

    @Nullable
    private static VirtualFile getRootForFile(VirtualFile file, ConvertContext context) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)context.getPsiManager().getProject()).getFileIndex();
        VirtualFile root = projectFileIndex.getSourceRootForFile(file);
        if (root == null) {
            root = projectFileIndex.getContentRootForFile(file);
        }
        return root;
    }
}

