/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.impl.SpringCachedModelFactory;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalAnnotationModelImpl
extends LocalAnnotationModel {
    @NotNull
    private final PsiClass myClass;
    @NotNull
    private final Module myModule;
    private Set<String> myActiveProfiles;
    private CachedValue<Set<CommonSpringModel>> myLocalRelatedModels;

    public LocalAnnotationModelImpl(@NotNull PsiClass aClass, @NotNull Module module) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "<init>"));
        }
        this.myActiveProfiles = ContainerUtil.newLinkedHashSet();
        this.myClass = aClass;
        this.myModule = module;
    }

    @NotNull
    public PsiClass getConfig() {
        PsiClass psiClass = this.myClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getConfig"));
        }
        return psiClass;
    }

    protected Collection<SpringBeanPointer> calculateLocalBeans() {
        Set beans = (Set)RecursionManager.createGuard((String)"LocalAnnotationModel#calculateAllBeans").doPreventingRecursion((Object)this.myClass, true, () -> {
            LinkedHashSet allBeans = ContainerUtil.newLinkedHashSet();
            ContainerUtil.addIfNotNull((Collection)allBeans, (Object)LocalAnnotationModelImpl.getBeanForClass(this.myClass));
            allBeans.addAll(SpringJamUtils.getInstance().getContextBeans(this.myClass, this.getActiveProfiles()));
            return BeanService.getInstance().mapSpringBeans((Collection)allBeans);
        });
        return beans == null ? Collections.emptySet() : beans;
    }

    @Nullable
    private static CommonSpringBean getBeanForClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getBeanForClass"));
        }
        JamPsiMemberSpringBean psiMemberSpringBean = (JamPsiMemberSpringBean)JamService.getJamService((Project)aClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)aClass);
        if (psiMemberSpringBean != null) {
            return psiMemberSpringBean;
        }
        if (!aClass.isInterface() && !aClass.hasModifierProperty("abstract") && SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)aClass)) {
            return new CustomSpringComponent(aClass);
        }
        return null;
    }

    public Iterable<CommonSpringModel> getRelatedModels() {
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        models.addAll(this.getOrCreateLocalRelatedModels());
        models.add(this.getCustomDiscoveredBeansModel());
        return models;
    }

    @NotNull
    private Set<CommonSpringModel> getOrCreateLocalRelatedModels() {
        if (this.myLocalRelatedModels == null) {
            this.myLocalRelatedModels = CachedValuesManager.getManager((Project)this.getConfig().getProject()).createCachedValue(() -> {
                LinkedHashSet models = ContainerUtil.newLinkedHashSet();
                Set localModels = this.getRelatedLocalModels();
                models.addAll(localModels);
                models.addAll(this.getPackageScanModels(Collections.singleton(this), this.myModule, this.myActiveProfiles));
                models.addAll(LocalAnnotationModelImpl.getInnerStaticClassConfigurations(this.getConfig(), this.getModule()));
                return CachedValueProvider.Result.create((Object)models, (Object[])ArrayUtil.mergeArrays((Object[])this.getOutsideModelDependencies((LocalModel)this), (Object[])this.getConfigs(localModels)));
            }, false);
        }
        Set set = (Set)this.myLocalRelatedModels.getValue();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getOrCreateLocalRelatedModels"));
        }
        return set;
    }

    public static Set<CommonSpringModel> getInnerStaticClassConfigurations(@NotNull PsiClass config, @NotNull Module module) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getInnerStaticClassConfigurations"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getInnerStaticClassConfigurations"));
        }
        HashSet models = ContainerUtil.newHashSet();
        for (PsiClass psiClass : config.getAllInnerClasses()) {
            if (!psiClass.hasModifierProperty("static") || JamService.getJamService((Project)psiClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)psiClass) == null) continue;
            ContainerUtil.addIfNotNull((Collection)models, (Object)SpringManager.getInstance((Project)module.getProject()).getLocalSpringModel(psiClass, module));
        }
        return models;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getModule"));
        }
        return module;
    }

    @NotNull
    public Set<String> getAllProfiles() {
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        LinkedHashSet allProfiles = ContainerUtil.newLinkedHashSet();
        SpringConfiguration configuration = this.getConfiguration();
        if (configuration != null) {
            LocalAnnotationModelImpl.processConfigurationProfiles(allProfiles, configuration);
        }
        for (PsiClass psiClass : SpringJamUtils.getInstance().getImportedClasses(this.myClass, this.getModule())) {
            for (SpringConfiguration springConfiguration : service.getAnnotatedMembersList(psiClass, SpringConfiguration.JAM_KEY, true, false, false, true)) {
                LocalAnnotationModelImpl.processConfigurationProfiles(allProfiles, springConfiguration);
            }
        }
        LinkedHashSet linkedHashSet = allProfiles;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getAllProfiles"));
        }
        return linkedHashSet;
    }

    private static void processConfigurationProfiles(Set<String> allProfiles, SpringConfiguration configuration) {
        allProfiles.addAll(configuration.getProfile().getNames());
        for (SpringJavaBean bean : configuration.getBeans()) {
            allProfiles.addAll(bean.getProfile().getNames());
        }
    }

    @NotNull
    public Set<PsiFile> getConfigFiles() {
        LinkedHashSet files = ContainerUtil.newLinkedHashSet();
        if (this.myClass.isValid()) {
            files.add(this.myClass.getContainingFile());
            files.addAll(SpringJamUtils.getInstance().getImportedResources(this.myClass, new Module[]{this.myModule}));
        }
        LinkedHashSet linkedHashSet = files;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getConfigFiles"));
        }
        return linkedHashSet;
    }

    public boolean hasConfigFile(final @NotNull PsiFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "hasConfigFile"));
        }
        if (!this.myClass.isValid()) {
            return false;
        }
        if (configFile instanceof PsiClassOwner && this.myClass.getContainingFile().equals(configFile)) {
            return true;
        }
        if (!(configFile instanceof XmlFile)) {
            return false;
        }
        CommonProcessors.FindProcessor<Pair<List<XmlFile>, ? extends PsiElement>> hasConfigFileProcessor = new CommonProcessors.FindProcessor<Pair<List<XmlFile>, ? extends PsiElement>>(){

            protected boolean accept(Pair<List<XmlFile>, ? extends PsiElement> pair) {
                return ((List)pair.first).contains(configFile);
            }
        };
        SpringJamUtils.getInstance().processImportedResources(this.myClass, (Processor)hasConfigFileProcessor, new Module[]{this.myModule});
        return hasConfigFileProcessor.isFound();
    }

    @Nullable
    public SpringConfiguration getConfiguration() {
        return (SpringConfiguration)JamService.getJamService((Project)this.myClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)this.myClass);
    }

    @NotNull
    public List<? extends SpringBeansPackagesScan> getComponentScans() {
        List packageScans = ContainerUtil.newSmartList();
        packageScans.addAll(SpringJamUtils.getInstance().getBeansPackagesScan(this.myClass));
        for (PsiClass superClass : InheritanceUtil.getSuperClasses((PsiClass)this.myClass)) {
            if ("java.lang.Object".equals(superClass.getQualifiedName())) continue;
            packageScans.addAll(SpringJamUtils.getInstance().getBeansPackagesScan(superClass));
        }
        List list = packageScans;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getComponentScans"));
        }
        return list;
    }

    public void setActiveProfiles(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "setActiveProfiles"));
        }
        this.myActiveProfiles = activeProfiles;
    }

    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getActiveProfiles"));
        }
        return set;
    }

    @NotNull
    public Set<Pair<LocalModel, LocalModelDependency>> getDependentLocalModels() {
        Module module = this.getModule();
        if (module.isDisposed()) {
            Set<Pair<LocalModel, LocalModelDependency>> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getDependentLocalModels"));
            }
            return set;
        }
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        SpringJamUtils.getInstance().processImportedResources(this.myClass, pair -> {
            if (models == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "lambda$getDependentLocalModels$2"));
            }
            for (XmlFile xmlFile : (List)pair.first) {
                LocalAnnotationModelImpl.addNotNullModel((Set)models, (LocalModel)SpringCachedModelFactory.getOrCreateLocalXmlModel(xmlFile, module, this.getActiveProfiles()), (LocalModelDependency)LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.IMPORT, (PsiElement)((PsiElement)pair.second)));
            }
            return true;
        }, new Module[]{this.myModule});
        SpringJamUtils.getInstance().processImportedClasses(this.myClass, pair -> {
            if (models == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "lambda$getDependentLocalModels$3"));
            }
            LocalAnnotationModelImpl.addNotNullModel((Set)models, (LocalModel)this.getLocalAnnotationModel((PsiClass)pair.first), (LocalModelDependency)LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.IMPORT, (PsiElement)((PsiElement)pair.second)));
            return true;
        });
        LocalAnnotationModelImpl.processScannedConfigurations(this.myClass, (Processor<Pair<PsiPackage, ? extends PsiElement>>)((Processor)pair -> {
            if (models == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "lambda$getDependentLocalModels$4"));
            }
            if (module.isDisposed()) {
                return false;
            }
            GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            GlobalSearchScope searchScope = moduleScope.intersectWith(PackageScope.packageScope((PsiPackage)((PsiPackage)pair.first), (boolean)true));
            List configurations = SpringJamModel.getModel((Module)module).getConfigurations(searchScope);
            for (SpringConfiguration configuration : configurations) {
                if (!SpringProfileUtils.isProfileAccepted((SpringProfile)configuration.getProfile(), this.getActiveProfiles())) continue;
                PsiElement identifyingElementForDependency = (PsiElement)pair.second;
                LocalModelDependency dependency = LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.COMPONENT_SCAN, (PsiElement)(identifyingElementForDependency == null ? (PsiElement)pair.first : identifyingElementForDependency));
                LocalAnnotationModelImpl.addNotNullModel((Set)models, (LocalModel)this.getLocalAnnotationModel(configuration), (LocalModelDependency)dependency);
            }
            return true;
        }));
        SpringJamUtils.getInstance().processCustomAnnotations(this.myClass, enableAnnotation -> {
            if (models == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "lambda$getDependentLocalModels$5"));
            }
            LocalAnnotationModelImpl.addNotNullModel((Set)models, (LocalModel)this.getLocalAnnotationModel((PsiClass)enableAnnotation.getFirst()), (LocalModelDependency)((LocalModelDependency)enableAnnotation.getSecond()));
            return true;
        });
        SpringJamUtils.getInstance().processCustomDependentLocalModels((LocalAnnotationModel)this, (model, dependency) -> {
            if (models == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "lambda$getDependentLocalModels$6"));
            }
            LocalAnnotationModelImpl.addNotNullModel((Set)models, (LocalModel)model, (LocalModelDependency)dependency);
            return true;
        });
        LinkedHashSet linkedHashSet = models;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getDependentLocalModels"));
        }
        return linkedHashSet;
    }

    @Nullable
    private LocalAnnotationModel getLocalAnnotationModel(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getLocalAnnotationModel"));
        }
        return SpringCachedModelFactory.getOrCreateLocalAnnotationModel(aClass, this.getModule(), this.getActiveProfiles());
    }

    @Nullable
    protected LocalAnnotationModel getLocalAnnotationModel(@NotNull SpringConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getLocalAnnotationModel"));
        }
        return SpringCachedModelFactory.getOrCreateLocalAnnotationModel(configuration, this.getModule(), this.getActiveProfiles());
    }

    private static boolean processScannedConfigurations(@NotNull PsiClass classToProcess, @NotNull Processor<Pair<PsiPackage, ? extends PsiElement>> processor) {
        if (classToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classToProcess", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "processScannedConfigurations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "processScannedConfigurations"));
        }
        List scans = SpringJamUtils.getInstance().getBeansPackagesScan(classToProcess);
        for (SpringBeansPackagesScan packagesScan : scans) {
            if (packagesScan instanceof SpringComponentScan) {
                SpringComponentScan componentScan = (SpringComponentScan)packagesScan;
                if (componentScan.processPsiPackages(processor)) continue;
                return false;
            }
            for (PsiPackage aPackage : packagesScan.getPsiPackages()) {
                if (processor.process((Object)Pair.create((Object)aPackage, (Object)packagesScan.getIdentifyingPsiElement()))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalAnnotationModelImpl)) {
            return false;
        }
        LocalAnnotationModelImpl model = (LocalAnnotationModelImpl)((Object)o);
        if (!this.myClass.equals(model.myClass)) {
            return false;
        }
        if (!this.myModule.equals(model.myModule)) {
            return false;
        }
        return SpringProfileUtils.profilesAsString(this.myActiveProfiles).equals(SpringProfileUtils.profilesAsString(model.myActiveProfiles));
    }

    public int hashCode() {
        int result = this.myClass.hashCode();
        result = 31 * result + this.myModule.hashCode();
        result = 31 * result + SpringProfileUtils.profilesAsString(this.myActiveProfiles).hashCode();
        return result;
    }
}

