/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.ui.JBColor;
import icons.SpringApiIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringNodeGroupRealizer
extends NodesGroup {
    @NotNull
    private String myGroupName;

    public SpringNodeGroupRealizer(@NotNull String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/intellij/spring/contexts/model/diagram/SpringNodeGroupRealizer", "<init>"));
        }
        this.myGroupName = groupName;
    }

    @NotNull
    public String getGroupName() {
        String string = this.myGroupName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/SpringNodeGroupRealizer", "getGroupName"));
        }
        return string;
    }

    @Nullable
    public GroupNodeRealizer getGroupNodeRealizer() {
        GroupNodeRealizer groupNodeRealizer = GraphManager.getGraphManager().createGroupNodeRealizer();
        groupNodeRealizer.setInnerGraphDisplayEnabled(true);
        groupNodeRealizer.setAutoBoundsEnabled(true);
        groupNodeRealizer.setLabelText(this.getGroupName());
        groupNodeRealizer.setOpenGroupIcon(SpringApiIcons.FileSet);
        groupNodeRealizer.setClosedGroupIcon(SpringApiIcons.FileSet);
        groupNodeRealizer.setFillColor(null);
        groupNodeRealizer.setLineColor(JBColor.foreground());
        groupNodeRealizer.setLineType(LineType.DASHED_DOTTED_1);
        NodeLabel label = groupNodeRealizer.getLabel();
        label.setBackgroundColor(null);
        label.setTextColor(JBColor.foreground());
        return groupNodeRealizer;
    }

    public boolean isClosed() {
        return false;
    }

    public void setClosed(boolean closed) {
    }

    @Nullable
    public NodesGroup getParent() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SpringNodeGroupRealizer realizer = (SpringNodeGroupRealizer)((Object)o);
        return this.myGroupName.equals(realizer.myGroupName);
    }

    public int hashCode() {
        return this.myGroupName.hashCode();
    }
}

