/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringConfigurationTabSettings;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetEditorCustomization;
import com.intellij.spring.facet.SpringFileSetImpl;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.facet.editor.FileSetEditor;
import com.intellij.spring.facet.nodes.ConfigFileNode;
import com.intellij.spring.facet.nodes.DependencyNode;
import com.intellij.spring.facet.nodes.FileSetNode;
import com.intellij.spring.facet.nodes.FilesetGroupNode;
import com.intellij.spring.facet.searchers.CodeConfigSearcher;
import com.intellij.spring.facet.searchers.XmlConfigSearcher;
import com.intellij.spring.facet.validation.FileSetDependenciesValidator;
import com.intellij.spring.facet.validation.FilesetContainsConfigFilesInTestsSourceValidator;
import com.intellij.spring.facet.validation.UnmappedConfigurationFilesValidator;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringConfigurationTab
extends FacetEditorTab
implements Disposable {
    private final JPanel myMainPanel;
    private final SimpleTree myTree;
    private final SpringConfigurationTabSettings myConfigurationTabSettings;
    private final SpringFacet myFacet;
    private final FacetEditorContext myContext;
    private final FacetValidatorsManager myValidatorsManager;
    private final Set<SpringFileSet> myBuffer = new LinkedHashSet<SpringFileSet>();
    private final SimpleTreeBuilder myBuilder;
    private boolean myModified;
    private final SimpleNode myRoot = new SimpleNode(){

        public SimpleNode[] getChildren() {
            ArrayList<FileSetNode> nodes = new ArrayList<FileSetNode>(SpringConfigurationTab.this.myBuffer.size());
            for (SpringFileSet springFileSet : SpringConfigurationTab.this.myBuffer) {
                if (springFileSet.isRemoved()) continue;
                FileSetNode fileSetNode = new FileSetNode(springFileSet, SpringConfigurationTab.this.myConfigurationTabSettings, this);
                nodes.add(fileSetNode);
            }
            return nodes.toArray(new SimpleNode[nodes.size()]);
        }

        public boolean isAutoExpandNode() {
            return true;
        }
    };

    SpringConfigurationTab(FacetEditorContext context, FacetValidatorsManager validatorsManager) {
        this.myFacet = (SpringFacet)context.getFacet();
        this.myConfigurationTabSettings = SpringConfigurationTabSettings.getInstance(context.getProject());
        this.myContext = context;
        this.myValidatorsManager = validatorsManager;
        SimpleTreeStructure structure = new SimpleTreeStructure(){

            public Object getRootElement() {
                return SpringConfigurationTab.this.myRoot;
            }
        };
        this.myTree = new SimpleTree();
        this.myTree.setRootVisible(false);
        this.myTree.getEmptyText().setText(SpringBundle.message("config.no.contexts.defined", new Object[0]));
        this.myBuilder = new SimpleTreeBuilder((JTree)this.myTree, (DefaultTreeModel)this.myTree.getModel(), (AbstractTreeStructure)structure, null);
        this.myBuilder.initRoot();
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)this.myTree).setAddAction((AnActionButtonRunnable)new CreateApplicationContextAction()).setRemoveAction((AnActionButtonRunnable)new RemoveSelectedNodesAction()).setRemoveActionUpdater(e -> this.getCurrentFileSet() != null).setEditAction((AnActionButtonRunnable)new EditApplicationContextAction(this.myFacet)).setEditActionUpdater(e -> {
            SpringFileSet fileSet = this.getCurrentFileSet();
            return fileSet != null && !fileSet.isAutodetected();
        }).disableUpDownActions();
        Set allFileSets = SpringFileSetService.getInstance().getAllSets(this.myFacet);
        ActionGroup additionalSettingsActionGroup = this.getAdditionalSettingsActionGroup(allFileSets);
        if (additionalSettingsActionGroup != null) {
            decorator.addExtraAction(AnActionButton.fromAction((AnAction)additionalSettingsActionGroup));
        }
        for (final SpringFileSetEditorCustomization customization : (SpringFileSetEditorCustomization[])SpringFileSetEditorCustomization.EP_NAME.getExtensions()) {
            for (SpringFileSet fileSet : allFileSets) {
                if (!customization.isApplicable(fileSet)) continue;
                for (AnAction extraAction : customization.getExtraActions()) {
                    AnActionButton.AnActionButtonWrapper extraActionButton = new AnActionButton.AnActionButtonWrapper(extraAction.getTemplatePresentation(), extraAction){

                        public void actionPerformed(AnActionEvent e) {
                            super.actionPerformed(e);
                            SpringFileSet set = SpringConfigurationTab.this.getCurrentFileSet();
                            assert (set != null);
                            assert (set.isAutodetected());
                            SpringConfigurationTab.this.myBuffer.remove(set);
                            ((SpringFacetConfiguration)SpringConfigurationTab.this.myFacet.getConfiguration()).setModified();
                            for (SpringFileSet fileSet : SpringFileSetService.getInstance().getModelProviderSets(SpringConfigurationTab.this.myFacet)) {
                                if (!fileSet.getId().equals(set.getId())) continue;
                                SpringConfigurationTab.this.myBuffer.add(fileSet);
                                break;
                            }
                            SpringConfigurationTab.this.myModified = true;
                            SpringConfigurationTab.this.myBuilder.queueUpdate();
                            SpringConfigurationTab.this.validateFileSetConfiguration();
                        }
                    };
                    extraActionButton.addCustomUpdater(new AnActionButtonUpdater(){

                        public boolean isEnabled(AnActionEvent e) {
                            SpringFileSet currentFileSet = SpringConfigurationTab.this.getCurrentFileSet();
                            if (currentFileSet == null || !currentFileSet.isAutodetected()) {
                                return false;
                            }
                            DataManager.getInstance().saveInDataContext(e.getDataContext(), SpringFileSetEditorCustomization.EXTRA_ACTION_FILESET, (Object)currentFileSet);
                            return customization.isApplicable(currentFileSet);
                        }
                    });
                    decorator.addExtraAction((AnActionButton)extraActionButton);
                }
            }
        }
        this.myMainPanel = decorator.createPanel();
        ActionToolbar displaySettingsToolbar = ActionManager.getInstance().createActionToolbar("SpringFacetDisplaySettingsToolbar", this.getDisplaySettingsActionGroup(), false);
        this.myMainPanel.add((Component)displaySettingsToolbar.getComponent(), "East");
        FileSetDependenciesValidator dependenciesValidator = new FileSetDependenciesValidator(this.myBuffer);
        this.myValidatorsManager.registerValidator((FacetEditorValidator)dependenciesValidator, new JComponent[0]);
        UnmappedConfigurationFilesValidator unmappedConfigurationFilesValidator = new UnmappedConfigurationFilesValidator(this.myContext.getModule());
        this.myValidatorsManager.registerValidator((FacetEditorValidator)unmappedConfigurationFilesValidator, new JComponent[0]);
        FilesetContainsConfigFilesInTestsSourceValidator containsTestConfigsValidator = new FilesetContainsConfigFilesInTestsSourceValidator(this.myContext.getModule(), this.myBuffer);
        this.myValidatorsManager.registerValidator((FacetEditorValidator)containsTestConfigsValidator, new JComponent[0]);
    }

    @NotNull
    private Set<CustomSetting> getCustomSettings() {
        Set set = ((SpringFacetConfiguration)this.myFacet.getConfiguration()).getCustomSettings();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringConfigurationTab", "getCustomSettings"));
        }
        return set;
    }

    @Nullable
    private ActionGroup getAdditionalSettingsActionGroup(Set<SpringFileSet> allFileSets) {
        LinkedHashSet<CustomSetting> allCustomSettings = new LinkedHashSet<CustomSetting>(this.getCustomSettings());
        block0: for (SpringFileSetEditorCustomization customization : (SpringFileSetEditorCustomization[])SpringFileSetEditorCustomization.EP_NAME.getExtensions()) {
            List customSettings = customization.getCustomSettings();
            allCustomSettings.removeAll(customSettings);
            for (SpringFileSet set : allFileSets) {
                if (!customization.isApplicable(set)) continue;
                allCustomSettings.addAll(customSettings);
                continue block0;
            }
        }
        MyCheckedActionGroup actionGroup = new MyCheckedActionGroup(new CheckAction[0]);
        for (CustomSetting setting : allCustomSettings) {
            if (!(setting instanceof CustomSetting.BOOLEAN)) continue;
            actionGroup.add((AnAction)new CheckAction((CustomSetting.BOOLEAN)setting));
        }
        if (actionGroup.getChildrenCount() == 0) {
            return null;
        }
        actionGroup.getTemplatePresentation().setText(SpringBundle.message("configuration.tab.additional.settings", new Object[0]));
        actionGroup.getTemplatePresentation().setIcon(AllIcons.General.Settings);
        return actionGroup;
    }

    private ActionGroup getDisplaySettingsActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ToggleAction(IdeBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), IdeBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted){

            public boolean isSelected(AnActionEvent e) {
                return SpringConfigurationTab.this.myConfigurationTabSettings.isSortAlpha();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                SpringConfigurationTab.this.myConfigurationTabSettings.setSortAlpha(state);
                SpringConfigurationTab.this.myBuilder.queueUpdate();
            }
        });
        group.addSeparator();
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)this.myTree);
        group.add(actionManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)this.myTree));
        group.add(actionManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)this.myTree));
        return group;
    }

    private void remove() {
        Set nodes = this.myBuilder.getSelectedElements(SimpleNode.class);
        for (SimpleNode node : nodes) {
            SpringFileSet fileSet;
            if (node instanceof DependencyNode) {
                fileSet = SpringConfigurationTab.getFileSetForNode(node);
                fileSet.removeDependency(((DependencyNode)node).getFileSet());
                continue;
            }
            if (node instanceof FileSetNode) {
                fileSet = ((FileSetNode)node).getFileSet();
                int result = Messages.showYesNoDialog((Component)this.myMainPanel, (String)SpringBundle.message("facet.context.remove.message", fileSet.getName()), (String)SpringBundle.message("facet.context.remove.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result != 0) continue;
                if (fileSet.isAutodetected()) {
                    fileSet.setRemoved(true);
                    this.myBuffer.add(fileSet);
                } else {
                    this.myBuffer.remove(fileSet);
                }
                for (SpringFileSet set : this.myBuffer) {
                    set.removeDependency(fileSet);
                }
                continue;
            }
            if (node instanceof FilesetGroupNode) {
                fileSet = SpringConfigurationTab.getFileSetForNode(node);
                if (fileSet.isAutodetected()) continue;
                Set<VirtualFilePointer> filePointers = ((FilesetGroupNode)node).getFilePointers();
                for (VirtualFilePointer filePointer : filePointers) {
                    fileSet.removeFile(filePointer);
                }
                continue;
            }
            if (!(node instanceof ConfigFileNode) || (fileSet = SpringConfigurationTab.getFileSetForNode(node)).isAutodetected()) continue;
            VirtualFilePointer filePointer = ((ConfigFileNode)node).getFilePointer();
            fileSet.removeFile(filePointer);
        }
        this.myModified = true;
        this.myBuilder.queueUpdate().doWhenDone(() -> {
            this.myTree.clearSelection();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTree, true));
        });
    }

    @NotNull
    private static SpringFileSet getFileSetForNode(SimpleNode node) {
        FileSetNode fileSetNode = SpringConfigurationTab.getFileSetNodeFor(node);
        assert (fileSetNode != null);
        SpringFileSet springFileSet = fileSetNode.getFileSet();
        if (springFileSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringConfigurationTab", "getFileSetForNode"));
        }
        return springFileSet;
    }

    @Nullable
    private SpringFileSet getCurrentFileSet() {
        SimpleNode node = this.myTree.getSelectedNode();
        FileSetNode currentFileSetNode = SpringConfigurationTab.getFileSetNodeFor(node);
        return currentFileSetNode == null ? null : currentFileSetNode.getFileSet();
    }

    @Nullable
    private static FileSetNode getFileSetNodeFor(@Nullable SimpleNode node) {
        while (node != null) {
            if (node instanceof FileSetNode) {
                return (FileSetNode)node;
            }
            node = node.getParent();
        }
        return null;
    }

    public String getHelpTopic() {
        return "reference.settings.project.modules.spring.facet";
    }

    @Nls
    public String getDisplayName() {
        return SpringBundle.message("config.display.name", new Object[0]);
    }

    @NotNull
    public JComponent createComponent() {
        JComponent jComponent = DumbService.getInstance((Project)this.myContext.getProject()).wrapGently((JComponent)this.myMainPanel, (Disposable)this);
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringConfigurationTab", "createComponent"));
        }
        return jComponent;
    }

    public boolean isModified() {
        for (CustomSetting setting : this.getCustomSettings()) {
            if (!setting.isModified()) continue;
            return true;
        }
        return this.myModified;
    }

    public void apply() {
        if (this.myFacet.isDisposed()) {
            return;
        }
        this.myFacet.removeFileSets();
        for (SpringFileSet fileSet : this.myBuffer) {
            if (fileSet.isAutodetected() && (!fileSet.isAutodetected() || !fileSet.isRemoved())) continue;
            this.myFacet.addFileSet(fileSet);
        }
        ((SpringFacetConfiguration)this.myFacet.getConfiguration()).setModified();
        for (CustomSetting setting : this.getCustomSettings()) {
            setting.apply();
        }
        this.myModified = false;
        this.validateFileSetConfiguration();
    }

    public void reset() {
        this.myBuffer.clear();
        Set sets = SpringFileSetService.getInstance().getAllSets(this.myFacet);
        for (SpringFileSet fileSet : sets) {
            this.myBuffer.add(new SpringFileSetImpl(fileSet));
        }
        this.myBuilder.queueUpdate();
        this.myTree.setSelectionRow(0);
        for (CustomSetting setting : this.getCustomSettings()) {
            setting.reset();
        }
        this.myModified = false;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myBuilder);
        Disposer.dispose((Disposable)this);
    }

    private void selectFileSet(SpringFileSet fileSet) {
        this.myTree.select((AbstractTreeBuilder)this.myBuilder, simpleNode -> simpleNode instanceof FileSetNode && ((FileSetNode)simpleNode).getFileSet().equals((Object)fileSet), false);
    }

    public void dispose() {
    }

    private void validateFileSetConfiguration() {
        this.myValidatorsManager.validate();
    }

    @NotNull
    private FileSetEditor createFileSetEditor(@NotNull SpringFileSet fileSet) {
        if (fileSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSet", "com/intellij/spring/facet/SpringConfigurationTab", "createFileSetEditor"));
        }
        FileSetEditor fileSetEditor = new FileSetEditor(this.myMainPanel, this.myContext.getModule(), fileSet, this.myBuffer, new XmlConfigSearcher(this.myContext.getModule()), new CodeConfigSearcher(this.myContext.getModule()));
        if (fileSetEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringConfigurationTab", "createFileSetEditor"));
        }
        return fileSetEditor;
    }

    private static class CheckAction
    extends ToggleAction {
        private final CustomSetting.BOOLEAN myBean;

        private CheckAction(CustomSetting.BOOLEAN bean) {
            super(bean.getDescription());
            this.myBean = bean;
        }

        public CustomSetting.BOOLEAN getBean() {
            return this.myBean;
        }

        public boolean isSelected(AnActionEvent e) {
            Boolean value = this.myBean.getValue();
            return value == null ? this.myBean.getDefaultValue() : value.booleanValue();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myBean.setBooleanValue(state);
        }
    }

    private static class MyCheckedActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        public MyCheckedActionGroup(CheckAction ... actions) {
            super((AnAction[])actions);
            this.setPopup(true);
        }
    }

    private class RemoveSelectedNodesAction
    implements AnActionButtonRunnable {
        private RemoveSelectedNodesAction() {
        }

        public void run(AnActionButton button) {
            SpringConfigurationTab.this.remove();
            SpringConfigurationTab.this.validateFileSetConfiguration();
        }
    }

    private class EditApplicationContextAction
    implements AnActionButtonRunnable {
        private final SpringFacet mySpringFacet;

        private EditApplicationContextAction(SpringFacet springFacet) {
            this.mySpringFacet = springFacet;
        }

        public void run(AnActionButton button) {
            SpringFileSet fileSet = SpringConfigurationTab.this.getCurrentFileSet();
            if (fileSet != null) {
                FileSetEditor editor = SpringConfigurationTab.this.createFileSetEditor(fileSet);
                editor.show();
                if (editor.getExitCode() == 0) {
                    SpringConfigurationTab.this.myModified = true;
                    SpringConfigurationTab.this.myBuffer.remove(fileSet);
                    SpringFileSet edited = editor.getEditedFileSet();
                    Disposer.register((Disposable)this.mySpringFacet, (Disposable)edited);
                    SpringConfigurationTab.this.myBuffer.add(edited);
                    edited.setAutodetected(false);
                    SpringConfigurationTab.this.myBuilder.queueUpdate().doWhenDone(() -> SpringConfigurationTab.this.selectFileSet(edited));
                    SpringConfigurationTab.this.validateFileSetConfiguration();
                }
            }
        }
    }

    private class CreateApplicationContextAction
    implements AnActionButtonRunnable {
        private CreateApplicationContextAction() {
        }

        public void run(AnActionButton button) {
            SpringFileSetService fileSetService = SpringFileSetService.getInstance();
            String uniqueId = fileSetService.getUniqueId(SpringConfigurationTab.this.myBuffer);
            String uniqueName = fileSetService.getUniqueName(SpringBundle.message("facet.context.default.name", new Object[0]), SpringConfigurationTab.this.myBuffer);
            SpringFileSetImpl fileSet = new SpringFileSetImpl(uniqueId, uniqueName, SpringConfigurationTab.this.myFacet){

                public boolean isNew() {
                    return true;
                }
            };
            FileSetEditor editor = SpringConfigurationTab.this.createFileSetEditor(fileSet);
            editor.show();
            if (editor.getExitCode() == 0) {
                SpringFileSet editedFileSet = editor.getEditedFileSet();
                Disposer.register((Disposable)SpringConfigurationTab.this.myFacet, (Disposable)editedFileSet);
                SpringConfigurationTab.this.myBuffer.add(editedFileSet);
                SpringConfigurationTab.this.myModified = true;
                SpringConfigurationTab.this.myBuilder.queueUpdate().doWhenDone(() -> SpringConfigurationTab.this.selectFileSet(fileSet));
                SpringConfigurationTab.this.validateFileSetConfiguration();
            }
        }
    }
}

