/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBaseBeanPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleSpringBeanPointer<T extends CommonSpringBean>
extends SpringBaseBeanPointer<T> {
    @NotNull
    private final T mySpringBean;

    public SimpleSpringBeanPointer(@NotNull T springBean) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/SimpleSpringBeanPointer", "<init>"));
        }
        super(springBean.getBeanName(), springBean.getPsiManager().getProject());
        this.mySpringBean = springBean;
    }

    @NotNull
    public T getSpringBean() {
        T t = this.mySpringBean;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SimpleSpringBeanPointer", "getSpringBean"));
        }
        return t;
    }

    @Nullable
    public PsiElement getPsiElement() {
        T springBean = this.getSpringBean();
        return springBean.isValid() ? springBean.getIdentifyingPsiElement() : null;
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof SimpleSpringBeanPointer && this.mySpringBean.equals(((SimpleSpringBeanPointer)o).mySpringBean);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mySpringBean.hashCode();
        return result;
    }

    @Nullable
    public PsiClass getBeanClass() {
        return this.isValid() ? PsiTypesUtil.getPsiClass((PsiType)this.getSpringBean().getBeanType()) : null;
    }

    @NotNull
    public PsiFile getContainingFile() {
        PsiFile psiFile = this.getSpringBean().getContainingFile();
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SimpleSpringBeanPointer", "getContainingFile"));
        }
        return psiFile;
    }

    public boolean isValid() {
        return this.getSpringBean().isValid();
    }
}

