/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.Idref;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringElementsHolder;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringMap;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.spring.model.xml.beans.TypeHolder;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.AddDomElementQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.RemoveDomElementQuickFix;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectionValueConsistencyInspection
extends SpringBeanInspectionBase {
    @NonNls
    private static final String PROPERTY = SpringBundle.message("spring.bean.property", new Object[0]);
    @NonNls
    private static final String ARG = SpringBundle.message("spring.bean.constructor.arg", new Object[0]);
    @NonNls
    private static final String ENTRY = SpringBundle.message("spring.bean.map.entry", new Object[0]);

    protected SpringModelVisitor createVisitor(final DomElementAnnotationHolder holder, @NotNull Beans beans, @Nullable CommonSpringModel model) {
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection", "createVisitor"));
        }
        return new SpringModelVisitor(){

            protected boolean visitProperty(SpringPropertyDefinition property) {
                if (property instanceof SpringValueHolder) {
                    InjectionValueConsistencyInspection.checkValueHolder((SpringValueHolder)property, holder, PROPERTY);
                }
                return true;
            }

            protected boolean visitConstructorArg(ConstructorArg arg) {
                InjectionValueConsistencyInspection.checkValueHolder((SpringValueHolder)arg, holder, ARG);
                return true;
            }

            protected boolean visitMapEntry(SpringEntry entry) {
                InjectionValueConsistencyInspection.checkMapEntry(holder, entry);
                return true;
            }

            protected boolean visitRef(SpringRef ref) {
                InjectionValueConsistencyInspection.checkRef(ref, holder);
                return true;
            }

            protected boolean visitIdref(Idref idref) {
                InjectionValueConsistencyInspection.checkIdref(idref, holder);
                return true;
            }
        };
    }

    private static void checkValueHolder(SpringValueHolder valueHolder, DomElementAnnotationHolder holder, String elementName) {
        boolean hasRefAttribute = DomUtil.hasXml((DomElement)valueHolder.getRefAttr());
        boolean hasValueAttribute = DomUtil.hasXml((DomElement)valueHolder.getValueAttr());
        Set<DomElement> values = InjectionValueConsistencyInspection.getValues((SpringElementsHolder)valueHolder);
        if (!hasRefAttribute && !hasValueAttribute && values.size() == 0) {
            InjectionValueConsistencyInspection.reportNoValue(valueHolder, holder, elementName);
        } else if (hasRefAttribute && hasValueAttribute || (hasRefAttribute || hasValueAttribute) && values.size() > 0) {
            String message = SpringBundle.message("spring.bean.property.value.inconsistency.ref.or.value.subelemet.must.defined", elementName);
            if (hasValueAttribute) {
                InjectionValueConsistencyInspection.reportAttribute((DomElement)valueHolder.getValueAttr(), holder, message);
            }
            if (hasRefAttribute) {
                InjectionValueConsistencyInspection.reportAttribute((DomElement)valueHolder.getRefAttr(), holder, message);
            }
            InjectionValueConsistencyInspection.reportSubtags(values, holder, message);
        } else if (values.size() > 1) {
            String message = SpringBundle.message("spring.bean.property.value.inconsistency.more.one.subelement", elementName);
            InjectionValueConsistencyInspection.reportSubtags(values, holder, message);
        }
    }

    private static void checkMapEntry(DomElementAnnotationHolder holder, SpringEntry entry) {
        boolean hasKeyAttr = DomUtil.hasXml((DomElement)entry.getKeyAttr());
        boolean hasKeyElement = DomUtil.hasXml((DomElement)entry.getKey());
        boolean hasKeyRef = DomUtil.hasXml((DomElement)entry.getKeyRef());
        if (!(hasKeyAttr || hasKeyElement || hasKeyRef)) {
            holder.createProblem((DomElement)entry, SpringBundle.message("model.inspection.injection.value.entry.key", new Object[0]), new LocalQuickFix[0]).highlightWholeElement();
        } else if (hasKeyAttr && hasKeyElement || hasKeyAttr && hasKeyRef || hasKeyElement && hasKeyRef) {
            String message = SpringBundle.message("spring.bean.property.value.inconsistency.key", new Object[0]);
            if (hasKeyAttr) {
                InjectionValueConsistencyInspection.reportAttribute((DomElement)entry.getKeyAttr(), holder, message);
            }
            if (hasKeyElement) {
                InjectionValueConsistencyInspection.reportAttribute((DomElement)entry.getKey(), holder, message);
            }
            if (hasKeyRef) {
                InjectionValueConsistencyInspection.reportAttribute((DomElement)entry.getKeyRef(), holder, message);
            }
        }
        InjectionValueConsistencyInspection.checkValueHolder((SpringValueHolder)entry, holder, ENTRY);
    }

    private static void checkRef(SpringRef ref, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml((DomElement)ref)) {
            return;
        }
        boolean hasBean = DomUtil.hasXml((DomElement)ref.getBean());
        boolean hasLocal = DomUtil.hasXml((DomElement)ref.getLocal());
        boolean hasParent = DomUtil.hasXml((DomElement)ref.getParentAttr());
        if (!(hasBean || hasLocal || hasParent)) {
            holder.createProblem((DomElement)ref, HighlightSeverity.ERROR, SpringBundle.message("spring.bean.ref.attributes.must.specify", new Object[0]), new LocalQuickFix[]{new AddRefFix((GenericDomValue)ref.getBean()), new AddRefFix((GenericDomValue)ref.getLocal()), new AddRefFix((GenericDomValue)ref.getParentAttr())}).highlightWholeElement();
        } else if (hasBean && hasLocal || hasBean && hasParent || hasLocal && hasParent) {
            String message = SpringBundle.message("spring.bean.ref.attributes.inconsistency", new Object[0]);
            InjectionValueConsistencyInspection.reportAttribute((DomElement)ref.getBean(), holder, message);
            InjectionValueConsistencyInspection.reportAttribute((DomElement)ref.getLocal(), holder, message);
            InjectionValueConsistencyInspection.reportAttribute((DomElement)ref.getParentAttr(), holder, message);
        }
    }

    private static void checkIdref(Idref ref, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml((DomElement)ref)) {
            return;
        }
        boolean hasBean = DomUtil.hasXml((DomElement)ref.getBean());
        boolean hasLocal = DomUtil.hasXml((DomElement)ref.getLocal());
        if (!hasBean && !hasLocal) {
            holder.createProblem((DomElement)ref, HighlightSeverity.ERROR, SpringBundle.message("spring.bean.idref.attributes.must.specify", new Object[0]), new LocalQuickFix[]{new AddRefFix((GenericDomValue)ref.getBean()), new AddRefFix((GenericDomValue)ref.getLocal())}).highlightWholeElement();
        } else if (hasBean && hasLocal) {
            String message = SpringBundle.message("spring.bean.idref.attributes.inconsistency", new Object[0]);
            InjectionValueConsistencyInspection.reportAttribute((DomElement)ref.getBean(), holder, message);
            InjectionValueConsistencyInspection.reportAttribute((DomElement)ref.getLocal(), holder, message);
        }
    }

    @NotNull
    private static Set<DomElement> getValues(SpringElementsHolder elementsHolder) {
        THashSet values = new THashSet((Collection)DomUtil.getDefinedChildrenOfType((DomElement)elementsHolder, DomSpringBean.class, (boolean)true, (boolean)false));
        InjectionValueConsistencyInspection.addValue((DomElement)elementsHolder.getIdref(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue((DomElement)elementsHolder.getList(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue((DomElement)elementsHolder.getMap(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue((DomElement)elementsHolder.getNull(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue((DomElement)elementsHolder.getProps(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue((DomElement)elementsHolder.getRef(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue((DomElement)elementsHolder.getSet(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue((DomElement)elementsHolder.getValue(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue((DomElement)elementsHolder.getArray(), (Set<DomElement>)values);
        THashSet tHashSet = values;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection", "getValues"));
        }
        return tHashSet;
    }

    private static void addValue(DomElement valueElement, @NotNull Set<DomElement> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection", "addValue"));
        }
        if (DomUtil.hasXml((DomElement)valueElement)) {
            values.add(valueElement);
        }
    }

    private static void reportSubtags(@NotNull Set<DomElement> values, DomElementAnnotationHolder holder, String message) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection", "reportSubtags"));
        }
        for (DomElement value : values) {
            holder.createProblem(value, HighlightSeverity.ERROR, message, new LocalQuickFix[]{new RemoveDomElementQuickFix(value)}).highlightWholeElement();
        }
    }

    private static void reportAttribute(DomElement element, DomElementAnnotationHolder holder, String message) {
        if (DomUtil.hasXml((DomElement)element)) {
            holder.createProblem(element, HighlightSeverity.ERROR, message, new LocalQuickFix[]{new RemoveDomElementQuickFix(element)}).highlightWholeElement();
        }
    }

    private static void reportNoValue(SpringValueHolder injection, DomElementAnnotationHolder holder, String elementName) {
        List types = TypeHolderUtil.getRequiredTypes((TypeHolder)injection);
        ArrayList<AddDomElementQuickFix> quickFixes = new ArrayList<AddDomElementQuickFix>();
        quickFixes.add(new AddDomElementQuickFix((DomElement)injection.getValueAttr()));
        for (PsiType type : types) {
            if (type instanceof PsiClassType) {
                PsiClass psiClass = ((PsiClassType)type).resolve();
                quickFixes.add(0, new AddRefFix((GenericDomValue)injection.getRefAttr(), psiClass));
                if (psiClass == null) continue;
                Project project = psiClass.getProject();
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                GlobalSearchScope scope = ProjectScope.getAllScope((Project)project);
                PsiClass listClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(List.class.getName(), scope);
                if (listClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)listClass, (boolean)true)) {
                    quickFixes.add(0, new AddListOrSetFix.List(injection.getList()));
                    continue;
                }
                PsiClass mapClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(Map.class.getName(), scope);
                if (mapClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)mapClass, (boolean)true)) {
                    quickFixes.add(0, new AddMapFix(injection.getMap()));
                    continue;
                }
                PsiClass setClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(Set.class.getName(), scope);
                if (setClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)setClass, (boolean)true)) continue;
                quickFixes.add(0, new AddListOrSetFix.Set(injection.getSet()));
                continue;
            }
            if (!(type instanceof PsiArrayType)) continue;
            quickFixes.add(0, new AddListOrSetFix.Array(injection.getArray()));
            quickFixes.add(0, new AddListOrSetFix.Set(injection.getSet()));
            quickFixes.add(0, new AddListOrSetFix.List(injection.getList()));
        }
        holder.createProblem((DomElement)injection, HighlightSeverity.ERROR, SpringBundle.message("model.inspection.injection.value.message", elementName), quickFixes.toArray(new LocalQuickFix[quickFixes.size()])).highlightWholeElement();
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringInjectionValueConsistencyInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection", "getShortName"));
        }
        return "SpringInjectionValueConsistencyInspection";
    }

    private static class AddMapFix
    extends AddDomElementQuickFix<SpringMap> {
        public AddMapFix(SpringMap map) {
            super((DomElement)map);
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("model.inspection.injection.value.add.map", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddMapFix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddMapFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddMapFix", "applyFix"));
            }
            ((SpringMap)this.myElement).addEntry();
        }
    }

    private static abstract class AddListOrSetFix
    extends AddDomElementQuickFix<ListOrSet> {
        public AddListOrSetFix(@NotNull ListOrSet listOrSet) {
            if (listOrSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOrSet", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddListOrSetFix", "<init>"));
            }
            super((DomElement)listOrSet);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddListOrSetFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddListOrSetFix", "applyFix"));
            }
            SpringValue value = ((ListOrSet)this.myElement).addValue();
            value.setStringValue("x");
            value.setStringValue("");
            PsiNavigateUtil.navigate((PsiElement)value.getXmlTag());
        }

        private static class Array
        extends AddListOrSetFix {
            public Array(@NotNull ListOrSet listOrSet) {
                if (listOrSet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOrSet", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddListOrSetFix$Array", "<init>"));
                }
                super(listOrSet);
            }

            @NotNull
            public String getName() {
                String string = SpringBundle.message("model.inspection.injection.value.add.array", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddListOrSetFix$Array", "getName"));
                }
                return string;
            }
        }

        private static class Set
        extends AddListOrSetFix {
            public Set(@NotNull ListOrSet listOrSet) {
                if (listOrSet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOrSet", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddListOrSetFix$Set", "<init>"));
                }
                super(listOrSet);
            }

            @NotNull
            public String getName() {
                String string = SpringBundle.message("model.inspection.injection.value.add.set", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddListOrSetFix$Set", "getName"));
                }
                return string;
            }
        }

        private static class List
        extends AddListOrSetFix {
            public List(@NotNull ListOrSet listOrSet) {
                if (listOrSet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOrSet", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddListOrSetFix$List", "<init>"));
                }
                super(listOrSet);
            }

            @NotNull
            public String getName() {
                String string = SpringBundle.message("model.inspection.injection.value.add.list", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddListOrSetFix$List", "getName"));
                }
                return string;
            }
        }
    }

    private static class AddRefFix
    extends AddDomElementQuickFix<GenericDomValue> {
        @Nullable
        private final SmartPsiElementPointer<PsiClass> myPsiClassPointer;

        public AddRefFix(@NotNull GenericDomValue ref) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddRefFix", "<init>"));
            }
            this(ref, null);
        }

        public AddRefFix(@NotNull GenericDomValue ref, @Nullable PsiClass psiClass) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddRefFix", "<init>"));
            }
            super((DomElement)ref);
            this.myPsiClassPointer = psiClass == null ? null : SmartPointerManager.getInstance((Project)psiClass.getProject()).createSmartPsiElementPointer((PsiElement)psiClass);
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("model.inspection.injection.value.add.ref", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddRefFix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddRefFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/InjectionValueConsistencyInspection$AddRefFix", "applyFix"));
            }
            super.applyFix(project, descriptor);
            if (this.myPsiClassPointer == null) {
                return;
            }
            PsiClass psiClass = (PsiClass)this.myPsiClassPointer.getElement();
            if (psiClass != null) {
                SpringModelSearchParameters.BeanClass searchParameters;
                List list;
                XmlElement element = ((GenericDomValue)this.myElement).getXmlElement();
                assert (element != null);
                XmlFile xmlFile = (XmlFile)element.getContainingFile();
                SpringModel model = SpringManager.getInstance((Project)project).getSpringModelByFile((PsiFile)xmlFile);
                if (model != null && (list = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)(searchParameters = SpringModelSearchParameters.byClass((PsiClass)psiClass).withInheritors().effectiveBeanTypes()))).size() == 1) {
                    ((GenericDomValue)this.myElement).setStringValue(SpringBeanCoreUtils.getReferencedName((SpringBeanPointer)list.get(0), model.getAllCommonBeans()));
                }
            }
        }
    }
}

