/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.ResolvedConstructorArgs;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.ShowBeansQuickFix;
import com.intellij.spring.model.highlighting.SpringAutowireUtil;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.PsiTypeUtil;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.DefaultableBoolean;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAutowiringInspection
extends SpringBeanInspectionBase {
    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringBeanAutowiringInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowiringInspection", "getShortName"));
        }
        return "SpringBeanAutowiringInspection";
    }

    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel model) {
        DefaultableBoolean autoWireCandidate;
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/SpringAutowiringInspection", "checkBean"));
        }
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/highlighting/SpringAutowiringInspection", "checkBean"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/SpringAutowiringInspection", "checkBean"));
        }
        if (model == null) {
            return;
        }
        GenericAttributeValue autowireCandidateAttribute = springBean.getAutowireCandidate();
        if (DomUtil.hasXml((DomElement)autowireCandidateAttribute) && (autoWireCandidate = (DefaultableBoolean)autowireCandidateAttribute.getValue()) != null && !autoWireCandidate.getBooleanValue().booleanValue()) {
            return;
        }
        SpringAutowiringInspection.checkAutowiring(springBean, model, holder);
    }

    private static void checkAutowiring(@NotNull SpringBean springBean, @NotNull CommonSpringModel model, DomElementAnnotationHolder holder) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/SpringAutowiringInspection", "checkAutowiring"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/highlighting/SpringAutowiringInspection", "checkAutowiring"));
        }
        Autowire autowire = springBean.getBeanAutowire();
        if (autowire.equals((Object)Autowire.BY_TYPE)) {
            SpringAutowiringInspection.checkByTypeAutowire(springBean, model, holder);
        } else if (autowire.equals((Object)Autowire.CONSTRUCTOR)) {
            SpringAutowiringInspection.checkByConstructorAutowire(springBean, holder);
        }
    }

    private static void checkByConstructorAutowire(@NotNull SpringBean springBean, @NotNull DomElementAnnotationHolder holder) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/SpringAutowiringInspection", "checkByConstructorAutowire"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/SpringAutowiringInspection", "checkByConstructorAutowire"));
        }
        if (PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType()) == null) {
            return;
        }
        ResolvedConstructorArgs resolvedArgs = springBean.getResolvedConstructorArgs();
        if (resolvedArgs.isResolved()) {
            return;
        }
        for (PsiMethod checkedMethod : resolvedArgs.getCheckedMethods()) {
            Map autowiredParams = resolvedArgs.getAutowiredParams(checkedMethod);
            if (autowiredParams == null || autowiredParams.size() <= 0) continue;
            Set entries = autowiredParams.entrySet();
            for (Map.Entry entry : entries) {
                SpringAutowiringInspection.checkAutowire(springBean, holder, checkedMethod, (PsiParameter)entry.getKey(), (Collection)entry.getValue());
            }
        }
    }

    private static void checkAutowire(SpringBean springBean, DomElementAnnotationHolder holder, PsiMethod checkedMethod, PsiParameter psiParameter, Collection<SpringBeanPointer> springBeans) {
        PsiType psiType = psiParameter.getType();
        if (springBeans != null && springBeans.size() > 1 && !PsiTypeUtil.getInstance((Project)psiParameter.getProject()).isCollectionType(psiType) && !(psiType instanceof PsiArrayType)) {
            ArrayList<String> beanNames = new ArrayList<String>();
            for (SpringBeanPointer pointer : springBeans) {
                beanNames.add(SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)pointer));
            }
            String methodName = PsiFormatUtil.formatMethod((PsiMethod)checkedMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            String message = SpringBundle.message("bean.autowiring.by.type", psiType.getPresentableText(), StringUtil.join(beanNames, (String)","), methodName);
            Object problemElement = DomUtil.hasXml((DomElement)springBean.getClazz()) ? springBean.getClazz() : (DomUtil.hasXml((DomElement)springBean.getFactoryMethod()) ? springBean.getFactoryMethod() : springBean);
            holder.createProblem((DomElement)problemElement, message, new LocalQuickFix[0]);
        }
    }

    private static void checkByTypeAutowire(@NotNull SpringBean springBean, @NotNull CommonSpringModel model, @NotNull DomElementAnnotationHolder holder) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/SpringAutowiringInspection", "checkByTypeAutowire"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/highlighting/SpringAutowiringInspection", "checkByTypeAutowire"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/SpringAutowiringInspection", "checkByTypeAutowire"));
        }
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (beanClass == null) {
            return;
        }
        HashMap propertyTypes = new HashMap();
        for (PsiMethod psiMethod : beanClass.getAllMethods()) {
            if (!PropertyUtil.isSimplePropertySetter((PsiMethod)psiMethod)) continue;
            PsiParameter parameter = psiMethod.getParameterList().getParameters()[0];
            PsiType type = parameter.getType();
            if (propertyTypes.get(type) == null) {
                propertyTypes.put(type, new ArrayList());
            }
            ((List)propertyTypes.get(type)).add(psiMethod);
        }
        for (PsiType psiType : propertyTypes.keySet()) {
            Object psiMethod2;
            Set<SpringBeanPointer> beans = SpringAutowireUtil.autowireByType(model, SpringAutowireUtil.getAutowiredEffectiveBeanTypes(psiType));
            if (beans.size() <= 1) continue;
            ArrayList<String> properties = new ArrayList<String>();
            for (Object psiMethod2 : (List)propertyTypes.get(psiType)) {
                String propertyName = PropertyUtil.getPropertyNameBySetter((PsiMethod)psiMethod2);
                if (SpringAutowireUtil.isPropertyDefined(springBean, propertyName)) continue;
                properties.add(propertyName);
            }
            if (properties.size() <= 0) continue;
            ArrayList<String> beanNames = new ArrayList<String>();
            psiMethod2 = beans.iterator();
            while (psiMethod2.hasNext()) {
                SpringBeanPointer pointer = (SpringBeanPointer)psiMethod2.next();
                beanNames.add(SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)pointer));
            }
            String message = SpringBundle.message("bean.autowiring.by.type", psiType.getPresentableText(), StringUtil.join(beanNames, (String)","), StringUtil.join(properties, (String)","));
            holder.createProblem((DomElement)springBean, message, new LocalQuickFix[]{new ShowBeansQuickFix(beans)});
        }
    }
}

