/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.jam.javaConfig.SpringJavaConfiguration;
import com.intellij.spring.model.jam.javaConfig.SpringOldJavaConfigurationUtil;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.AddDomElementQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanInstantiationInspection
extends SpringBeanInspectionBase {
    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel springModel) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/SpringBeanInstantiationInspection", "checkBean"));
        }
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/highlighting/SpringBeanInstantiationInspection", "checkBean"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/SpringBeanInstantiationInspection", "checkBean"));
        }
        PsiClass psiClass = (PsiClass)springBean.getClazz().getValue();
        if (psiClass != null && !springBean.isAbstract() && psiClass.hasModifierProperty("abstract")) {
            boolean lookup;
            boolean factory = DomUtil.hasXml((DomElement)springBean.getFactoryMethod());
            boolean bl = lookup = SpringBeanInstantiationInspection.hasLookupMethods(springBean) || SpringBeanInstantiationInspection.hasAnnotatedLookupMethods(psiClass);
            if (!(factory || lookup || SpringBeanInstantiationInspection.isJavaConfigBean(springBean))) {
                holder.createProblem((DomElement)springBean.getClazz(), HighlightSeverity.WARNING, psiClass.isInterface() ? SpringBundle.message("interface.not.allowed", new Object[0]) : SpringBundle.message("abstract.class.not.allowed", new Object[0]), new LocalQuickFix[]{new MarkAbstractFix((GenericAttributeValue<Boolean>)springBean.getAbstract())});
            }
        }
    }

    private static boolean hasLookupMethods(@NotNull SpringBean springBean) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/SpringBeanInstantiationInspection", "hasLookupMethods"));
        }
        return SpringBeanInstantiationInspection.hasLookupMethods(springBean, (Set<SpringBean>)new THashSet());
    }

    private static boolean hasLookupMethods(@NotNull SpringBean springBean, @NotNull Set<SpringBean> visited) {
        CommonSpringBean bean;
        SpringBeanPointer parent;
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/SpringBeanInstantiationInspection", "hasLookupMethods"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/spring/model/highlighting/SpringBeanInstantiationInspection", "hasLookupMethods"));
        }
        if (visited.contains(springBean)) {
            return false;
        }
        if (springBean.getLookupMethods().size() > 0) {
            return true;
        }
        visited.add(springBean);
        GenericAttributeValue parentBeanValue = springBean.getParentBean();
        if (DomUtil.hasXml((DomElement)parentBeanValue) && (parent = (SpringBeanPointer)parentBeanValue.getValue()) != null && (bean = parent.getSpringBean()) instanceof SpringBean) {
            return SpringBeanInstantiationInspection.hasLookupMethods((SpringBean)bean, visited);
        }
        return false;
    }

    private static boolean hasAnnotatedLookupMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/highlighting/SpringBeanInstantiationInspection", "hasAnnotatedLookupMethods"));
        }
        for (PsiMethod method : psiClass.getAllMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.beans.factory.annotation.Lookup", (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJavaConfigBean(SpringBean springBean) {
        Module module;
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (DomUtil.hasXml((DomElement)springBean) && beanClass != null && (module = springBean.getModule()) != null) {
            for (SpringJavaConfiguration javaConfiguration : SpringOldJavaConfigurationUtil.getJavaConfigurations((Module)module)) {
                if (!beanClass.equals(javaConfiguration.getPsiClass())) continue;
                return true;
            }
        }
        return false;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringBeanInstantiationInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringBeanInstantiationInspection", "getShortName"));
        }
        return "SpringBeanInstantiationInspection";
    }

    private static class MarkAbstractFix
    extends AddDomElementQuickFix<GenericAttributeValue<Boolean>> {
        public MarkAbstractFix(GenericAttributeValue<Boolean> value) {
            super(value);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/SpringBeanInstantiationInspection$MarkAbstractFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/SpringBeanInstantiationInspection$MarkAbstractFix", "applyFix"));
            }
            ((GenericAttributeValue)this.myElement).setValue((Object)Boolean.TRUE);
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("mark.bean.as.abstract", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringBeanInstantiationInspection$MarkAbstractFix", "getName"));
            }
            return string;
        }
    }
}

