/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInsight.daemon.impl.quickfix.UastCreateMethodFix;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class ContextJavaBeanUnresolvedMethodsInspection
extends AbstractBaseUastLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "checkClass"));
        }
        PsiFile file = aClass.getContainingFile();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (!SpringCommonUtils.hasSpringFacet((Module)module)) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        for (UMethod uMethod : aClass.getMethods()) {
            ContextJavaBeanUnresolvedMethodsInspection.checkMethod(uMethod, holder, module);
        }
        return holder.getResultsArray();
    }

    private static void checkMethod(@NotNull UMethod uMethod, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (uMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uMethod", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "checkMethod"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "checkMethod"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "checkMethod"));
        }
        ContextJavaBean contextJavaBean = ContextJavaBeanUnresolvedMethodsInspection.getContextJavaBean(uMethod, module);
        if (contextJavaBean != null) {
            ContextJavaBeanUnresolvedMethodsInspection.checkContextJavaBean(contextJavaBean, holder);
        }
    }

    private static void checkContextJavaBean(@NotNull ContextJavaBean contextJavaBean, @NotNull ProblemsHolder holder) {
        if (contextJavaBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextJavaBean", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "checkContextJavaBean"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "checkContextJavaBean"));
        }
        ContextJavaBeanUnresolvedMethodsInspection.checkMethodExists(contextJavaBean, holder, (JamStringAttributeElement<PsiMethod>)contextJavaBean.getInitMethodAttributeElement());
        ContextJavaBeanUnresolvedMethodsInspection.checkMethodExists(contextJavaBean, holder, (JamStringAttributeElement<PsiMethod>)contextJavaBean.getDestroyMethodAttributeElement());
    }

    private static void checkMethodExists(ContextJavaBean contextJavaBean, ProblemsHolder holder, JamStringAttributeElement<PsiMethod> methodAttributeElement) {
        if (StringUtil.isNotEmpty((String)methodAttributeElement.getStringValue()) && methodAttributeElement.getValue() == null) {
            PsiAnnotationMemberValue memberValue = methodAttributeElement.getPsiElement();
            PsiAnnotationMemberValue psiElement = memberValue == null ? contextJavaBean.getPsiAnnotation() : memberValue;
            holder.registerProblem((PsiElement)psiElement, SpringBundle.message("ContextJavaBeanUnresolvedMethodsInspection.cannot.resolve.method", new Object[0]), new LocalQuickFix[]{ContextJavaBeanUnresolvedMethodsInspection.makeFix(contextJavaBean, methodAttributeElement)});
        }
    }

    private static LocalQuickFix makeFix(ContextJavaBean contextJavaBean, JamStringAttributeElement<PsiMethod> methodAttributeElement) {
        PsiClass clazz = PsiTypesUtil.getPsiClass((PsiType)contextJavaBean.getBeanType());
        if (clazz == null) {
            return null;
        }
        UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)clazz, UClass.class);
        if (uClass == null) {
            return null;
        }
        String methodName = methodAttributeElement.getStringValue();
        if (methodName == null) {
            return null;
        }
        return UastCreateMethodFix.createVoidMethodIfFixPossible((UClass)uClass, (String)methodName, (String)"private");
    }

    @Nullable
    private static ContextJavaBean getContextJavaBean(@NotNull UMethod uMethod, @NotNull Module module) {
        if (uMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uMethod", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "getContextJavaBean"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "getContextJavaBean"));
        }
        PsiMethod psi = uMethod.getPsi();
        JamPsiMemberSpringBean memberSpringBean = (JamPsiMemberSpringBean)JamService.getJamService((Project)module.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)psi);
        return memberSpringBean instanceof ContextJavaBean ? (ContextJavaBean)memberSpringBean : null;
    }

    @NotNull
    public String getShortName() {
        if ("ContextJavaBeanUnresolvedMethodsInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "getShortName"));
        }
        return "ContextJavaBeanUnresolvedMethodsInspection";
    }
}

