/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.profiles.ChangeActiveProfileDialog;
import com.intellij.ui.EditorNotifications;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringChangeActiveProfilesAction
extends AnAction {
    public static final String ACTION_ID = "SpringChangeActiveProfiles";

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        boolean enabled = project != null && SpringCommonUtils.hasSpringFacets((Project)project);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        SpringModel model;
        Project project = e.getProject();
        assert (project != null);
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        ChangeActiveProfileDialog dialog = new ChangeActiveProfileDialog(project, module, model = SpringChangeActiveProfilesAction.getSpringModelFromDataContext(module, e));
        if (dialog.showAndGet()) {
            SpringChangeActiveProfilesAction.triggerRehighlight(project);
        }
    }

    private static void triggerRehighlight(Project project) {
        UsageTrigger.trigger((String)"spring.SpringChangeActiveProfiles");
        EditorNotifications.getInstance((Project)project).updateAllNotifications();
        SpringModificationTrackersManager.getInstance((Project)project).fireActiveProfilesChanged();
        PsiManager.getInstance((Project)project).dropPsiCaches();
    }

    @Nullable
    private static SpringModel getSpringModelFromDataContext(Module module, AnActionEvent e) {
        Object data;
        if (module != null && (data = e.getData(PlatformDataKeys.SELECTED_ITEM)) instanceof SpringFileSet) {
            return SpringChangeActiveProfilesAction.getSpringModelForFileSet(module, (SpringFileSet)data);
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile != null) {
            return SpringChangeActiveProfilesAction.getSpringModel(psiFile);
        }
        return null;
    }

    @Nullable
    private static SpringModel getSpringModelForFileSet(Module module, SpringFileSet springFileSet) {
        for (SpringModel model : SpringManager.getInstance((Project)module.getProject()).getAllModels(module)) {
            if (!springFileSet.equals((Object)model.getFileSet())) continue;
            return model;
        }
        return null;
    }

    @Nullable
    static SpringModel getSpringModel(PsiFile psiFile) {
        if (JamCommonUtil.isPlainXmlFile((PsiElement)psiFile) && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile))) {
            SpringManager springManager = SpringManager.getInstance((Project)psiFile.getProject());
            return springManager.getSpringModelByFile(psiFile);
        }
        if (psiFile instanceof PsiClassOwner) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
            if (module == null) {
                return null;
            }
            if (!SpringChangeActiveProfilesAction.hasConfigurations((PsiClassOwner)psiFile)) {
                return null;
            }
            SpringManager springManager = SpringManager.getInstance((Project)psiFile.getProject());
            Set models = springManager.getAllModels(module);
            for (SpringModel model : models) {
                for (CommonSpringModel localModel : model.getModelsToProcess(false)) {
                    if (!localModel.hasConfigFile(psiFile)) continue;
                    return model;
                }
            }
        }
        return null;
    }

    private static boolean hasConfigurations(PsiClassOwner psiFile) {
        for (PsiClass psiClass : psiFile.getClasses()) {
            if (!SpringChangeActiveProfilesAction.containsConfigurations(psiClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsConfigurations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/profiles/SpringChangeActiveProfilesAction", "containsConfigurations"));
        }
        if (SpringCommonUtils.isConfigurationOrMeta((PsiClass)psiClass)) {
            return true;
        }
        for (PsiClass innerClass : psiClass.getInnerClasses()) {
            if (!innerClass.hasModifierProperty("static") || !SpringCommonUtils.isConfigurationOrMeta((PsiClass)innerClass)) continue;
            return true;
        }
        return false;
    }
}

