/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow.panels;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.impl.SpringCombinedModelFactory;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.toolWindow.panels.SpringBeanPointerFinderRecursivePanel;
import com.intellij.spring.toolWindow.panels.SpringFileSetFinderRecursivePanel;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringConfigFilesFinderRecursivePanel
extends FinderRecursivePanel<SmartPsiElementPointer<NavigatablePsiElement>> {
    @NotNull
    private final SpringFileSet myFileSet;
    private final Module myModule;

    public SpringConfigFilesFinderRecursivePanel(SpringFileSetFinderRecursivePanel panel, @NotNull SpringFileSet fileSet, Module module) {
        if (fileSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSet", "com/intellij/spring/toolWindow/panels/SpringConfigFilesFinderRecursivePanel", "<init>"));
        }
        super((FinderRecursivePanel)panel);
        this.myFileSet = fileSet;
        this.myModule = module;
    }

    @NotNull
    protected List<SmartPsiElementPointer<NavigatablePsiElement>> getListItems() {
        SpringModel model = this.findModel();
        if (model == null) {
            List<SmartPsiElementPointer<NavigatablePsiElement>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/panels/SpringConfigFilesFinderRecursivePanel", "getListItems"));
            }
            return list;
        }
        HashSet<NavigatablePsiElement> listItems = new HashSet<NavigatablePsiElement>();
        Set configFiles = model.getConfigFiles();
        listItems.addAll(ContainerUtil.findAll((Collection)configFiles, XmlFile.class));
        for (PsiFile file : configFiles) {
            if (!(file instanceof PsiClassOwner)) continue;
            PsiClassOwner psiClassOwner = (PsiClassOwner)file;
            for (PsiClass topClass : psiClassOwner.getClasses()) {
                if (SpringCommonUtils.isConfigurationOrMeta((PsiClass)topClass)) {
                    listItems.add((NavigatablePsiElement)topClass);
                }
                SpringConfigFilesFinderRecursivePanel.processInnerConfigurationClasses(listItems, topClass);
            }
        }
        SmartPointerManager instance = SmartPointerManager.getInstance((Project)this.getProject());
        ArrayList<SmartPsiElementPointer<NavigatablePsiElement>> pointers = new ArrayList<SmartPsiElementPointer<NavigatablePsiElement>>(listItems.size());
        for (NavigatablePsiElement item : listItems) {
            pointers.add((SmartPsiElementPointer<NavigatablePsiElement>)instance.createSmartPsiElementPointer((PsiElement)item));
        }
        pointers.sort((o1, o2) -> StringUtil.naturalCompare((String)this.getItemText((SmartPsiElementPointer<NavigatablePsiElement>)o1), (String)this.getItemText((SmartPsiElementPointer<NavigatablePsiElement>)o2)));
        ArrayList<SmartPsiElementPointer<NavigatablePsiElement>> arrayList = pointers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/panels/SpringConfigFilesFinderRecursivePanel", "getListItems"));
        }
        return arrayList;
    }

    private static void processInnerConfigurationClasses(Collection<NavigatablePsiElement> listItems, PsiClass psiClass) {
        for (PsiClass innerClass : psiClass.getInnerClasses()) {
            if (SpringCommonUtils.isConfigurationOrMeta((PsiClass)innerClass)) {
                listItems.add((NavigatablePsiElement)innerClass);
            }
            SpringConfigFilesFinderRecursivePanel.processInnerConfigurationClasses(listItems, innerClass);
        }
    }

    @Nullable
    private static NavigatablePsiElement getNavigatable(@Nullable SmartPsiElementPointer<NavigatablePsiElement> pointer) {
        return pointer != null ? (NavigatablePsiElement)pointer.getElement() : null;
    }

    @Nullable
    private SpringModel findModel() {
        for (SpringModel model : SpringManager.getInstance((Project)this.getProject()).getAllModels(this.myModule)) {
            if (!this.myFileSet.equals((Object)model.getFileSet())) continue;
            return model;
        }
        return SpringCombinedModelFactory.createModel(this.myFileSet, this.myModule);
    }

    protected boolean hasChildren(SmartPsiElementPointer<NavigatablePsiElement> pointer) {
        return true;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.PSI_FILE.is(dataId)) {
            NavigatablePsiElement navigatablePsiElement = SpringConfigFilesFinderRecursivePanel.getNavigatable((SmartPsiElementPointer<NavigatablePsiElement>)((SmartPsiElementPointer)this.getSelectedValue()));
            return navigatablePsiElement != null ? navigatablePsiElement.getContainingFile() : null;
        }
        return super.getData(dataId);
    }

    protected AnAction[] getCustomListActions() {
        return new AnAction[]{ActionManager.getInstance().getAction("SpringChangeActiveProfiles")};
    }

    @NotNull
    protected String getItemText(SmartPsiElementPointer<NavigatablePsiElement> pointer) {
        NavigatablePsiElement navigatablePsiElement = SpringConfigFilesFinderRecursivePanel.getNavigatable(pointer);
        if (navigatablePsiElement == null) {
            if ("<invalid>" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/panels/SpringConfigFilesFinderRecursivePanel", "getItemText"));
            }
            return "<invalid>";
        }
        ItemPresentation presentation = navigatablePsiElement.getPresentation();
        String itemText = presentation != null ? presentation.getPresentableText() : navigatablePsiElement.getName();
        String string = StringUtil.notNullize((String)itemText, (String)"<unknown>");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/panels/SpringConfigFilesFinderRecursivePanel", "getItemText"));
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(SmartPsiElementPointer<NavigatablePsiElement> pointer) {
        NavigatablePsiElement navigatablePsiElement = SpringConfigFilesFinderRecursivePanel.getNavigatable(pointer);
        if (navigatablePsiElement == null) {
            return null;
        }
        if (navigatablePsiElement instanceof PsiClass && SpringCommonUtils.isConfiguration((PsiClass)((PsiClass)navigatablePsiElement))) {
            return SpringApiIcons.SpringJavaConfig;
        }
        return navigatablePsiElement.getIcon(0);
    }

    @Nullable
    protected VirtualFile getContainingFile(SmartPsiElementPointer<NavigatablePsiElement> pointer) {
        return pointer.getVirtualFile();
    }

    @Nullable
    protected JComponent createRightComponent(SmartPsiElementPointer<NavigatablePsiElement> pointer) {
        NavigatablePsiElement navigatablePsiElement = SpringConfigFilesFinderRecursivePanel.getNavigatable(pointer);
        if (navigatablePsiElement == null) {
            return null;
        }
        NullableFactory<CommonSpringModel> factory = this.getLocalSpringModel(navigatablePsiElement);
        return new SpringBeanPointerFinderRecursivePanel(this, factory);
    }

    private NullableFactory<CommonSpringModel> getLocalSpringModel(NavigatablePsiElement navigatablePsiElement) {
        return () -> {
            if (!navigatablePsiElement.isValid()) {
                return null;
            }
            if (navigatablePsiElement instanceof XmlFile) {
                return SpringManager.getInstance((Project)this.getProject()).getLocalSpringModel((XmlFile)navigatablePsiElement);
            }
            if (navigatablePsiElement instanceof PsiClass) {
                return SpringManager.getInstance((Project)this.getProject()).getLocalSpringModel((PsiClass)navigatablePsiElement);
            }
            return null;
        };
    }
}

