/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.CommonBundle;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.ide.util.TreeFileChooser;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.ResourceFileUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.ImageFileFilter;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.GroupItem;
import com.intellij.uiDesigner.palette.Palette;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.InputStream;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public final class ComponentItemDialog
extends DialogWrapper {
    private JPanel myPanel;
    private final ComponentWithBrowseButton<EditorTextField> myTfClassName;
    private final Project myProject;
    private final ComponentItem myItemToBeEdited;
    private final boolean myOneOff;
    private JLabel myLblIcon;
    private TextFieldWithBrowseButton myTfIconPath;
    private JCheckBox myChkHorCanShrink;
    private JCheckBox myChkHorCanGrow;
    private JCheckBox myChkHorWantGrow;
    private JCheckBox myChkVerCanShrink;
    private JCheckBox myChkVerCanGrow;
    private JCheckBox myChkVerWantGrow;
    private JPanel myClassNamePlaceholder;
    private JRadioButton myClassRadioButton;
    private JRadioButton myNestedFormRadioButton;
    private TextFieldWithBrowseButton myTfNestedForm;
    private JCheckBox myAutoCreateBindingCheckbox;
    private JCheckBox myCanAttachLabelCheckbox;
    private JPanel myHSizePolicyPanel;
    private JPanel myVSizePolicyPanel;
    private JComboBox myGroupComboBox;
    private JLabel myGroupLabel;
    private JCheckBox myIsContainerCheckBox;
    private JLabel myErrorLabel;
    private final EditorTextField myEditorTextField;
    private Document myDocument;

    public ComponentItemDialog(Project project, Component parent, @NotNull ComponentItem itemToBeEdited, boolean oneOff) {
        if (itemToBeEdited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemToBeEdited", "com/intellij/uiDesigner/palette/ComponentItemDialog", "<init>"));
        }
        super(parent, false);
        this.myProject = project;
        this.myItemToBeEdited = itemToBeEdited;
        this.myOneOff = oneOff;
        this.$$$setupUI$$$();
        this.myEditorTextField = new EditorTextField("", project, (FileType)StdFileTypes.JAVA);
        this.myEditorTextField.setFontInheritedFromLAF(true);
        this.myTfClassName = new ComponentWithBrowseButton((JComponent)this.myEditorTextField, (ActionListener)new MyChooseClassActionListener(project));
        PsiFile boundForm = itemToBeEdited.getBoundForm();
        if (boundForm != null) {
            this.myNestedFormRadioButton.setSelected(true);
            this.myTfNestedForm.setText(FormEditingUtil.buildResourceName(boundForm));
        } else {
            this.myClassRadioButton.setSelected(true);
            this.setEditorText(this.myItemToBeEdited.getClassName().replace('$', '.'));
        }
        this.updateEnabledTextField();
        ((EditorTextField)this.myTfClassName.getChildComponent()).addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                ComponentItemDialog.this.updateOKAction();
            }
        });
        this.myTfClassName.getButton().setEnabled(!project.isDefault());
        this.myClassNamePlaceholder.setLayout(new BorderLayout());
        this.myClassNamePlaceholder.add((Component)this.myTfClassName, "Center");
        this.myTfIconPath.setText(this.myItemToBeEdited.getIconPath());
        this.myTfIconPath.addActionListener((ActionListener)new MyChooseFileActionListener(project, new ImageFileFilter(null), this.myTfIconPath, UIDesignerBundle.message("add.component.choose.icon", new Object[0])));
        this.myTfNestedForm.addActionListener((ActionListener)new MyChooseFileActionListener(project, new TreeFileChooser.PsiFileFilter(){

            public boolean accept(PsiFile file) {
                return file.getFileType().equals(StdFileTypes.GUI_DESIGNER_FORM);
            }
        }, this.myTfNestedForm, UIDesignerBundle.message("add.component.choose.form", new Object[0])));
        this.myTfNestedForm.getTextField().getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e) {
                ComponentItemDialog.this.updateOKAction();
            }
        });
        GridConstraints defaultConstraints = this.myItemToBeEdited.getDefaultConstraints();
        int hSizePolicy = defaultConstraints.getHSizePolicy();
        this.myChkHorCanShrink.setSelected((hSizePolicy & 1) != 0);
        this.myChkHorCanGrow.setSelected((hSizePolicy & 2) != 0);
        this.myChkHorWantGrow.setSelected((hSizePolicy & 4) != 0);
        int vSizePolicy = defaultConstraints.getVSizePolicy();
        this.myChkVerCanShrink.setSelected((vSizePolicy & 1) != 0);
        this.myChkVerCanGrow.setSelected((vSizePolicy & 2) != 0);
        this.myChkVerWantGrow.setSelected((vSizePolicy & 4) != 0);
        this.myIsContainerCheckBox.setSelected(itemToBeEdited.isContainer());
        this.myAutoCreateBindingCheckbox.setSelected(itemToBeEdited.isAutoCreateBinding());
        this.myCanAttachLabelCheckbox.setSelected(itemToBeEdited.isCanAttachLabel());
        this.myLblIcon.setLabelFor((Component)this.myTfIconPath);
        this.myClassRadioButton.addChangeListener(new MyRadioChangeListener());
        this.myNestedFormRadioButton.addChangeListener(new MyRadioChangeListener());
        if (oneOff) {
            this.myLblIcon.setVisible(false);
            this.myTfIconPath.setVisible(false);
            this.myCanAttachLabelCheckbox.setVisible(false);
            this.myHSizePolicyPanel.setVisible(false);
            this.myVSizePolicyPanel.setVisible(false);
        }
        this.updateOKAction();
        this.init();
    }

    void showGroupChooser(GroupItem defaultGroup) {
        this.myGroupLabel.setVisible(true);
        this.myGroupComboBox.setVisible(true);
        List<GroupItem> groups = Palette.getInstance(this.myProject).getGroups();
        this.myGroupComboBox.setModel(new DefaultComboBoxModel<Object>(groups.toArray()));
        this.myGroupComboBox.setSelectedItem(defaultGroup);
        this.myGroupComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ComponentItemDialog.this.updateOKAction();
            }
        });
        this.updateOKAction();
    }

    GroupItem getSelectedGroup() {
        return (GroupItem)this.myGroupComboBox.getSelectedItem();
    }

    private void setEditorText(String className) {
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)this.myProject);
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage("");
        PsiJavaCodeReferenceCodeFragment fragment = factory.createReferenceCodeFragment(className, (PsiElement)defaultPackage, true, true);
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)fragment);
        this.myEditorTextField.setDocument(this.myDocument);
        this.updateOKAction();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/palette/ComponentItemDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.dialogs.addEditPaletteComponent");
    }

    protected void doOKAction() {
        if (this.myClassRadioButton.isSelected()) {
            String className = this.myDocument.getText().trim();
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(className, GlobalSearchScope.allScope((Project)this.myProject));
            if (psiClass != null) {
                this.myItemToBeEdited.setClassName(ComponentItemDialog.getClassOrInnerName(psiClass));
            } else {
                this.myItemToBeEdited.setClassName(className);
            }
        } else if (!this.saveNestedForm()) {
            return;
        }
        this.myItemToBeEdited.setIconPath(this.myTfIconPath.getText().trim());
        GridConstraints defaultConstraints = this.myItemToBeEdited.getDefaultConstraints();
        defaultConstraints.setHSizePolicy((this.myChkHorCanShrink.isSelected() ? 1 : 0) | (this.myChkHorCanGrow.isSelected() ? 2 : 0) | (this.myChkHorWantGrow.isSelected() ? 4 : 0));
        defaultConstraints.setVSizePolicy((this.myChkVerCanShrink.isSelected() ? 1 : 0) | (this.myChkVerCanGrow.isSelected() ? 2 : 0) | (this.myChkVerWantGrow.isSelected() ? 4 : 0));
        defaultConstraints.setFill((this.myChkHorWantGrow.isSelected() ? 1 : 0) | (this.myChkVerWantGrow.isSelected() ? 2 : 0));
        this.myItemToBeEdited.setIsContainer(this.myIsContainerCheckBox.isSelected());
        this.myItemToBeEdited.setAutoCreateBinding(this.myAutoCreateBindingCheckbox.isSelected());
        this.myItemToBeEdited.setCanAttachLabel(this.myCanAttachLabelCheckbox.isSelected());
        super.doOKAction();
    }

    private boolean saveNestedForm() {
        LwRootContainer lwRootContainer;
        VirtualFile formFile = ResourceFileUtil.findResourceFileInProject((Project)this.myProject, (String)this.myTfNestedForm.getText());
        if (formFile == null) {
            Messages.showErrorDialog((Component)this.getWindow(), (String)UIDesignerBundle.message("add.component.cannot.load.form", this.myTfNestedForm.getText()), (String)CommonBundle.getErrorTitle());
            return false;
        }
        try {
            lwRootContainer = Utils.getRootContainer((InputStream)formFile.getInputStream(), null);
        }
        catch (Exception e) {
            Messages.showErrorDialog((Component)this.getWindow(), (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
            return false;
        }
        if (lwRootContainer.getClassToBind() == null) {
            Messages.showErrorDialog((Component)this.getWindow(), (String)UIDesignerBundle.message("add.component.form.not.bound", new Object[0]), (String)CommonBundle.getErrorTitle());
            return false;
        }
        if (lwRootContainer.getComponent(0).getBinding() == null) {
            Messages.showErrorDialog((Component)this.getWindow(), (String)UIDesignerBundle.message("add.component.root.not.bound", new Object[0]), (String)CommonBundle.getErrorTitle());
            return false;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(lwRootContainer.getClassToBind(), GlobalSearchScope.projectScope((Project)this.myProject));
        if (psiClass != null) {
            this.myItemToBeEdited.setClassName(ComponentItemDialog.getClassOrInnerName(psiClass));
        } else {
            this.myItemToBeEdited.setClassName(lwRootContainer.getClassToBind());
        }
        return true;
    }

    protected String getDimensionServiceKey() {
        if (this.myOneOff) {
            return "#com.intellij.uiDesigner.palette.ComponentItemDialog.OneOff";
        }
        return "#com.intellij.uiDesigner.palette.ComponentItemDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTfClassName.getChildComponent();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private void updateEnabledTextField() {
        this.myEditorTextField.setEnabled(this.myClassRadioButton.isSelected());
        this.myTfNestedForm.setEnabled(this.myNestedFormRadioButton.isSelected());
        this.updateOKAction();
    }

    private void updateOKAction() {
        this.setOKActionEnabled(this.isOKEnabled());
    }

    private boolean isOKEnabled() {
        this.myErrorLabel.setText(" ");
        if (this.myClassRadioButton.isSelected()) {
            if (this.myDocument == null) {
                return false;
            }
            if (!PsiNameHelper.getInstance((Project)this.myProject).isQualifiedName(this.myDocument.getText())) {
                if (this.myDocument.getTextLength() > 0) {
                    this.myErrorLabel.setText(UIDesignerBundle.message("add.component.error.qualified.name.required", new Object[0]));
                }
                return false;
            }
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
            PsiClass psiClass = javaPsiFacade.findClass(this.myDocument.getText(), ProjectScope.getAllScope((Project)this.myProject));
            PsiClass componentClass = javaPsiFacade.findClass(JComponent.class.getName(), ProjectScope.getAllScope((Project)this.myProject));
            if (psiClass != null && componentClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)componentClass, (boolean)true)) {
                this.myErrorLabel.setText(UIDesignerBundle.message("add.component.error.component.required", new Object[0]));
                return false;
            }
        } else if (this.myTfNestedForm.getText().length() == 0) {
            return false;
        }
        return !this.myGroupComboBox.isVisible() || this.myGroupComboBox.getSelectedItem() != null;
    }

    private static String getClassOrInnerName(PsiClass aClass) {
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        if (parentClass != null) {
            return ComponentItemDialog.getClassOrInnerName(parentClass) + "$" + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        JComboBox jComboBox;
        JLabel jLabel2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JRadioButton jRadioButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JPanel jPanel2;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JPanel jPanel3;
        JLabel jLabel3;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(8, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLblIcon = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("editbox.icon"));
        jPanel4.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myVSizePolicyPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/UIDesignerBundle").getString("group.vertical.size.policy"), (int)0, (int)0, null, null));
        this.myChkVerCanShrink = jCheckBox9 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("checkbox.can.shrink.vert"));
        jPanel3.add((Component)jCheckBox9, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myChkVerCanGrow = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("checkbox.can.grow.vert"));
        jPanel3.add((Component)jCheckBox8, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myChkVerWantGrow = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("checkbox.want.grow.vert"));
        jPanel3.add((Component)jCheckBox7, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHSizePolicyPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/UIDesignerBundle").getString("group.horizontal.size.policy"), (int)0, (int)0, null, null));
        this.myChkHorCanShrink = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("checkbox.can.shrink.horz"));
        jPanel2.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myChkHorCanGrow = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("checkbox.can.grow.horz"));
        jPanel2.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myChkHorWantGrow = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("checkbox.want.grow.horz"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTfIconPath = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(333, -1), null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myClassNamePlaceholder = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myClassRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("add.component.class"));
        jPanel6.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTfNestedForm = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel6.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myNestedFormRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("add.component.form"));
        jPanel6.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAutoCreateBindingCheckbox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("checkbox.auto.create.binding"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCanAttachLabelCheckbox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("checkbox.can.attach.label"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myGroupLabel = jLabel2 = new JLabel();
        ((Component)jLabel2).setVisible(false);
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("combobox.group"));
        jPanel4.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGroupComboBox = jComboBox = new JComboBox();
        ((Component)jComboBox).setVisible(false);
        jPanel4.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myIsContainerCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("checkbox.is.container"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myErrorLabel = jLabel = new JLabel();
        ((Component)jLabel).setForeground(Color.red);
        jLabel.setText(" ");
        jPanel4.add((Component)jLabel, new GridConstraints(7, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyRadioChangeListener
    implements ChangeListener {
        private MyRadioChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ComponentItemDialog.this.updateEnabledTextField();
        }
    }

    private static class MyChooseFileActionListener
    implements ActionListener {
        private final Project myProject;
        private final TreeFileChooser.PsiFileFilter myFilter;
        private final TextFieldWithBrowseButton myTextField;
        private final String myTitle;

        public MyChooseFileActionListener(Project project, TreeFileChooser.PsiFileFilter filter, TextFieldWithBrowseButton textField, String title) {
            this.myProject = project;
            this.myFilter = filter;
            this.myTextField = textField;
            this.myTitle = title;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VirtualFile formVFile;
            TreeClassChooserFactory factory = TreeClassChooserFactory.getInstance((Project)this.myProject);
            PsiFile formFile = null;
            if (this.myTextField.getText().length() > 0 && (formVFile = ResourceFileUtil.findResourceFileInScope((String)this.myTextField.getText(), (Project)this.myProject, (GlobalSearchScope)ProjectScope.getAllScope((Project)this.myProject))) != null) {
                formFile = PsiManager.getInstance((Project)this.myProject).findFile(formVFile);
            }
            TreeFileChooser fileChooser = factory.createFileChooser(this.myTitle, formFile, null, this.myFilter, true, true);
            fileChooser.showDialog();
            PsiFile file = fileChooser.getSelectedFile();
            if (file != null) {
                this.myTextField.setText(FormEditingUtil.buildResourceName(file));
            }
        }
    }

    private class MyChooseClassActionListener
    implements ActionListener {
        private final Project myProject;

        public MyChooseClassActionListener(Project project) {
            this.myProject = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeClassChooserFactory factory = TreeClassChooserFactory.getInstance((Project)this.myProject);
            TreeClassChooser chooser = factory.createInheritanceClassChooser(UIDesignerBundle.message("title.choose.component.class", new Object[0]), GlobalSearchScope.allScope((Project)this.myProject), JavaPsiFacade.getInstance((Project)this.myProject).findClass(JComponent.class.getName(), GlobalSearchScope.allScope((Project)this.myProject)), true, true, null);
            chooser.showDialog();
            PsiClass result = chooser.getSelected();
            if (result != null) {
                ComponentItemDialog.this.setEditorText(result.getQualifiedName());
            }
        }
    }
}

