/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.renderers.ClassToBindRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class ClassToBindProperty
extends Property<RadRootContainer, String> {
    private final ClassToBindRenderer myRenderer = new ClassToBindRenderer();
    private final MyEditor myEditor;

    public ClassToBindProperty(Project project) {
        super(null, "bind to class");
        this.myEditor = new MyEditor(project);
    }

    @Override
    public PropertyEditor<String> getEditor() {
        return this.myEditor;
    }

    @Override
    @NotNull
    public PropertyRenderer<String> getRenderer() {
        ClassToBindRenderer classToBindRenderer = this.myRenderer;
        if (classToBindRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/ClassToBindProperty", "getRenderer"));
        }
        return classToBindRenderer;
    }

    @Override
    public String getValue(RadRootContainer component) {
        return component.getClassToBind();
    }

    @Override
    protected void setValueImpl(RadRootContainer component, String value) throws Exception {
        String className = value;
        if (className != null && className.length() == 0) {
            className = null;
        }
        component.setClassToBind(className);
    }

    private final class MyEditor
    extends PropertyEditor<String> {
        private final EditorTextField myEditorTextField;
        private Document myDocument;
        private final ComponentWithBrowseButton<EditorTextField> myTfWithButton;
        private String myInitialValue;
        private final Project myProject;
        private final MyActionListener myActionListener;

        public MyEditor(Project project) {
            this.myProject = project;
            this.myEditorTextField = new EditorTextField("", project, (FileType)StdFileTypes.JAVA){

                protected boolean shouldHaveBorder() {
                    return false;
                }
            };
            this.myActionListener = new MyActionListener();
            this.myTfWithButton = new ComponentWithBrowseButton((JComponent)this.myEditorTextField, (ActionListener)this.myActionListener);
            this.myEditorTextField.setBorder(null);
            new MyCancelEditingAction().registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)this.myTfWithButton);
        }

        @Override
        public String getValue() throws Exception {
            String value = this.myDocument.getText();
            if (value.length() == 0 && this.myInitialValue == null) {
                return null;
            }
            return value.replace('$', '.');
        }

        @Override
        public JComponent getComponent(RadComponent component, String value, InplaceContext inplaceContext) {
            this.myInitialValue = value;
            this.setEditorText(value != null ? value : "");
            this.myActionListener.setComponent(component);
            return this.myTfWithButton;
        }

        private void setEditorText(String s) {
            JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)this.myProject);
            PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage("");
            PsiJavaCodeReferenceCodeFragment fragment = factory.createReferenceCodeFragment(s, (PsiElement)defaultPackage, true, true);
            this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)fragment);
            this.myEditorTextField.setDocument(this.myDocument);
        }

        @Override
        public void updateUI() {
            SwingUtilities.updateComponentTreeUI(this.myTfWithButton);
        }

        private final class MyCancelEditingAction
        extends AnAction {
            private MyCancelEditingAction() {
            }

            public void actionPerformed(AnActionEvent e) {
                MyEditor.this.fireEditingCancelled();
            }
        }

        private final class MyActionListener
        implements ActionListener {
            RadComponent myComponent;

            private MyActionListener() {
            }

            public void setComponent(RadComponent component) {
                this.myComponent = component;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String className = MyEditor.this.myEditorTextField.getText();
                PsiClass aClass = FormEditingUtil.findClassToBind(this.myComponent.getModule(), className);
                Project project = this.myComponent.getProject();
                final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createWithInnerClassesScopeChooser(UIDesignerBundle.message("title.choose.class.to.bind", new Object[0]), GlobalSearchScope.projectScope((Project)project), new ClassFilter(){

                    public boolean isAccepted(PsiClass aClass) {
                        VirtualFile vFile = aClass.getContainingFile().getVirtualFile();
                        return vFile != null && fileIndex.isUnderSourceRootOfType(vFile, JavaModuleSourceRootTypes.SOURCES);
                    }
                }, aClass);
                chooser.showDialog();
                PsiClass result = chooser.getSelected();
                if (result != null) {
                    MyEditor.this.setEditorText(result.getQualifiedName());
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)MyEditor.this.myEditorTextField, true));
            }
        }
    }
}

