/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.el.impl.CustomJsfVariableResolverProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.el.SpringBeansAsElVariableUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class SpringJsfVariableResolverProvider
implements CustomJsfVariableResolverProvider {
    @NonNls
    public static final List<String> VARIABLE_RESOLVER_CLASS_NAMES = Arrays.asList("org.springframework.web.jsf.DelegatingVariableResolver", "org.springframework.web.jsf.SpringBeanVariableResolver", "org.springframework.web.jsf.el.SpringBeanFacesELResolver");

    public boolean acceptVariableResolver(String className, Module module) {
        return VARIABLE_RESOLVER_CLASS_NAMES.contains(className) || SpringJsfVariableResolverProvider.isInheritor(className, VARIABLE_RESOLVER_CLASS_NAMES, module);
    }

    private static boolean isInheritor(String className, List<String> classNames, Module module) {
        if (module == null || StringUtil.isEmptyOrSpaces((String)className)) {
            return false;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(className, GlobalSearchScope.moduleWithDependenciesScope((Module)module));
        if (psiClass != null) {
            for (String name : classNames) {
                if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)name)) continue;
                return true;
            }
        }
        return false;
    }

    public void addVars(List<PsiVariable> resultVars, Module module) {
        SpringBeansAsElVariableUtil.addVariables(resultVars, (Module)module);
    }
}

