/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.ide;

import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.htmltools.xml.util.HtmlReferenceProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CustomFileDropHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.LightweightHint;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.index.ImageInfoIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlFileDropHandler
extends CustomFileDropHandler {
    public boolean canHandle(@NotNull Transferable t, @Nullable Editor editor) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/htmltools/ide/HtmlFileDropHandler", "canHandle"));
        }
        if (editor == null) {
            return false;
        }
        VirtualFile file = HtmlFileDropHandler.getDroppedFile(t);
        if (file == null) {
            return false;
        }
        FileType type = file.getFileType();
        return HtmlFileDropHandler.isImage(type) || HtmlFileDropHandler.isCSS(type) || HtmlFileDropHandler.isJS(type);
    }

    public boolean handleDrop(@NotNull Transferable t, @Nullable Editor editor, Project project) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/htmltools/ide/HtmlFileDropHandler", "handleDrop"));
        }
        assert (editor != null);
        Document document = editor.getDocument();
        PsiFile target = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (!(target instanceof HtmlFileImpl)) {
            return false;
        }
        VirtualFile file = HtmlFileDropHandler.getDroppedFile(t);
        if (file == null) {
            return false;
        }
        FileType type = file.getFileType();
        if (HtmlFileDropHandler.isCSS(type)) {
            return HtmlFileDropHandler.insertTagInHead((HtmlFileImpl)target, file, editor, "<link rel={0}stylesheet{0} href={0}{1}{0}>");
        }
        if (HtmlFileDropHandler.isJS(type)) {
            return HtmlFileDropHandler.insertTagInHead((HtmlFileImpl)target, file, editor, "<script src={0}{1}{0}></script>");
        }
        if (HtmlFileDropHandler.isImage(type)) {
            return HtmlFileDropHandler.insertImageTag((HtmlFileImpl)target, file, editor, "<img src={0}{1}{0}/>");
        }
        return false;
    }

    private static boolean insertTagInHead(final HtmlFileImpl target, VirtualFile droppedFile, Editor editor, String tagTemplate) {
        XmlTag parent;
        String relativePath = HtmlFileDropHandler.getRelativePath(target, droppedFile);
        final String tagText = HtmlFileDropHandler.prepareTagText(tagTemplate, relativePath);
        XmlDocument document = target.getDocument();
        if (document == null || tagText == null) {
            return false;
        }
        XmlTag[] topLevelTags = (XmlTag[])PsiTreeUtil.getChildrenOfType((PsiElement)document, XmlTag.class);
        XmlTag html = null;
        XmlTag head = null;
        if (topLevelTags != null) {
            for (XmlTag tag : topLevelTags) {
                if ("html".equals(tag.getName())) {
                    html = tag;
                    break;
                }
                if (!"head".equals(tag.getName())) continue;
                head = tag;
                break;
            }
        }
        if (html != null) {
            head = html.findFirstSubTag("head");
        }
        Object object = head != null ? head : (parent = html != null ? html : document);
        if (HtmlFileDropHandler.checkIfPresent(editor, tagTemplate, relativePath, (PsiElement)parent)) {
            return true;
        }
        new WriteCommandAction.Simple(target.getProject(), new PsiFile[]{target}, (PsiElement)parent){
            final /* synthetic */ PsiElement val$parent;
            {
                this.val$parent = psiElement;
                super(x0, x1);
            }

            protected void run() throws Throwable {
                XmlTag tag = XmlElementFactory.getInstance((Project)target.getProject()).createHTMLTagFromText(tagText);
                if (this.val$parent instanceof XmlTag) {
                    ((XmlTag)this.val$parent).addSubTag(tag, !"head".equals(((XmlTag)this.val$parent).getName()));
                } else {
                    this.val$parent.addAfter((PsiElement)tag, (PsiElement)((XmlDocument)this.val$parent).getProlog());
                }
            }
        }.execute();
        return true;
    }

    private static boolean checkIfPresent(Editor editor, String tagTemplate, String relativePath, PsiElement parent) {
        for (PsiElement element : parent.getChildren()) {
            String attrName;
            String path;
            if (!(element instanceof XmlTag)) continue;
            XmlTag tag = (XmlTag)element;
            if (!tagTemplate.startsWith("<" + tag.getName() + " ") || !StringUtil.equals((CharSequence)(path = tag.getAttributeValue(attrName = "script".equals(tag.getName()) ? "src" : "href")), (CharSequence)relativePath)) continue;
            LogicalPosition position = HtmlFileDropHandler.getPosition(editor, tag, attrName);
            editor.getScrollingModel().scrollTo(position, ScrollType.MAKE_VISIBLE);
            int flags = 42;
            LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel((String)("File " + relativePath + " is already linked")));
            Point point = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)editor, (LogicalPosition)position, (short)1);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, point, 42, 0, false);
            return true;
        }
        return false;
    }

    private static LogicalPosition getPosition(Editor editor, XmlTag tag, String attrName) {
        XmlAttributeValue element = tag.getAttribute(attrName).getValueElement();
        return editor.offsetToLogicalPosition(element.getTextRange().getStartOffset() + element.getTextRange().getLength() / 2);
    }

    private static boolean insertImageTag(final HtmlFileImpl target, VirtualFile droppedFile, Editor editor, String tagTemplate) {
        final String tagText = HtmlFileDropHandler.prepareTagText(tagTemplate, HtmlFileDropHandler.getRelativePath(target, droppedFile));
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = target.findElementAt(offset);
        if (element == null || tagText == null) {
            return false;
        }
        final XmlElement parent = (XmlElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{XmlTag.class, XmlDocument.class});
        PsiElement candidate = null;
        for (PsiElement psiElement : parent.getChildren()) {
            if (psiElement.getTextRange().getEndOffset() < offset) continue;
            candidate = psiElement;
            break;
        }
        if (parent instanceof XmlTag && candidate != null) {
            ASTNode endStart;
            ASTNode startEnd = XmlChildRole.START_TAG_END_FINDER.findChild(parent.getNode());
            if (startEnd != null && startEnd.getTextRange().getEndOffset() > candidate.getTextRange().getEndOffset()) {
                candidate = startEnd.getPsi();
            }
            if ((endStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(parent.getNode())) != null && endStart.getTextRange().getStartOffset() <= candidate.getTextRange().getStartOffset()) {
                candidate = endStart.getPsi().getPrevSibling();
            }
        }
        final PsiElement insertionPoint = candidate;
        new WriteCommandAction.Simple(target.getProject(), new PsiFile[]{target}){

            protected void run() throws Throwable {
                XmlTag tag = XmlElementFactory.getInstance((Project)target.getProject()).createHTMLTagFromText(tagText);
                ImageInfoIndex.ImageInfo info = HtmlReferenceProvider.SizeReference.getImageInfo(tag = (XmlTag)parent.addAfter((PsiElement)tag, insertionPoint));
                if (info != null && info.width != 0 && info.height != 0) {
                    tag.setAttribute("height", String.valueOf(info.height));
                    tag.setAttribute("width", String.valueOf(info.width));
                }
            }
        }.execute();
        return true;
    }

    @Nullable
    private static String prepareTagText(String tagTemplate, String path) {
        return path != null ? MessageFormat.format(tagTemplate, XmlEditUtil.getAttributeQuote((boolean)true), path) : null;
    }

    private static String getRelativePath(HtmlFileImpl target, VirtualFile droppedFile) {
        VirtualFile targetFile = target.getVirtualFile();
        return FileUtil.getRelativePath((String)targetFile.getParent().getPath(), (String)droppedFile.getPath(), (char)'/');
    }

    @Nullable
    private static VirtualFile getDroppedFile(@NotNull Transferable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/htmltools/ide/HtmlFileDropHandler", "getDroppedFile"));
        }
        List list = FileCopyPasteUtil.getFileList((Transferable)t);
        File io = list != null && list.size() == 1 ? (File)ContainerUtil.getFirstItem((List)list) : null;
        return io != null ? VfsUtil.findFileByIoFile((File)io, (boolean)true) : null;
    }

    private static boolean isJS(FileType type) {
        return type instanceof LanguageFileType && ((LanguageFileType)type).getLanguage().isKindOf(Language.findLanguageByID((String)"JavaScript"));
    }

    private static boolean isCSS(FileType type) {
        return type instanceof LanguageFileType && ((LanguageFileType)type).getLanguage().isKindOf(Language.findLanguageByID((String)"CSS"));
    }

    private static boolean isImage(FileType type) {
        return type == ImageFileTypeManager.getInstance().getImageFileType();
    }
}

