/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorSettingsEditor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.resultUI.CodeFragmentType;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DuplicatesPresentation {
    public static final ExtensionPointName<DuplicatesPresentation> EP_NAME = ExtensionPointName.create((String)"com.intellij.duplicates.presentation");

    @NotNull
    public DuplicatesProfile getProfile();

    @Nullable
    public CodeFragmentType getType(@NotNull CodeNode var1) throws InvalidatedException;

    public boolean isFixAbilityProvided();

    public boolean isFixAvailable(@NotNull CodeNode var1);

    public void applyFix(@NotNull CodeNode var1);

    @NotNull
    public DuplicatesView createView(@NotNull Project var1);

    @NotNull
    public DuplocatorSettingsEditor createEditor(@NotNull DuplocatorState var1);

    public static class Service {
        public static DuplicatesPresentation[] getAllPresentations() {
            return (DuplicatesPresentation[])Extensions.getExtensions(EP_NAME);
        }

        public static DuplicatesPresentation findPresentationForLanguage(Language language) {
            return Service.findPresentationForLanguage((DuplicatesPresentation[])EP_NAME.getExtensions(), language);
        }

        @Nullable
        public static DuplicatesPresentation findPresentationForLanguage(DuplicatesPresentation[] profiles, @NotNull Language language) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/DuplicatesPresentation$Service", "findPresentationForLanguage"));
            }
            for (DuplicatesPresentation presentation : profiles) {
                if (!presentation.getProfile().isMyLanguage(language)) continue;
                return presentation;
            }
            return null;
        }
    }
}

