/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.resultUI.BaseDuplicatesView;
import com.intellij.dupLocator.resultUI.CodeFragmentType;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.FileBasedCodeFragmentType;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public abstract class DuplicatesProfileAndPresentation
extends DuplicatesProfile
implements DuplicatesPresentation {
    @NotNull
    private final Language myLanguage;

    protected DuplicatesProfileAndPresentation(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/DuplicatesProfileAndPresentation", "<init>"));
        }
        this.myLanguage = language;
    }

    @Override
    @NotNull
    public DuplicatesProfile getProfile() {
        DuplicatesProfileAndPresentation duplicatesProfileAndPresentation = this;
        if (duplicatesProfileAndPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/DuplicatesProfileAndPresentation", "getProfile"));
        }
        return duplicatesProfileAndPresentation;
    }

    @Override
    public boolean isFixAbilityProvided() {
        return false;
    }

    @Override
    public boolean isFixAvailable(@NotNull CodeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/DuplicatesProfileAndPresentation", "isFixAvailable"));
        }
        return false;
    }

    @Override
    public void applyFix(@NotNull CodeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/DuplicatesProfileAndPresentation", "applyFix"));
        }
    }

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/DuplicatesProfileAndPresentation", "isMyLanguage"));
        }
        return language == this.myLanguage;
    }

    @Override
    public CodeFragmentType getType(@NotNull CodeNode node) throws InvalidatedException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/DuplicatesProfileAndPresentation", "getType"));
        }
        return new FileBasedCodeFragmentType(node.getVirtualFile(), node.getProject());
    }

    @Override
    @NotNull
    public DuplicatesView createView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dupLocator/DuplicatesProfileAndPresentation", "createView"));
        }
        BaseDuplicatesView baseDuplicatesView = new BaseDuplicatesView(project);
        if (baseDuplicatesView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/DuplicatesProfileAndPresentation", "createView"));
        }
        return baseDuplicatesView;
    }

    @Override
    public boolean isMyDuplicate(@NotNull DupInfo info, int index) {
        PsiElement[] elements;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/dupLocator/DuplicatesProfileAndPresentation", "isMyDuplicate"));
        }
        PsiFragment[] fragments = info.getFragmentOccurences(index);
        if (fragments.length > 0 && (elements = fragments[0].getElements()).length > 0) {
            Language language = elements[0].getLanguage();
            return this.isMyLanguage(language);
        }
        return false;
    }
}

