/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeFragmentType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class FileBasedCodeFragmentType
implements CodeFragmentType {
    private final VirtualFile myFile;
    private final Project myProject;

    public FileBasedCodeFragmentType(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dupLocator/resultUI/FileBasedCodeFragmentType", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dupLocator/resultUI/FileBasedCodeFragmentType", "<init>"));
        }
        this.myFile = file;
        this.myProject = project;
    }

    @Override
    public CompositeAppearance getTitle(boolean selected) {
        CompositeAppearance.DequeEnd ending = new CompositeAppearance().getEnding();
        ending.addText(this.myFile.getName(), BasicTreeNode.getTextAttributes(selected));
        VirtualFile parent = this.myFile.getParent();
        ending.addComment(FileBasedCodeFragmentType.getPresentablePath(parent, this.myProject), BasicTreeNode.getCommentAttributes(selected));
        return ending.getAppearance();
    }

    @NotNull
    private static String getPresentablePath(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dupLocator/resultUI/FileBasedCodeFragmentType", "getPresentablePath"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dupLocator/resultUI/FileBasedCodeFragmentType", "getPresentablePath"));
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        int contentRootCount = projectRootManager.getContentRoots().length;
        if (contentRootCount == 0) {
            String string = file.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/resultUI/FileBasedCodeFragmentType", "getPresentablePath"));
            }
            return string;
        }
        VirtualFile contentRoot = projectRootManager.getFileIndex().getContentRootForFile(file);
        if (contentRoot == null) {
            String string = file.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/resultUI/FileBasedCodeFragmentType", "getPresentablePath"));
            }
            return string;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot, (char)'/');
        if (relativePath == null) {
            String string = file.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/resultUI/FileBasedCodeFragmentType", "getPresentablePath"));
            }
            return string;
        }
        String presentableRelativePath = contentRootCount == 1 ? relativePath : contentRoot.getName() + '/' + relativePath;
        String string = FileUtil.toSystemDependentName((String)(".../" + presentableRelativePath));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/resultUI/FileBasedCodeFragmentType", "getPresentablePath"));
        }
        return string;
    }
}

