/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.util;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionService;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplocateManager;
import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.treeHash.DuplocatorHashCallback;
import com.intellij.ide.impl.PatchProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import java.io.File;
import java.util.List;

public class DuplocateMain
implements ApplicationStarter {
    private String myProjectPath;
    private String myOutput;
    private boolean myAnalyzeTestSources = false;
    private int myLowerBound = 10;
    private int myDiscardCost = 0;
    private boolean myValidity = true;
    private final boolean[] myAnonymousationSettings = new boolean[]{false, false, true, true, true};
    private boolean myErrorCodeRequired = true;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.dupLocator.util.DuplocateManager");
    private Project myProject;

    public String getCommandName() {
        return "duplocate";
    }

    public void premain(String[] args) {
        this.myProjectPath = args[1];
        this.myAnalyzeTestSources = Boolean.parseBoolean(args[2]);
        this.myOutput = args[3];
        int i = 4;
        if (args.length >= 5) {
            try {
                this.myLowerBound = Integer.parseInt(args[i++]);
            }
            catch (NumberFormatException e) {
                DuplocateMain.printHelp();
            }
            if (args.length == 12) {
                try {
                    this.myDiscardCost = Integer.parseInt(args[i++]);
                    this.myValidity = Boolean.parseBoolean(args[i++]);
                    for (int j = 0; j < this.myAnonymousationSettings.length; ++j) {
                        this.myAnonymousationSettings[j] = Boolean.parseBoolean(args[j + i]);
                    }
                }
                catch (NumberFormatException e) {
                    DuplocateMain.printHelp();
                }
            }
        }
        for (String arg : args) {
            if (!arg.equals("-t")) continue;
            this.myErrorCodeRequired = false;
            break;
        }
    }

    private static void printHelp() {
        System.out.println("Incorrect invocation: \nduplocate \t<project_path> \t<include_test_sources> \t<output_path> \t[<lower_bound> \t<discard_cost> \t<visibility> \t<distinguish_variables> \t<distinguish_fields> \t<distinguish_methods> \t<distinguish_types> \t<distinguish_literals>]");
    }

    public void main(String[] args) {
        ApplicationManager.getApplication().runReadAction(() -> {
            ApplicationEx application = ApplicationManagerEx.getApplicationEx();
            try {
                Module[] modules;
                application.doNotSave();
                DuplocatorSettings settings = DuplocatorSettings.getInstance();
                settings.LOWER_BOUND = this.myLowerBound;
                settings.DISCARD_COST = this.myDiscardCost;
                settings.CHECK_VALIDITY = this.myValidity;
                settings.DISTINGUISH_VARIABLES = this.myAnonymousationSettings[0];
                settings.DISTINGUISH_FIELDS = this.myAnonymousationSettings[1];
                settings.DISTINGUISH_METHODS = this.myAnonymousationSettings[2];
                settings.DISTINGUISH_TYPES = this.myAnonymousationSettings[3];
                settings.DISTINGUISH_LITERALS = this.myAnonymousationSettings[4];
                System.out.println(DupLocatorBundle.message("headless.duplocator.opening.project.message", new Object[0]));
                if (ConversionService.getInstance().convertSilently(this.myProjectPath, DuplocateMain.createConversionListener()).openingIsCanceled()) {
                    this.gracefulExit();
                    return;
                }
                this.myProject = ProjectUtil.openOrImport((String)this.myProjectPath, null, (boolean)false);
                if (this.myProject == null) {
                    System.err.println("Unable to open project");
                    this.gracefulExit();
                    return;
                }
                ApplicationManager.getApplication().runWriteAction(() -> VirtualFileManager.getInstance().refreshWithoutFileWatcher(false));
                PatchProjectUtil.patchProject((Project)this.myProject);
                if (ModuleManager.getInstance((Project)this.myProject).getModules().length == 0) {
                    System.out.println(DupLocatorBundle.message("offline.duplicates.no.modules.message", new Object[0]));
                    this.gracefulExit();
                    return;
                }
                for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
                    OrderEntry[] entries;
                    ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                    Sdk jdk = rootManager.getSdk();
                    if (jdk != null) continue;
                    for (OrderEntry entry : entries = rootManager.getOrderEntries()) {
                        if (!(entry instanceof JdkOrderEntry)) continue;
                        System.out.println(InspectionsBundle.message((String)"offline.inspections.module.jdk.not.found", (Object[])new Object[]{((JdkOrderEntry)entry).getJdkName(), module.getName()}));
                        this.gracefulExit();
                        return;
                    }
                }
                DuplocatorHashCallback duplicateCollector = new DuplocatorHashCallback(settings.LOWER_BOUND, settings.DISCARD_COST);
                ProgressManager.getInstance().runProcess(() -> {
                    String scopeName = System.getProperty("idea.analyze.scope");
                    NamedScope namedScope = scopeName != null ? NamedScopesHolder.getScope((Project)this.myProject, (String)scopeName) : null;
                    AnalysisScope scope = namedScope != null ? new AnalysisScope((SearchScope)GlobalSearchScopes.filterScope((Project)this.myProject, (NamedScope)namedScope), this.myProject) : new AnalysisScope(this.myProject);
                    scope.setIncludeTestSource(this.myAnalyzeTestSources);
                    DuplocateManager.hash(duplicateCollector, settings, scope);
                }, (ProgressIndicator)new ProgressIndicatorBase(){
                    private String myLastText;
                    private int myLastPercent = 0;

                    public void setText(String text) {
                        if (!Comparing.strEqual((String)text, (String)this.myLastText)) {
                            System.out.println(text);
                            this.myLastText = text;
                        }
                    }

                    public void setFraction(double fraction) {
                        int percent = (int)(fraction * 100.0);
                        if (this.myLastPercent != percent && !this.isIndeterminate()) {
                            this.myLastPercent = percent;
                            System.out.println(this.myLastText + " " + this.myLastPercent + "%");
                        }
                    }
                });
                duplicateCollector.report(this.myOutput, this.myProject);
                if (!this.myErrorCodeRequired) {
                    this.closeProject();
                }
            }
            catch (Throwable e) {
                LOG.error(e);
                this.gracefulExit();
            }
            finally {
                this.myProject = null;
                if (this.myErrorCodeRequired) {
                    application.exit(true, true);
                }
            }
        });
    }

    private void closeProject() {
        if (this.myProject != null && !this.myProject.isDisposed()) {
            ProjectUtil.closeAndDispose((Project)this.myProject);
        }
    }

    private void gracefulExit() {
        if (!this.myErrorCodeRequired) {
            this.closeProject();
            throw new RuntimeException("Failed to proceed");
        }
        System.exit(1);
    }

    private static ConversionListener createConversionListener() {
        return new ConversionListener(){

            public void conversionNeeded() {
                System.out.println(InspectionsBundle.message((String)"inspection.application.project.has.older.format.and.will.be.converted", (Object[])new Object[0]));
            }

            public void successfullyConverted(File backupDir) {
                System.out.println(InspectionsBundle.message((String)"inspection.application.project.was.succesfully.converted.old.project.files.were.saved.to.0", (Object[])new Object[]{backupDir.getAbsolutePath()}));
            }

            public void error(String message) {
                System.err.println(InspectionsBundle.message((String)"inspection.application.cannot.convert.project.0", (Object[])new Object[]{message}));
            }

            public void cannotWriteToFiles(List<File> readonlyFiles) {
                StringBuilder files = new StringBuilder();
                for (File file : readonlyFiles) {
                    files.append(file.getAbsolutePath()).append("; ");
                }
                System.err.println(InspectionsBundle.message((String)"inspection.application.cannot.convert.the.project.the.following.files.are.read.only.0", (Object[])new Object[]{files.toString()}));
            }
        };
    }
}

