/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelperBase;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Set;

class FindInFilesOptimizingSearchHelper
extends OptimizingSearchHelperBase {
    private final MyFileProcessor myFileProcessor;
    private THashSet<PsiFile> filesToScan;
    private THashSet<PsiFile> filesToScan2;
    private final Project myProject;
    private final SearchScope myScope;
    private final boolean myCaseSensitive;

    FindInFilesOptimizingSearchHelper(SearchScope scope, boolean caseSensitive, Project project) {
        this.myScope = scope;
        this.myCaseSensitive = caseSensitive;
        this.myProject = project;
        if (scope instanceof GlobalSearchScope && this.filesToScan == null) {
            this.filesToScan = new THashSet();
            this.filesToScan2 = new THashSet();
        }
        this.myFileProcessor = new MyFileProcessor();
    }

    @Override
    public boolean doOptimizing() {
        return this.myScope instanceof GlobalSearchScope;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.filesToScan != null) {
            this.filesToScan.clear();
            this.filesToScan2.clear();
        }
    }

    @Override
    protected void doAddSearchWordInCode(String refname) {
        CacheManager.SERVICE.getInstance((Project)this.myProject).processFilesWithWord((Processor)this.myFileProcessor, refname, (short)1, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
    }

    @Override
    protected void doAddSearchWordInText(String refname) {
        CacheManager.SERVICE.getInstance((Project)this.myProject).processFilesWithWord((Processor)this.myFileProcessor, refname, (short)16, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
    }

    @Override
    protected void doAddSearchWordInComments(String refname) {
        CacheManager.SERVICE.getInstance((Project)this.myProject).processFilesWithWord((Processor)this.myFileProcessor, refname, (short)2, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
    }

    @Override
    protected void doAddSearchWordInLiterals(String refname) {
        CacheManager.SERVICE.getInstance((Project)this.myProject).processFilesWithWord((Processor)this.myFileProcessor, refname, (short)4, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
    }

    @Override
    public void endTransaction() {
        super.endTransaction();
        THashSet<PsiFile> map = this.filesToScan;
        if (map.size() > 0) {
            map.clear();
        }
        this.filesToScan = this.filesToScan2;
        this.filesToScan2 = map;
    }

    @Override
    public Set<PsiFile> getFilesSetToScan() {
        return this.filesToScan;
    }

    private class MyFileProcessor
    implements Processor<PsiFile> {
        private MyFileProcessor() {
        }

        public boolean process(PsiFile file) {
            if (FindInFilesOptimizingSearchHelper.this.scanRequest == 0 || FindInFilesOptimizingSearchHelper.this.filesToScan.contains((Object)file)) {
                FindInFilesOptimizingSearchHelper.this.filesToScan2.add((Object)file);
            }
            return true;
        }
    }
}

