/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.CreateNewClassDialogValidatorEx;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiNameHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNewClassDialogValidatorExImpl
implements CreateNewClassDialogValidatorEx {
    public static final String INVALID_PACKAGE_MESSAGE = "This is not a valid Java package name";
    public static final String INVALID_QUALIFIED_NAME = "This is not a valid Java qualified name";
    private Project myProject;

    public CreateNewClassDialogValidatorExImpl(Project project) {
        this.myProject = project;
    }

    public static boolean isValidJavaIdentifier(String identifier) {
        return StringUtil.isJavaIdentifier((String)identifier) && !JavaLexer.isKeyword((String)identifier, (LanguageLevel)LanguageLevel.HIGHEST);
    }

    @Override
    public boolean checkSuperclass(@NotNull String inputString) {
        if (inputString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputString", "com/android/tools/idea/actions/CreateNewClassDialogValidatorExImpl", "checkSuperclass"));
        }
        return CreateNewClassDialogValidatorExImpl.checkQualifiedName(inputString);
    }

    @Override
    public boolean checkInterface(@NotNull String inputString) {
        if (inputString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputString", "com/android/tools/idea/actions/CreateNewClassDialogValidatorExImpl", "checkInterface"));
        }
        return CreateNewClassDialogValidatorExImpl.checkQualifiedName(inputString);
    }

    @Override
    public boolean checkPackage(@NotNull String inputString) {
        if (inputString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputString", "com/android/tools/idea/actions/CreateNewClassDialogValidatorExImpl", "checkPackage"));
        }
        return CharMatcher.WHITESPACE.matchesAllOf((CharSequence)inputString) || CreateNewClassDialogValidatorExImpl.checkList(inputString, ".");
    }

    @Nullable
    public String getErrorText(String inputString) {
        if (!inputString.isEmpty() && !PsiNameHelper.getInstance((Project)this.myProject).isQualifiedName(inputString)) {
            return INVALID_QUALIFIED_NAME;
        }
        return null;
    }

    @Override
    @NotNull
    public String getSuperclassErrorText(@Nullable String inputString) {
        if (INVALID_QUALIFIED_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/CreateNewClassDialogValidatorExImpl", "getSuperclassErrorText"));
        }
        return INVALID_QUALIFIED_NAME;
    }

    @Override
    @NotNull
    public String getInterfacesErrorText(@Nullable String inputString) {
        if (INVALID_QUALIFIED_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/CreateNewClassDialogValidatorExImpl", "getInterfacesErrorText"));
        }
        return INVALID_QUALIFIED_NAME;
    }

    @Override
    @NotNull
    public String getPackageErrorText(@Nullable String inputString) {
        if (INVALID_PACKAGE_MESSAGE == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/CreateNewClassDialogValidatorExImpl", "getPackageErrorText"));
        }
        return INVALID_PACKAGE_MESSAGE;
    }

    public boolean checkInput(String inputString) {
        String name = inputString.trim();
        return !CharMatcher.WHITESPACE.matchesAllOf((CharSequence)name) && this.getErrorText(name) == null;
    }

    public boolean canClose(String inputString) {
        return !CharMatcher.WHITESPACE.matchesAllOf((CharSequence)inputString) && this.getErrorText(inputString) == null;
    }

    private static boolean checkQualifiedName(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/actions/CreateNewClassDialogValidatorExImpl", "checkQualifiedName"));
        }
        return CharMatcher.WHITESPACE.matchesAllOf((CharSequence)qualifiedName) || CreateNewClassDialogValidatorExImpl.checkList(qualifiedName, ".");
    }

    private static boolean checkList(@NotNull String inputString, @NotNull String delimiter) {
        if (inputString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputString", "com/android/tools/idea/actions/CreateNewClassDialogValidatorExImpl", "checkList"));
        }
        if (delimiter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delimiter", "com/android/tools/idea/actions/CreateNewClassDialogValidatorExImpl", "checkList"));
        }
        for (String identifier : Splitter.on((String)delimiter).trimResults().split((CharSequence)inputString)) {
            if (CreateNewClassDialogValidatorExImpl.isValidJavaIdentifier(identifier)) continue;
            return false;
        }
        return true;
    }
}

