/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions.license;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class LicensesLocator {
    private final Path myIdeHome;
    private final boolean myOnMac;
    private final List<String> myGooglePlugins;

    public LicensesLocator(@NotNull Path ideHome, boolean isMacLayout) {
        if (ideHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideHome", "com/android/tools/idea/actions/license/LicensesLocator", "<init>"));
        }
        this.myGooglePlugins = Arrays.asList("android", "firebase", "firebase-testing", "google-appindexing", "google-cloud-tools", "google-cloud-tools-core", "google-login", "google-services", "test-recorder");
        this.myIdeHome = ideHome;
        this.myOnMac = isMacLayout;
    }

    @NotNull
    public List<Path> getLicenseFiles() {
        ArrayList<Path> licenses = new ArrayList<Path>();
        licenses.addAll(this.getIdeLicenseAndNotice());
        licenses.addAll(this.getIdeWideThirdPartyLibLicenses());
        for (String plugin : this.myGooglePlugins) {
            licenses.addAll(this.getThirdPartyLibrariesForPlugin(plugin));
        }
        ArrayList<Path> arrayList = licenses;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/license/LicensesLocator", "getLicenseFiles"));
        }
        return arrayList;
    }

    @NotNull
    private List<Path> getIdeLicenseAndNotice() {
        Path root = this.myIdeHome;
        if (this.myOnMac) {
            root = root.resolve("Resources");
        }
        ImmutableList immutableList = ImmutableList.of((Object)root.resolve("NOTICE.txt"), (Object)root.resolve("LICENSE.txt"));
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/license/LicensesLocator", "getIdeLicenseAndNotice"));
        }
        return immutableList;
    }

    @NotNull
    private List<Path> getIdeWideThirdPartyLibLicenses() {
        List<Path> list;
        try {
            list = Files.list(this.myIdeHome.resolve("license")).collect(Collectors.toList());
        }
        catch (IOException e) {
            Logger.getInstance(LicensesLocator.class).error((Throwable)e);
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/license/LicensesLocator", "getIdeWideThirdPartyLibLicenses"));
            }
            return immutableList;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/license/LicensesLocator", "getIdeWideThirdPartyLibLicenses"));
        }
        return list;
    }

    private List<Path> getThirdPartyLibrariesForPlugin(String plugin) {
        Path pluginLicenseFolder = Paths.get(this.myIdeHome.toString(), "plugins", plugin, "lib", "licenses");
        if (Files.isDirectory(pluginLicenseFolder, new LinkOption[0])) {
            try {
                return Files.list(pluginLicenseFolder).collect(Collectors.toList());
            }
            catch (IOException e) {
                Logger.getInstance(LicensesLocator.class).warn((Throwable)e);
                return ImmutableList.of();
            }
        }
        return ImmutableList.of();
    }
}

