/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant;

import com.android.tools.idea.templates.recipe.Recipe;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RecipeMetadata {
    @NotNull
    private final List<String> myDependencies;
    @NotNull
    private final List<String> myClasspathEntries;
    @NotNull
    private final List<String> myPlugins;
    @NotNull
    private final List<String> myPermissions;
    @NotNull
    private final List<String> myModifiedFiles;
    @NotNull
    private final Module myModule;
    @NotNull
    private final Recipe myRecipe;

    public RecipeMetadata(@NotNull Recipe recipe, @NotNull Module module) {
        if (recipe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recipe", "com/android/tools/idea/assistant/RecipeMetadata", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/assistant/RecipeMetadata", "<init>"));
        }
        this.myDependencies = Lists.newArrayList();
        this.myClasspathEntries = Lists.newArrayList();
        this.myPlugins = Lists.newArrayList();
        this.myPermissions = Lists.newArrayList();
        this.myModifiedFiles = Lists.newArrayList();
        this.myRecipe = recipe;
        this.myModule = module;
    }

    public void addDependency(@NotNull String dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/assistant/RecipeMetadata", "addDependency"));
        }
        this.myDependencies.add(dependency);
    }

    public void addClasspathEntry(@NotNull String classpathEntry) {
        if (classpathEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classpathEntry", "com/android/tools/idea/assistant/RecipeMetadata", "addClasspathEntry"));
        }
        this.myClasspathEntries.add(classpathEntry);
    }

    public void addPlugin(@NotNull String plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/android/tools/idea/assistant/RecipeMetadata", "addPlugin"));
        }
        this.myPlugins.add(plugin);
    }

    public void addPermission(@NotNull String permission) {
        if (permission == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permission", "com/android/tools/idea/assistant/RecipeMetadata", "addPermission"));
        }
        this.myPermissions.add(permission);
    }

    public void addModifiedFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/assistant/RecipeMetadata", "addModifiedFile"));
        }
        this.myModifiedFiles.add(file.getName());
    }

    @NotNull
    public List<String> getDependencies() {
        List<String> list = this.myDependencies;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/assistant/RecipeMetadata", "getDependencies"));
        }
        return list;
    }

    @NotNull
    public List<String> getClasspathEntries() {
        List<String> list = this.myClasspathEntries;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/assistant/RecipeMetadata", "getClasspathEntries"));
        }
        return list;
    }

    @NotNull
    public List<String> getPlugins() {
        List<String> list = this.myPlugins;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/assistant/RecipeMetadata", "getPlugins"));
        }
        return list;
    }

    @NotNull
    public List<String> getModifiedFiles() {
        List<String> list = this.myModifiedFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/assistant/RecipeMetadata", "getModifiedFiles"));
        }
        return list;
    }

    @NotNull
    public List<String> getPermissions() {
        List<String> list = this.myPermissions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/assistant/RecipeMetadata", "getPermissions"));
        }
        return list;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/assistant/RecipeMetadata", "getModule"));
        }
        return module;
    }

    @NotNull
    public Recipe getRecipe() {
        Recipe recipe = this.myRecipe;
        if (recipe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/assistant/RecipeMetadata", "getRecipe"));
        }
        return recipe;
    }
}

