/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.error;

import com.android.tools.idea.diagnostics.crash.CrashReport;
import com.android.tools.idea.diagnostics.crash.CrashReporter;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubmitCrashReportTask
extends Task.Backgroundable {
    private final Consumer<String> myCallback;
    private final Consumer<Exception> myErrorCallback;
    private final Throwable myThrowable;
    private final Map<String, String> myParams;

    public SubmitCrashReportTask(@Nullable Project project, @NotNull String title, boolean canBeCancelled, @Nullable Throwable throwable, @NotNull Map<String, String> params, @NotNull Consumer<String> callback, @NotNull Consumer<Exception> errorCallback) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/diagnostics/error/SubmitCrashReportTask", "<init>"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/android/tools/idea/diagnostics/error/SubmitCrashReportTask", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/idea/diagnostics/error/SubmitCrashReportTask", "<init>"));
        }
        if (errorCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorCallback", "com/android/tools/idea/diagnostics/error/SubmitCrashReportTask", "<init>"));
        }
        super(project, title, canBeCancelled);
        this.myThrowable = throwable;
        this.myParams = params;
        this.myCallback = callback;
        this.myErrorCallback = errorCallback;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/diagnostics/error/SubmitCrashReportTask", "run"));
        }
        indicator.setIndeterminate(true);
        CrashReport report = CrashReport.Builder.createForException(this.myThrowable).addProductData(this.getProductData()).build();
        CompletableFuture<String> future = CrashReporter.getInstance().submit(report, true);
        try {
            String token = future.get(20L, TimeUnit.SECONDS);
            this.myCallback.consume((Object)token);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.myErrorCallback.consume((Object)e);
        }
    }

    @NotNull
    private Map<String, String> getProductData() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        this.myParams.forEach((k, v) -> builder.put(k, (Object)StringUtil.notNullize((String)v)));
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/error/SubmitCrashReportTask", "getProductData"));
        }
        return immutableMap;
    }
}

