/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StringResourceSafeDeleteProcessorDelegate
extends SafeDeleteProcessorDelegateBase {
    StringResourceSafeDeleteProcessorDelegate() {
    }

    public boolean handlesElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "handlesElement"));
        }
        return StringResourceSafeDeleteProcessorDelegate.handlesElementImpl(element);
    }

    static boolean handlesElementImpl(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "handlesElementImpl"));
        }
        if (element instanceof XmlTag) {
            return AndroidResourceUtil.isStringResource((XmlTag)element);
        }
        if (element instanceof XmlAttributeValue) {
            PsiNamedElement attribute = (PsiNamedElement)element.getParent();
            return "name".equals(attribute.getName()) && "string".equals(((PsiNamedElement)attribute.getParent()).getName());
        }
        return false;
    }

    @NotNull
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @Nullable Module module, @NotNull Collection<PsiElement> elementsToDelete) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "getElementsToSearch"));
        }
        if (elementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToDelete", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "getElementsToSearch"));
        }
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            XmlAttribute attribute = tag.getAttribute("name");
            assert (attribute != null);
            ArrayList<XmlAttributeValue> elements = new ArrayList<XmlAttributeValue>();
            elements.add(attribute.getValueElement());
            Collection fields = Arrays.stream(AndroidResourceUtil.findResourceFieldsForValueResource(tag, true)).filter(field -> !(field instanceof LightElement)).collect(Collectors.toList());
            elements.addAll(fields);
            ArrayList<XmlAttributeValue> arrayList = elements;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "getElementsToSearch"));
            }
            return arrayList;
        }
        if (element instanceof XmlAttributeValue) {
            Collection<? extends PsiElement> collection = this.getElementsToSearch(element.getParent().getParent(), module, elementsToDelete);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "getElementsToSearch"));
            }
            return collection;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "getElementsToSearch"));
        }
        return list;
    }

    @NotNull
    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<PsiElement> elementsToDelete, boolean askUser) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "getAdditionalElementsToDelete"));
        }
        if (elementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToDelete", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "getAdditionalElementsToDelete"));
        }
        List<PsiElement> list = element instanceof XmlAttributeValue ? Collections.singletonList(element.getParent().getParent()) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "getAdditionalElementsToDelete"));
        }
        return list;
    }

    @NotNull
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, @NotNull PsiElement[] elementsToDelete, @NotNull List<UsageInfo> result) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "findUsages"));
        }
        if (elementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToDelete", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "findUsages"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "findUsages"));
        }
        SafeDeleteProcessor.findGenericElementUsages((PsiElement)element, result, (PsiElement[])elementsToDelete);
        NonCodeUsageSearchInfo nonCodeUsageSearchInfo = new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition((PsiElement[])elementsToDelete), element);
        if (nonCodeUsageSearchInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "findUsages"));
        }
        return nonCodeUsageSearchInfo;
    }

    @NotNull
    public UsageInfo[] preprocessUsages(@NotNull Project project, @NotNull UsageInfo[] usages) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "preprocessUsages"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "preprocessUsages"));
        }
        if (usages == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "preprocessUsages"));
        }
        return usages;
    }

    @Nullable
    public Collection<String> findConflicts(@NotNull PsiElement element, @NotNull PsiElement[] elementsToDelete) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "findConflicts"));
        }
        if (elementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToDelete", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "findConflicts"));
        }
        return null;
    }

    public void prepareForDeletion(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "prepareForDeletion"));
        }
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "isToSearchInComments"));
        }
        return false;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "setToSearchInComments"));
        }
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "isToSearchForTextOccurrences"));
        }
        return false;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/editors/strings/StringResourceSafeDeleteProcessorDelegate", "setToSearchForTextOccurrences"));
        }
    }
}

