/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.rendering.Locale;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceTableModel
extends AbstractTableModel {
    public static final int KEY_COLUMN = 0;
    public static final int UNTRANSLATABLE_COLUMN = 1;
    public static final int DEFAULT_VALUE_COLUMN = 2;
    public static final int FIXED_COLUMN_COUNT = 3;
    private final StringResourceData myData;
    private final List<String> myKeys;
    private final List<Locale> myLocales;

    StringResourceTableModel() {
        this.myData = null;
        this.myKeys = Collections.emptyList();
        this.myLocales = Collections.emptyList();
    }

    public StringResourceTableModel(@NotNull StringResourceData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "<init>"));
        }
        this.myData = data;
        this.myKeys = data.getKeys();
        this.myLocales = data.getLocales();
    }

    @Nullable
    public StringResourceData getData() {
        return this.myData;
    }

    @NotNull
    public StringResource getStringResourceAt(int row) {
        StringResource stringResource = this.myData.getStringResource(this.myKeys.get(row));
        if (stringResource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getStringResourceAt"));
        }
        return stringResource;
    }

    @NotNull
    public String getKey(int row) {
        String string = this.myKeys.get(row);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getKey"));
        }
        return string;
    }

    @Nullable
    public Locale getLocale(int column) {
        assert (0 <= column && column < this.getColumnCount()) : column;
        return column < 3 ? null : this.myLocales.get(column - 3);
    }

    @Override
    public int getRowCount() {
        return this.myKeys.size();
    }

    @Override
    public int getColumnCount() {
        return 3 + this.myLocales.size();
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        assert (this.myData != null && this.myKeys != null);
        switch (column) {
            case 0: {
                this.myData.changeKeyName(this.myKeys.get(row), (String)value);
                this.fireTableRowsUpdated(0, this.myKeys.size());
                break;
            }
            case 1: {
                Boolean doNotTranslate = (Boolean)value;
                if (!this.myData.setTranslatable(this.getKey(row), doNotTranslate == false)) break;
                this.fireTableCellUpdated(row, column);
                break;
            }
            default: {
                if (!this.myData.setTranslation(this.getKey(row), this.getLocale(column), (String)value)) break;
                this.fireTableCellUpdated(row, column);
            }
        }
    }

    @Override
    @NotNull
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                String string = this.getKey(row);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getValueAt"));
                }
                return string;
            }
            case 1: {
                Boolean bl = !this.getStringResourceAt(row).isTranslatable();
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getValueAt"));
                }
                return bl;
            }
            case 2: {
                String string = this.getStringResourceAt(row).getDefaultValueAsString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getValueAt"));
                }
                return string;
            }
        }
        Locale locale = this.getLocale(column);
        assert (locale != null);
        String string = this.getStringResourceAt(row).getTranslationAsString(locale);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getValueAt"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                if ("Key" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getColumnName"));
                }
                return "Key";
            }
            case 1: {
                if ("Untranslatable" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getColumnName"));
                }
                return "Untranslatable";
            }
            case 2: {
                if ("Default Value" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getColumnName"));
                }
                return "Default Value";
            }
        }
        String string = LocaleMenuAction.getLocaleLabel(this.getLocale(column), false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getColumnName"));
        }
        return string;
    }

    public Class getColumnClass(int column) {
        return column == 1 ? Boolean.class : String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Nullable
    public String getCellProblem(int row, int column) {
        return column == 0 ? this.myData.validateKey(this.getKey(row)) : this.myData.validateTranslation(this.getKey(row), this.getLocale(column));
    }
}

