/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.datamodels;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorStyle {
    private static final Logger LOG = Logger.getInstance(ThemeEditorStyle.class);
    @NotNull
    private final ConfigurationManager myManager;
    @NotNull
    private final String myQualifiedName;

    public ThemeEditorStyle(@NotNull ConfigurationManager manager, @NotNull String qualifiedName) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "<init>"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "<init>"));
        }
        this.myManager = manager;
        this.myQualifiedName = qualifiedName;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myQualifiedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = ResolutionUtils.getNameFromQualifiedName(this.myQualifiedName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getName"));
        }
        return string;
    }

    public boolean isFramework() {
        return this.myQualifiedName.startsWith("android:");
    }

    public boolean isProjectStyle() {
        if (this.isFramework()) {
            return false;
        }
        ProjectResourceRepository repository = ProjectResourceRepository.getProjectResources(this.myManager.getModule(), true);
        assert (repository != null);
        return repository.hasResourceItem(ResourceType.STYLE, this.myQualifiedName);
    }

    @NotNull
    protected Collection<com.android.ide.common.res2.ResourceItem> getStyleResourceItems() {
        ImmutableList resultItems;
        assert (!this.isFramework());
        Module module = this.myManager.getModule();
        if (this.isProjectStyle()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null) : module.getName() + " module doesn't have AndroidFacet";
            final HashMap resourceItems = Maps.newHashMap();
            ThemeEditorUtils.acceptResourceResolverVisitor(facet, new ThemeEditorUtils.ResourceFolderVisitor(){

                @Override
                public void visitResourceFolder(@NotNull LocalResourceRepository resources, String moduleName, @NotNull String variantName, boolean isSourceSelected) {
                    if (resources == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle$1", "visitResourceFolder"));
                    }
                    if (variantName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantName", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle$1", "visitResourceFolder"));
                    }
                    if (!isSourceSelected) {
                        return;
                    }
                    List items = resources.getResourceItem(ResourceType.STYLE, ThemeEditorStyle.this.myQualifiedName);
                    if (items == null) {
                        return;
                    }
                    for (com.android.ide.common.res2.ResourceItem item : items) {
                        String key = item.getConfiguration().toShortDisplayString() + "/" + item.getName();
                        resourceItems.put(key, item);
                    }
                }
            });
            resultItems = ImmutableList.copyOf(resourceItems.values());
        } else {
            AppResourceRepository resourceRepository = AppResourceRepository.getAppResources(module, true);
            assert (resourceRepository != null);
            ImmutableList items = resourceRepository.getResourceItem(ResourceType.STYLE, this.myQualifiedName);
            resultItems = items != null ? items : Collections.emptyList();
        }
        ImmutableList immutableList = resultItems;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getStyleResourceItems"));
        }
        return immutableList;
    }

    @NotNull
    public Collection<FolderConfiguration> getFolders() {
        if (this.isFramework()) {
            ImmutableList immutableList = ImmutableList.of((Object)new FolderConfiguration());
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getFolders"));
            }
            return immutableList;
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (com.android.ide.common.res2.ResourceItem styleItem : this.getStyleResourceItems()) {
            result.add((Object)styleItem.getConfiguration());
        }
        ImmutableList immutableList = result.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getFolders"));
        }
        return immutableList;
    }

    @NotNull
    public Collection<ItemResourceValue> getValues(@NotNull FolderConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getValues"));
        }
        if (this.isFramework()) {
            IAndroidTarget target = this.myManager.getHighestApiTarget();
            assert (target != null);
            ResourceItem styleItem = this.myManager.getResolverCache().getFrameworkResources(new FolderConfiguration(), target).getResourceItem(ResourceType.STYLE, this.getName());
            for (ResourceFile file : styleItem.getSourceFileList()) {
                if (!file.getConfiguration().equals((Object)configuration)) continue;
                StyleResourceValue style = (StyleResourceValue)file.getValue(ResourceType.STYLE, this.getName());
                Collection collection = style.getValues();
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getValues"));
                }
                return collection;
            }
            throw new IllegalArgumentException("bad folder config " + configuration);
        }
        for (com.android.ide.common.res2.ResourceItem styleItem : this.getStyleResourceItems()) {
            StyleResourceValue style;
            if (!configuration.equals((Object)styleItem.getConfiguration()) || (style = (StyleResourceValue)styleItem.getResourceValue(false)) == null) continue;
            Collection collection = style.getValues();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getValues"));
            }
            return collection;
        }
        throw new IllegalArgumentException("bad folder config " + configuration);
    }

    @Nullable
    public String getParentName(@NotNull FolderConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getParentName"));
        }
        if (this.isFramework()) {
            IAndroidTarget target = this.myManager.getHighestApiTarget();
            assert (target != null);
            ResourceItem styleItem = this.myManager.getResolverCache().getFrameworkResources(new FolderConfiguration(), target).getResourceItem(ResourceType.STYLE, this.getName());
            for (ResourceFile file : styleItem.getSourceFileList()) {
                if (!file.getConfiguration().equals((Object)configuration)) continue;
                StyleResourceValue style = (StyleResourceValue)file.getValue(ResourceType.STYLE, this.getName());
                return ResolutionUtils.getParentQualifiedName(style);
            }
            throw new IllegalArgumentException("bad folder config " + configuration);
        }
        for (com.android.ide.common.res2.ResourceItem styleItem : this.getStyleResourceItems()) {
            if (!configuration.equals((Object)styleItem.getConfiguration())) continue;
            StyleResourceValue style = (StyleResourceValue)styleItem.getResourceValue(false);
            assert (style != null);
            return ResolutionUtils.getParentQualifiedName(style);
        }
        throw new IllegalArgumentException("bad folder config " + configuration);
    }

    @Nullable
    private XmlTag findXmlTagFromConfiguration(@NotNull FolderConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "findXmlTagFromConfiguration"));
        }
        for (com.android.ide.common.res2.ResourceItem item : this.getStyleResourceItems()) {
            if (!item.getConfiguration().equals((Object)configuration)) continue;
            return LocalResourceRepository.getItemTag(this.myManager.getProject(), item);
        }
        return null;
    }

    @NotNull
    private ImmutableCollection<FolderConfiguration> findToBeCopied(int desiredApi) {
        HashMap bestVersionCopyFrom = Maps.newHashMap();
        for (com.android.ide.common.res2.ResourceItem styleItem : this.getStyleResourceItems()) {
            FolderConfiguration configuration = FolderConfiguration.copyOf((FolderConfiguration)styleItem.getConfiguration());
            int styleItemVersion = ThemeEditorUtils.getVersionFromConfiguration(configuration);
            configuration.setVersionQualifier(null);
            if (styleItemVersion > desiredApi || bestVersionCopyFrom.containsKey(configuration) && ((VersionQualifier)bestVersionCopyFrom.get(configuration)).getVersion() >= styleItemVersion) continue;
            bestVersionCopyFrom.put(configuration, new VersionQualifier(styleItemVersion));
        }
        ImmutableList.Builder toBeCopied = ImmutableList.builder();
        for (FolderConfiguration key : bestVersionCopyFrom.keySet()) {
            FolderConfiguration configuration = FolderConfiguration.copyOf((FolderConfiguration)key);
            VersionQualifier version = (VersionQualifier)bestVersionCopyFrom.get(key);
            if (version.getVersion() != -1) {
                configuration.setVersionQualifier(version);
            }
            if (version.getVersion() >= desiredApi) continue;
            toBeCopied.add((Object)configuration);
        }
        ImmutableList immutableList = toBeCopied.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "findToBeCopied"));
        }
        return immutableList;
    }

    private void setValue(@NotNull FolderConfiguration configuration, @NotNull String attribute, @NotNull String value) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XmlTag styleTag = this.findXmlTagFromConfiguration(configuration);
        assert (styleTag != null);
        XmlTag tag = this.getValueTag(styleTag, attribute);
        if (tag != null) {
            tag.getValue().setEscapedText(value);
        } else {
            XmlTag child = styleTag.createChildTag("item", styleTag.getNamespace(), value, false);
            child.setAttribute("name", attribute);
            styleTag.addSubTag(child, false);
        }
    }

    public void setValue(final @NotNull String attribute, final @NotNull String value) {
        int minSdk;
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        final Project project = this.myManager.getProject();
        int maxApi = Math.max(ResolutionUtils.getOriginalApiLevel(value, this.myManager.getProject()), ResolutionUtils.getOriginalApiLevel(attribute, project));
        final int desiredApi = maxApi <= (minSdk = ThemeEditorUtils.getMinApiLevel(this.myManager.getModule())) ? -1 : maxApi;
        new WriteCommandAction.Simple(project, "Setting value of " + attribute, new PsiFile[0]){

            protected void run() {
                AndroidFacet facet;
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                ImmutableCollection toBeCopied = ThemeEditorStyle.this.findToBeCopied(desiredApi);
                for (FolderConfiguration configuration : toBeCopied) {
                    XmlTag styleTag = ThemeEditorStyle.this.findXmlTagFromConfiguration(configuration);
                    assert (styleTag != null);
                    ThemeEditorUtils.copyTheme(desiredApi, styleTag);
                }
                if (!toBeCopied.isEmpty() && (facet = AndroidFacet.getInstance(ThemeEditorStyle.this.myManager.getModule())) != null) {
                    facet.refreshResources();
                    GradleBuildInvoker.saveAllFilesSafely();
                }
                Collection<com.android.ide.common.res2.ResourceItem> styleItems = ThemeEditorStyle.this.getStyleResourceItems();
                for (com.android.ide.common.res2.ResourceItem style : styleItems) {
                    FolderConfiguration configuration = style.getConfiguration();
                    int version = ThemeEditorUtils.getVersionFromConfiguration(configuration);
                    if (version < desiredApi) continue;
                    ThemeEditorStyle.this.setValue(configuration, attribute, value);
                }
            }
        }.execute();
    }

    private void setParent(@NotNull FolderConfiguration configuration, @NotNull String newParent) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setParent"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setParent"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XmlTag styleTag = this.findXmlTagFromConfiguration(configuration);
        assert (styleTag != null);
        styleTag.setAttribute("parent", newParent);
    }

    public void setParent(final @NotNull String qualifiedThemeName) {
        int minSdk;
        if (qualifiedThemeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedThemeName", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setParent"));
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        assert (!qualifiedThemeName.startsWith("@android:style/"));
        assert (!qualifiedThemeName.startsWith("@style/"));
        String newParentResourceUrl = ResolutionUtils.getStyleResourceUrl(qualifiedThemeName);
        int parentApi = ResolutionUtils.getOriginalApiLevel(newParentResourceUrl, this.myManager.getProject());
        final int desiredApi = parentApi <= (minSdk = ThemeEditorUtils.getMinApiLevel(this.myManager.getModule())) ? -1 : parentApi;
        new WriteCommandAction.Simple(this.myManager.getProject(), "Updating Parent to " + qualifiedThemeName, new PsiFile[0]){

            protected void run() {
                AndroidFacet facet;
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(ThemeEditorStyle.this.myManager.getProject());
                ImmutableCollection toBeCopied = ThemeEditorStyle.this.findToBeCopied(desiredApi);
                for (FolderConfiguration configuration : toBeCopied) {
                    XmlTag styleTag = ThemeEditorStyle.this.findXmlTagFromConfiguration(configuration);
                    assert (styleTag != null);
                    ThemeEditorUtils.copyTheme(desiredApi, styleTag);
                }
                if (!toBeCopied.isEmpty() && (facet = AndroidFacet.getInstance(ThemeEditorStyle.this.myManager.getModule())) != null) {
                    facet.refreshResources();
                    GradleBuildInvoker.saveAllFilesSafely();
                }
                Collection<com.android.ide.common.res2.ResourceItem> styleItems = ThemeEditorStyle.this.getStyleResourceItems();
                for (com.android.ide.common.res2.ResourceItem style : styleItems) {
                    FolderConfiguration configuration = style.getConfiguration();
                    int version = ThemeEditorUtils.getVersionFromConfiguration(configuration);
                    if (version < desiredApi) continue;
                    ThemeEditorStyle.this.setParent(configuration, qualifiedThemeName);
                }
            }
        }.execute();
    }

    @Nullable
    private XmlTag getValueTag(@NotNull XmlTag sourceTag, final @NotNull String attribute) {
        if (sourceTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceTag", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getValueTag"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getValueTag"));
        }
        if (!this.isProjectStyle()) {
            return null;
        }
        final Ref resultXmlTag = new Ref();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        sourceTag.acceptChildren(new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (!(element instanceof XmlTag)) {
                    return;
                }
                XmlTag tag = (XmlTag)element;
                if ("item".equals(tag.getName()) && attribute.equals(tag.getAttributeValue("name"))) {
                    resultXmlTag.set((Object)tag);
                }
            }
        });
        return (XmlTag)resultXmlTag.get();
    }

    public void removeAttribute(@NotNull String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "removeAttribute"));
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        final Project project = this.myManager.getProject();
        HashSet toBeEdited = new HashSet();
        HashSet toBeRemoved = new HashSet();
        for (com.android.ide.common.res2.ResourceItem resourceItem : this.getStyleResourceItems()) {
            XmlTag sourceXml = LocalResourceRepository.getItemTag(project, resourceItem);
            assert (sourceXml != null);
            XmlTag tag = this.getValueTag(sourceXml, attribute);
            if (tag == null) continue;
            toBeEdited.add(tag.getContainingFile());
            toBeRemoved.add(tag);
        }
        new WriteCommandAction.Simple(project, "Removing " + attribute, toBeEdited.toArray(new PsiFile[toBeEdited.size()]), (Collection)toBeRemoved){
            final /* synthetic */ Collection val$toBeRemoved;
            {
                this.val$toBeRemoved = collection;
                super(x0, x1, x2);
            }

            protected void run() {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                for (XmlTag tag : this.val$toBeRemoved) {
                    tag.delete();
                }
            }
        }.execute();
    }

    @Nullable
    public PsiElement getNamePsiElement() {
        Collection<com.android.ide.common.res2.ResourceItem> resources = this.getStyleResourceItems();
        if (resources.isEmpty()) {
            return null;
        }
        XmlTag sourceXml = LocalResourceRepository.getItemTag(this.myManager.getProject(), resources.iterator().next());
        assert (sourceXml != null);
        XmlAttribute nameAttribute = sourceXml.getAttribute("name");
        if (nameAttribute == null) {
            return null;
        }
        XmlAttributeValue attributeValue = nameAttribute.getValueElement();
        if (attributeValue == null) {
            return null;
        }
        return new ValueResourceElementWrapper(attributeValue);
    }

    public boolean isPublic() {
        if (!this.isFramework()) {
            return true;
        }
        IAndroidTarget target = this.myManager.getTarget();
        if (target == null) {
            LOG.error("Unable to get IAndroidTarget.");
            return false;
        }
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, this.myManager.getModule());
        if (androidTargetData == null) {
            LOG.error("Unable to get AndroidTargetData.");
            return false;
        }
        return androidTargetData.isResourcePublic(ResourceType.STYLE.getName(), this.getName());
    }
}

