/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.datastructs;

import com.android.tools.idea.experimental.codeanalysis.datastructs.ClassMember;
import com.android.tools.idea.experimental.codeanalysis.datastructs.Modifier;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGClass;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGPartialMethodSignature;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGPartialMethodSignatureBuilder;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.MethodGraph;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCFGMethod
implements ClassMember,
PsiAnnotationOwner {
    protected PsiMethod mMethodRef;
    protected PsiLambdaExpression mLambdaExprRef;
    protected PsiElement mPsiElementReference;
    protected PsiCFGClass mParentClass;
    protected int modifers;
    protected MethodGraph mCFG;
    protected boolean mIsLambdaMethod;
    protected PsiMethod mLamdaOverridenMethod;
    protected PsiCFGPartialMethodSignature mSignature;
    public static final PsiCFGMethod[] EMPTY_ARRAY = new PsiCFGMethod[0];

    public PsiCFGMethod(@NotNull PsiMethod method, @NotNull PsiCFGClass declaringClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGMethod", "<init>"));
        }
        if (declaringClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaringClass", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGMethod", "<init>"));
        }
        this.mMethodRef = method;
        this.mParentClass = declaringClass;
        this.mIsLambdaMethod = false;
        this.modifers = Modifier.ParseModifierList(method.getModifierList());
        this.mSignature = PsiCFGPartialMethodSignatureBuilder.buildFromPsiMethod(method);
    }

    public PsiCFGMethod(@NotNull PsiLambdaExpression lambdaExpr, @NotNull PsiMethod parentMethod, @NotNull PsiCFGClass declearingClass) {
        if (lambdaExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpr", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGMethod", "<init>"));
        }
        if (parentMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentMethod", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGMethod", "<init>"));
        }
        if (declearingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declearingClass", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGMethod", "<init>"));
        }
        this.mLambdaExprRef = lambdaExpr;
        this.mMethodRef = null;
        this.mLamdaOverridenMethod = parentMethod;
        this.mParentClass = declearingClass;
        this.mIsLambdaMethod = true;
        this.modifers = Modifier.ParseModifierList(parentMethod.getModifierList());
        this.mSignature = PsiCFGPartialMethodSignatureBuilder.buildFromPsiMethod(parentMethod);
    }

    private void generateSignature() {
        if (this.mPsiElementReference != null && this.mPsiElementReference instanceof PsiMethod) {
            this.mSignature = PsiCFGPartialMethodSignatureBuilder.buildFromPsiMethod((PsiMethod)this.mPsiElementReference);
        }
    }

    public PsiCFGPartialMethodSignature getSignature() {
        return this.mSignature;
    }

    public String getName() {
        if (this.mIsLambdaMethod) {
            return this.mLamdaOverridenMethod.getName();
        }
        return this.mMethodRef.getName();
    }

    public String toString() {
        return this.getName();
    }

    public boolean isLambda() {
        return this.mIsLambdaMethod;
    }

    public PsiElement getBody() {
        return this.mIsLambdaMethod ? this.mLambdaExprRef.getBody() : this.mMethodRef.getBody();
    }

    public PsiMethod getMethodRef() {
        return this.mMethodRef;
    }

    public PsiLambdaExpression getLambdaRef() {
        return this.mLambdaExprRef;
    }

    @Override
    public PsiCFGClass getDeclaringClass() {
        return this.mParentClass;
    }

    @Override
    public boolean isProtected() {
        return (this.modifers & 4) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.modifers & 2) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.modifers & 1) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.modifers & 8) != 0;
    }

    public boolean isAbstract() {
        return (this.modifers & 0x400) != 0;
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{};
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGMethod", "getAnnotations"));
        }
        return psiAnnotationArray;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{};
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGMethod", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Nullable
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGMethod", "findAnnotation"));
        }
        return null;
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGMethod", "addAnnotation"));
        }
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGMethod", "addAnnotation"));
        }
        return null;
    }

    public MethodGraph getControlFlowGraph() {
        return this.mCFG;
    }

    public void setControlFlowGraph(MethodGraph cfg) {
        this.mCFG = cfg;
    }
}

