/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.tools.fd.client.InstantRunArtifact;
import com.android.tools.fd.client.InstantRunArtifactType;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.idea.diagnostics.crash.CrashReporter;
import com.android.tools.idea.fd.BuildMode;
import com.android.tools.idea.fd.BuildSelection;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunNotificationProvider;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.tasks.DeployApkTask;
import com.android.tools.idea.run.tasks.HotSwapTask;
import com.android.tools.idea.run.tasks.InstantRunNotificationTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.NoChangesTask;
import com.android.tools.idea.run.tasks.SplitApkDeployTask;
import com.android.tools.idea.run.tasks.UpdateInstantRunStateTask;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.internal.statistic.StatisticsUploadAssistant;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunBuildAnalyzer {
    private final Project myProject;
    private final InstantRunContext myContext;
    private final ProcessHandler myCurrentSession;
    private final InstantRunBuildInfo myBuildInfo;

    public InstantRunBuildAnalyzer(@NotNull Project project, @NotNull InstantRunContext context, @Nullable ProcessHandler currentSession) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "<init>"));
        }
        this.myProject = project;
        this.myContext = context;
        this.myCurrentSession = currentSession;
        this.myBuildInfo = this.myContext.getInstantRunBuildInfo();
        if (this.myBuildInfo == null) {
            throw new IllegalArgumentException("Instant Run Build Information must be available post build");
        }
        if (!this.myBuildInfo.isCompatibleFormat()) {
            throw new IllegalStateException("This version of Android Studio is incompatible with the Gradle Plugin used. Try disabling Instant Run (or updating either the IDE or the Gradle plugin to the latest version)");
        }
    }

    public boolean canReuseProcessHandler() {
        if (this.myCurrentSession == null || this.myCurrentSession.isProcessTerminated()) {
            return false;
        }
        BuildSelection buildSelection = this.myContext.getBuildSelection();
        assert (buildSelection != null) : "Build must have completed before results are analyzed";
        return buildSelection.getBuildMode() == BuildMode.HOT && (this.myBuildInfo.hasNoChanges() || this.myBuildInfo.canHotswap());
    }

    @NotNull
    public List<LaunchTask> getDeployTasks(@Nullable LaunchOptions launchOptions) throws ExecutionException {
        UpdateInstantRunStateTask updateStateTask = new UpdateInstantRunStateTask(this.myContext);
        DeployType deployType = this.getDeployType();
        switch (deployType) {
            case NO_CHANGES: {
                ImmutableList immutableList = ImmutableList.of((Object)new NoChangesTask(this.myProject, this.myContext), (Object)updateStateTask);
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "getDeployTasks"));
                }
                return immutableList;
            }
            case HOTSWAP: 
            case WARMSWAP: {
                ImmutableList immutableList = ImmutableList.of((Object)new HotSwapTask(this.myProject, this.myContext, deployType == DeployType.WARMSWAP), (Object)updateStateTask);
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "getDeployTasks"));
                }
                return immutableList;
            }
            case SPLITAPK: {
                ImmutableList immutableList = ImmutableList.of((Object)new SplitApkDeployTask(this.myProject, this.myContext), (Object)updateStateTask);
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "getDeployTasks"));
                }
                return immutableList;
            }
            case DEX: {
                if (!this.canReuseProcessHandler()) {
                    throw new IllegalStateException("Cannot hotswap changes - the process has died since the build was started. Please Run or Debug again to recover from this issue.");
                }
            }
            case FULLAPK: {
                Preconditions.checkNotNull((Object)launchOptions);
                DeployApkTask deployApkTask = new DeployApkTask(this.myProject, launchOptions, InstantRunBuildAnalyzer.getApks(this.myBuildInfo, this.myContext), this.myContext);
                ImmutableList immutableList = ImmutableList.of((Object)deployApkTask, (Object)updateStateTask);
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "getDeployTasks"));
                }
                return immutableList;
            }
        }
        if (StatisticsUploadAssistant.isSendAllowed()) {
            CrashReporter.getInstance().submit(this.getIrDebugSignals(deployType));
        }
        throw new IllegalStateException(AndroidBundle.message("instant.run.build.error", new Object[0]));
    }

    @NotNull
    private Map<String, String> getIrDebugSignals(@NotNull DeployType deployType) {
        InstantRunBuildInfo buildInfo;
        if (deployType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployType", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "getIrDebugSignals"));
        }
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("deployType", deployType.toString());
        m.put("canReuseProcessHandler", Boolean.toString(this.canReuseProcessHandler()));
        m.put("androidGradlePluginVersion", this.myContext.getGradlePluginVersion().toString());
        BuildSelection selection = this.myContext.getBuildSelection();
        if (selection != null) {
            m.put("buildSelection.mode", selection.getBuildMode().toString());
            m.put("buildSelection.why", selection.why.toString());
        }
        if ((buildInfo = this.myContext.getInstantRunBuildInfo()) != null) {
            m.put("buildinfo.buildMode", buildInfo.getBuildMode());
            m.put("buildinfo.verifierStatus", buildInfo.getVerifierStatus());
            m.put("buildinfo.format", Integer.toString(buildInfo.getFormat()));
            List artifacts = buildInfo.getArtifacts();
            m.put("buildinfo.nArtifacts", Integer.toString(artifacts.size()));
            for (int i = 0; i < artifacts.size(); ++i) {
                InstantRunArtifact artifact = (InstantRunArtifact)artifacts.get(i);
                String prefix = "buildInfo.artifact[" + i + "]";
                m.put(prefix + ".type", artifact.type.toString());
                m.put(prefix + ".file", artifact.file.getName());
            }
        }
        HashMap<String, String> hashMap = m;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "getIrDebugSignals"));
        }
        return hashMap;
    }

    @NotNull
    public LaunchTask getNotificationTask() {
        DeployType deployType = this.getDeployType();
        BuildSelection buildSelection = this.myContext.getBuildSelection();
        InstantRunNotificationProvider notificationProvider = new InstantRunNotificationProvider(buildSelection, deployType, this.myBuildInfo.getVerifierStatus());
        InstantRunNotificationTask instantRunNotificationTask = new InstantRunNotificationTask(this.myProject, this.myContext, notificationProvider, buildSelection.brokenForSecondaryUser);
        if (instantRunNotificationTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "getNotificationTask"));
        }
        return instantRunNotificationTask;
    }

    @NotNull
    private DeployType getDeployType() {
        List artifacts;
        if (this.canReuseProcessHandler()) {
            if (this.myBuildInfo.hasNoChanges()) {
                DeployType deployType = DeployType.NO_CHANGES;
                if (deployType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "getDeployType"));
                }
                return deployType;
            }
            if (this.myBuildInfo.canHotswap()) {
                DeployType deployType = InstantRunSettings.isRestartActivity() ? DeployType.WARMSWAP : DeployType.HOTSWAP;
                if (deployType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "getDeployType"));
                }
                return deployType;
            }
        }
        if ((artifacts = this.myBuildInfo.getArtifacts()).isEmpty()) {
            DeployType deployType = DeployType.NO_CHANGES;
            if (deployType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "getDeployType"));
            }
            return deployType;
        }
        if (this.myBuildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.SPLIT}) || this.myBuildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.SPLIT_MAIN})) {
            DeployType deployType = DeployType.SPLITAPK;
            if (deployType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "getDeployType"));
            }
            return deployType;
        }
        if (this.myBuildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.DEX, InstantRunArtifactType.RESOURCES})) {
            DeployType deployType = DeployType.DEX;
            if (deployType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "getDeployType"));
            }
            return deployType;
        }
        DeployType deployType = DeployType.FULLAPK;
        if (deployType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "getDeployType"));
        }
        return deployType;
    }

    private static Collection<ApkInfo> getApks(@NotNull InstantRunBuildInfo buildInfo, @NotNull InstantRunContext context) throws ExecutionException {
        if (buildInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildInfo", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "getApks"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/fd/InstantRunBuildAnalyzer", "getApks"));
        }
        SmartList apks = new SmartList();
        for (InstantRunArtifact artifact : buildInfo.getArtifacts()) {
            if (artifact.type != InstantRunArtifactType.MAIN) {
                String msg = "Expected to only find apks, but got : " + artifact.type + "\n";
                BuildSelection buildSelection = context.getBuildSelection();
                assert (buildSelection != null) : "Build must have completed before apks are obtained";
                msg = buildSelection.getBuildMode() == BuildMode.HOT ? msg + "Could not use hot-swap artifacts when there is no existing session." : msg + "Unexpected artifacts for build mode: " + (Object)((Object)buildSelection.getBuildMode());
                InstantRunManager.LOG.error(msg);
                throw new ExecutionException(msg);
            }
            apks.add(new ApkInfo(artifact.file, context.getApplicationId()));
        }
        return apks;
    }
}

