/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.android.AaptOptionsModel;
import com.android.tools.idea.gradle.dsl.model.android.AdbOptionsModel;
import com.android.tools.idea.gradle.dsl.model.android.BuildTypeModel;
import com.android.tools.idea.gradle.dsl.model.android.CompileOptionsModel;
import com.android.tools.idea.gradle.dsl.model.android.DataBindingModel;
import com.android.tools.idea.gradle.dsl.model.android.DexOptionsModel;
import com.android.tools.idea.gradle.dsl.model.android.ExternalNativeBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.LintOptionsModel;
import com.android.tools.idea.gradle.dsl.model.android.PackagingOptionsModel;
import com.android.tools.idea.gradle.dsl.model.android.ProductFlavorModel;
import com.android.tools.idea.gradle.dsl.model.android.SigningConfigModel;
import com.android.tools.idea.gradle.dsl.model.android.SourceSetModel;
import com.android.tools.idea.gradle.dsl.model.android.SplitsModel;
import com.android.tools.idea.gradle.dsl.model.android.TestOptionsModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.android.AaptOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.AdbOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.BuildTypeDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.BuildTypesDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.CompileOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.DataBindingDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.DexOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ExternalNativeBuildDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.LintOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.PackagingOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.SigningConfigDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.SigningConfigsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.SourceSetDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.SourceSetsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.SplitsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.TestOptionsDslElement;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidModel
extends GradleDslBlockModel {
    @NonNls
    private static final String BUILD_TOOLS_VERSION = "buildToolsVersion";
    @NonNls
    private static final String COMPILE_SDK_VERSION = "compileSdkVersion";
    @NonNls
    private static final String DEFAULT_CONFIG = "defaultConfig";
    @NonNls
    private static final String DEFAULT_PUBLISH_CONFIG = "defaultPublishConfig";
    @NonNls
    private static final String FLAVOR_DIMENSIONS = "flavorDimensions";
    @NonNls
    private static final String GENERATE_PURE_SPLITS = "generatePureSplits";
    @NonNls
    private static final String PUBLISH_NON_DEFAULT = "publishNonDefault";
    @NonNls
    private static final String RESOURCE_PREFIX = "resourcePrefix";

    public AndroidModel(@NotNull AndroidDslElement dslElement) {
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "<init>"));
        }
        super(dslElement);
    }

    @NotNull
    public AaptOptionsModel aaptOptions() {
        AaptOptionsDslElement aaptOptionsElement = this.myDslElement.getPropertyElement("aaptOptions", AaptOptionsDslElement.class);
        if (aaptOptionsElement == null) {
            aaptOptionsElement = new AaptOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("aaptOptions", aaptOptionsElement);
        }
        AaptOptionsModel aaptOptionsModel = new AaptOptionsModel(aaptOptionsElement);
        if (aaptOptionsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "aaptOptions"));
        }
        return aaptOptionsModel;
    }

    @NotNull
    public AdbOptionsModel adbOptions() {
        AdbOptionsDslElement adbOptionsElement = this.myDslElement.getPropertyElement("adbOptions", AdbOptionsDslElement.class);
        if (adbOptionsElement == null) {
            adbOptionsElement = new AdbOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("adbOptions", adbOptionsElement);
        }
        AdbOptionsModel adbOptionsModel = new AdbOptionsModel(adbOptionsElement);
        if (adbOptionsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "adbOptions"));
        }
        return adbOptionsModel;
    }

    @NotNull
    public GradleNullableValue<String> buildToolsVersion() {
        GradleNullableValue<String> gradleNullableValue = this.getIntOrStringValue(BUILD_TOOLS_VERSION);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", BUILD_TOOLS_VERSION));
        }
        return gradleNullableValue;
    }

    @NotNull
    public AndroidModel setBuildToolsVersion(int buildToolsVersion) {
        this.myDslElement.setNewLiteral(BUILD_TOOLS_VERSION, buildToolsVersion);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setBuildToolsVersion"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel setBuildToolsVersion(@NotNull String buildToolsVersion) {
        if (buildToolsVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", BUILD_TOOLS_VERSION, "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setBuildToolsVersion"));
        }
        this.myDslElement.setNewLiteral(BUILD_TOOLS_VERSION, buildToolsVersion);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setBuildToolsVersion"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeBuildToolsVersion() {
        this.myDslElement.removeProperty(BUILD_TOOLS_VERSION);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeBuildToolsVersion"));
        }
        return androidModel;
    }

    @NotNull
    public List<BuildTypeModel> buildTypes() {
        BuildTypesDslElement buildTypes = this.myDslElement.getPropertyElement("buildTypes", BuildTypesDslElement.class);
        Object object = buildTypes == null ? ImmutableList.of() : buildTypes.get();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "buildTypes"));
        }
        return object;
    }

    @NotNull
    public AndroidModel addBuildType(@NotNull String buildType) {
        BuildTypeDslElement buildTypeElement;
        if (buildType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildType", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addBuildType"));
        }
        BuildTypesDslElement buildTypes = this.myDslElement.getPropertyElement("buildTypes", BuildTypesDslElement.class);
        if (buildTypes == null) {
            buildTypes = new BuildTypesDslElement(this.myDslElement);
            this.myDslElement.setNewElement("buildTypes", buildTypes);
        }
        if ((buildTypeElement = buildTypes.getPropertyElement(buildType, BuildTypeDslElement.class)) == null) {
            buildTypeElement = new BuildTypeDslElement(buildTypes, buildType);
            buildTypes.setNewElement(buildType, buildTypeElement);
        }
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addBuildType"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeBuildType(@NotNull String buildType) {
        if (buildType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildType", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeBuildType"));
        }
        BuildTypesDslElement buildTypes = this.myDslElement.getPropertyElement("buildTypes", BuildTypesDslElement.class);
        if (buildTypes != null) {
            buildTypes.removeProperty(buildType);
        }
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeBuildType"));
        }
        return androidModel;
    }

    @NotNull
    public CompileOptionsModel compileOptions() {
        CompileOptionsDslElement element = this.myDslElement.getPropertyElement("compileOptions", CompileOptionsDslElement.class);
        if (element == null) {
            element = new CompileOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("compileOptions", element);
        }
        CompileOptionsModel compileOptionsModel = new CompileOptionsModel(element, false);
        if (compileOptionsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "compileOptions"));
        }
        return compileOptionsModel;
    }

    @NotNull
    public GradleNullableValue<String> compileSdkVersion() {
        GradleNullableValue<String> gradleNullableValue = this.getIntOrStringValue(COMPILE_SDK_VERSION);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", COMPILE_SDK_VERSION));
        }
        return gradleNullableValue;
    }

    @NotNull
    public AndroidModel setCompileSdkVersion(int compileSdkVersion) {
        this.myDslElement.setNewLiteral(COMPILE_SDK_VERSION, compileSdkVersion);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setCompileSdkVersion"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel setCompileSdkVersion(@NotNull String compileSdkVersion) {
        if (compileSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", COMPILE_SDK_VERSION, "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setCompileSdkVersion"));
        }
        this.myDslElement.setNewLiteral(COMPILE_SDK_VERSION, compileSdkVersion);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setCompileSdkVersion"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeCompileSdkVersion() {
        this.myDslElement.removeProperty(COMPILE_SDK_VERSION);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeCompileSdkVersion"));
        }
        return androidModel;
    }

    @NotNull
    public DataBindingModel dataBinding() {
        DataBindingDslElement dataBindingElement = this.myDslElement.getPropertyElement("dataBinding", DataBindingDslElement.class);
        if (dataBindingElement == null) {
            dataBindingElement = new DataBindingDslElement(this.myDslElement);
            this.myDslElement.setNewElement("dataBinding", dataBindingElement);
        }
        DataBindingModel dataBindingModel = new DataBindingModel(dataBindingElement);
        if (dataBindingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "dataBinding"));
        }
        return dataBindingModel;
    }

    @NotNull
    public ProductFlavorModel defaultConfig() {
        ProductFlavorDslElement defaultConfigElement = this.myDslElement.getPropertyElement(DEFAULT_CONFIG, ProductFlavorDslElement.class);
        if (defaultConfigElement == null) {
            defaultConfigElement = new ProductFlavorDslElement(this.myDslElement, DEFAULT_CONFIG);
            this.myDslElement.setNewElement(DEFAULT_CONFIG, defaultConfigElement);
        }
        ProductFlavorModel productFlavorModel = new ProductFlavorModel(defaultConfigElement);
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", DEFAULT_CONFIG));
        }
        return productFlavorModel;
    }

    @NotNull
    public GradleNullableValue<String> defaultPublishConfig() {
        GradleNullableValue<String> gradleNullableValue = this.myDslElement.getLiteralProperty(DEFAULT_PUBLISH_CONFIG, String.class);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", DEFAULT_PUBLISH_CONFIG));
        }
        return gradleNullableValue;
    }

    @NotNull
    public AndroidModel setDefaultPublishConfig(@NotNull String defaultPublishConfig) {
        if (defaultPublishConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", DEFAULT_PUBLISH_CONFIG, "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setDefaultPublishConfig"));
        }
        this.myDslElement.setNewLiteral(DEFAULT_PUBLISH_CONFIG, defaultPublishConfig);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setDefaultPublishConfig"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeDefaultPublishConfig() {
        this.myDslElement.removeProperty(DEFAULT_PUBLISH_CONFIG);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeDefaultPublishConfig"));
        }
        return androidModel;
    }

    @NotNull
    public DexOptionsModel dexOptions() {
        DexOptionsDslElement dexOptionsElement = this.myDslElement.getPropertyElement("dexOptions", DexOptionsDslElement.class);
        if (dexOptionsElement == null) {
            dexOptionsElement = new DexOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("dexOptions", dexOptionsElement);
        }
        DexOptionsModel dexOptionsModel = new DexOptionsModel(dexOptionsElement);
        if (dexOptionsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "dexOptions"));
        }
        return dexOptionsModel;
    }

    @NotNull
    public ExternalNativeBuildModel externalNativeBuild() {
        ExternalNativeBuildDslElement externalNativeBuildDslElement = this.myDslElement.getPropertyElement("externalNativeBuild", ExternalNativeBuildDslElement.class);
        if (externalNativeBuildDslElement == null) {
            externalNativeBuildDslElement = new ExternalNativeBuildDslElement(this.myDslElement);
            this.myDslElement.setNewElement("externalNativeBuild", externalNativeBuildDslElement);
        }
        ExternalNativeBuildModel externalNativeBuildModel = new ExternalNativeBuildModel(externalNativeBuildDslElement);
        if (externalNativeBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "externalNativeBuild"));
        }
        return externalNativeBuildModel;
    }

    @Nullable
    public List<GradleNotNullValue<String>> flavorDimensions() {
        return this.myDslElement.getListProperty(FLAVOR_DIMENSIONS, String.class);
    }

    @NotNull
    public AndroidModel addFlavorDimension(@NotNull String flavorDimension) {
        if (flavorDimension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavorDimension", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addFlavorDimension"));
        }
        this.myDslElement.addToNewLiteralList(FLAVOR_DIMENSIONS, flavorDimension);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addFlavorDimension"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeFlavorDimension(@NotNull String flavorDimension) {
        if (flavorDimension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavorDimension", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeFlavorDimension"));
        }
        this.myDslElement.removeFromExpressionList(FLAVOR_DIMENSIONS, flavorDimension);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeFlavorDimension"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeAllFlavorDimensions() {
        this.myDslElement.removeProperty(FLAVOR_DIMENSIONS);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeAllFlavorDimensions"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel replaceFlavorDimension(@NotNull String oldFlavorDimension, @NotNull String newFlavorDimension) {
        if (oldFlavorDimension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFlavorDimension", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "replaceFlavorDimension"));
        }
        if (newFlavorDimension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFlavorDimension", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "replaceFlavorDimension"));
        }
        this.myDslElement.replaceInExpressionList(FLAVOR_DIMENSIONS, oldFlavorDimension, newFlavorDimension);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "replaceFlavorDimension"));
        }
        return androidModel;
    }

    @NotNull
    public GradleNullableValue<Boolean> generatePureSplits() {
        GradleNullableValue<Boolean> gradleNullableValue = this.myDslElement.getLiteralProperty(GENERATE_PURE_SPLITS, Boolean.class);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", GENERATE_PURE_SPLITS));
        }
        return gradleNullableValue;
    }

    @NotNull
    public AndroidModel setGeneratePureSplits(boolean generatePureSplits) {
        this.myDslElement.setNewLiteral(GENERATE_PURE_SPLITS, generatePureSplits);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setGeneratePureSplits"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeGeneratePureSplits() {
        this.myDslElement.removeProperty(GENERATE_PURE_SPLITS);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeGeneratePureSplits"));
        }
        return androidModel;
    }

    @NotNull
    public LintOptionsModel lintOptions() {
        LintOptionsDslElement lintOptionsDslElement = this.myDslElement.getPropertyElement("lintOptions", LintOptionsDslElement.class);
        if (lintOptionsDslElement == null) {
            lintOptionsDslElement = new LintOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("lintOptions", lintOptionsDslElement);
        }
        LintOptionsModel lintOptionsModel = new LintOptionsModel(lintOptionsDslElement);
        if (lintOptionsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "lintOptions"));
        }
        return lintOptionsModel;
    }

    @NotNull
    public PackagingOptionsModel packagingOptions() {
        PackagingOptionsDslElement packagingOptionsDslElement = this.myDslElement.getPropertyElement("packagingOptions", PackagingOptionsDslElement.class);
        if (packagingOptionsDslElement == null) {
            packagingOptionsDslElement = new PackagingOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("packagingOptions", packagingOptionsDslElement);
        }
        PackagingOptionsModel packagingOptionsModel = new PackagingOptionsModel(packagingOptionsDslElement);
        if (packagingOptionsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "packagingOptions"));
        }
        return packagingOptionsModel;
    }

    @NotNull
    public List<ProductFlavorModel> productFlavors() {
        ProductFlavorsDslElement productFlavors = this.myDslElement.getPropertyElement("productFlavors", ProductFlavorsDslElement.class);
        Object object = productFlavors == null ? ImmutableList.of() : productFlavors.get();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "productFlavors"));
        }
        return object;
    }

    @NotNull
    public AndroidModel addProductFlavor(@NotNull String flavor) {
        ProductFlavorDslElement flavorElement;
        if (flavor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavor", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addProductFlavor"));
        }
        ProductFlavorsDslElement productFlavors = this.myDslElement.getPropertyElement("productFlavors", ProductFlavorsDslElement.class);
        if (productFlavors == null) {
            productFlavors = new ProductFlavorsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("productFlavors", productFlavors);
        }
        if ((flavorElement = productFlavors.getPropertyElement(flavor, ProductFlavorDslElement.class)) == null) {
            flavorElement = new ProductFlavorDslElement(productFlavors, flavor);
            productFlavors.setNewElement(flavor, flavorElement);
        }
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addProductFlavor"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeProductFlavor(@NotNull String flavor) {
        if (flavor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavor", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeProductFlavor"));
        }
        ProductFlavorsDslElement productFlavors = this.myDslElement.getPropertyElement("productFlavors", ProductFlavorsDslElement.class);
        if (productFlavors != null) {
            productFlavors.removeProperty(flavor);
        }
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeProductFlavor"));
        }
        return androidModel;
    }

    @NotNull
    public List<SigningConfigModel> signingConfigs() {
        SigningConfigsDslElement signingConfigs = this.myDslElement.getPropertyElement("signingConfigs", SigningConfigsDslElement.class);
        Object object = signingConfigs == null ? ImmutableList.of() : signingConfigs.get();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "signingConfigs"));
        }
        return object;
    }

    @NotNull
    public AndroidModel addSigningConfig(@NotNull String config) {
        SigningConfigDslElement configElement;
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addSigningConfig"));
        }
        SigningConfigsDslElement signingConfigs = this.myDslElement.getPropertyElement("signingConfigs", SigningConfigsDslElement.class);
        if (signingConfigs == null) {
            signingConfigs = new SigningConfigsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("signingConfigs", signingConfigs);
        }
        if ((configElement = signingConfigs.getPropertyElement(config, SigningConfigDslElement.class)) == null) {
            configElement = new SigningConfigDslElement(signingConfigs, config);
            signingConfigs.setNewElement(config, configElement);
        }
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addSigningConfig"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeSigningConfig(@NotNull String configName) {
        if (configName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configName", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeSigningConfig"));
        }
        SigningConfigsDslElement signingConfig = this.myDslElement.getPropertyElement("signingConfigs", SigningConfigsDslElement.class);
        if (signingConfig != null) {
            signingConfig.removeProperty(configName);
        }
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeSigningConfig"));
        }
        return androidModel;
    }

    @NotNull
    public List<SourceSetModel> sourceSets() {
        SourceSetsDslElement sourceSets = this.myDslElement.getPropertyElement("sourceSets", SourceSetsDslElement.class);
        Object object = sourceSets == null ? ImmutableList.of() : sourceSets.get();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "sourceSets"));
        }
        return object;
    }

    @NotNull
    public AndroidModel addSourceSet(@NotNull String sourceSet) {
        SourceSetDslElement sourceSetElement;
        if (sourceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSet", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addSourceSet"));
        }
        SourceSetsDslElement sourceSets = this.myDslElement.getPropertyElement("sourceSets", SourceSetsDslElement.class);
        if (sourceSets == null) {
            sourceSets = new SourceSetsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("sourceSets", sourceSets);
        }
        if ((sourceSetElement = sourceSets.getPropertyElement(sourceSet, SourceSetDslElement.class)) == null) {
            sourceSetElement = new SourceSetDslElement(sourceSets, sourceSet);
            sourceSets.setNewElement(sourceSet, sourceSetElement);
        }
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addSourceSet"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeSourceSet(@NotNull String sourceSet) {
        if (sourceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSet", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeSourceSet"));
        }
        SourceSetsDslElement sourceSets = this.myDslElement.getPropertyElement("sourceSets", SourceSetsDslElement.class);
        if (sourceSets != null) {
            sourceSets.removeProperty(sourceSet);
        }
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeSourceSet"));
        }
        return androidModel;
    }

    @NotNull
    public SplitsModel splits() {
        SplitsDslElement splitsDslElement = this.myDslElement.getPropertyElement("splits", SplitsDslElement.class);
        if (splitsDslElement == null) {
            splitsDslElement = new SplitsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("splits", splitsDslElement);
        }
        SplitsModel splitsModel = new SplitsModel(splitsDslElement);
        if (splitsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "splits"));
        }
        return splitsModel;
    }

    @NotNull
    public TestOptionsModel testOptions() {
        TestOptionsDslElement testOptionsDslElement = this.myDslElement.getPropertyElement("testOptions", TestOptionsDslElement.class);
        if (testOptionsDslElement == null) {
            testOptionsDslElement = new TestOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("testOptions", testOptionsDslElement);
        }
        TestOptionsModel testOptionsModel = new TestOptionsModel(testOptionsDslElement);
        if (testOptionsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "testOptions"));
        }
        return testOptionsModel;
    }

    @NotNull
    public GradleNullableValue<Boolean> publishNonDefault() {
        GradleNullableValue<Boolean> gradleNullableValue = this.myDslElement.getLiteralProperty(PUBLISH_NON_DEFAULT, Boolean.class);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", PUBLISH_NON_DEFAULT));
        }
        return gradleNullableValue;
    }

    @NotNull
    public AndroidModel setPublishNonDefault(boolean publishNonDefault) {
        this.myDslElement.setNewLiteral(PUBLISH_NON_DEFAULT, publishNonDefault);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setPublishNonDefault"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removePublishNonDefault() {
        this.myDslElement.removeProperty(PUBLISH_NON_DEFAULT);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removePublishNonDefault"));
        }
        return androidModel;
    }

    @NotNull
    public GradleNullableValue<String> resourcePrefix() {
        GradleNullableValue<String> gradleNullableValue = this.myDslElement.getLiteralProperty(RESOURCE_PREFIX, String.class);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", RESOURCE_PREFIX));
        }
        return gradleNullableValue;
    }

    @NotNull
    public AndroidModel setResourcePrefix(@NotNull String resourcePrefix) {
        if (resourcePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", RESOURCE_PREFIX, "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setResourcePrefix"));
        }
        this.myDslElement.setNewLiteral(RESOURCE_PREFIX, resourcePrefix);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setResourcePrefix"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeResourcePrefix() {
        this.myDslElement.removeProperty(RESOURCE_PREFIX);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeResourcePrefix"));
        }
        return androidModel;
    }
}

