/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.notification;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class AutoImportNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.gradle.auto.import");
    @NotNull
    private final Project myProject;
    @NotNull
    private final EditorNotifications myNotifications;

    public AutoImportNotificationProvider(@NotNull Project project, @NotNull EditorNotifications notifications) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/notification/AutoImportNotificationProvider", "<init>"));
        }
        if (notifications == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notifications", "com/android/tools/idea/gradle/notification/AutoImportNotificationProvider", "<init>"));
        }
        this.myProject = project;
        this.myNotifications = notifications;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/notification/AutoImportNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/notification/AutoImportNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/android/tools/idea/gradle/notification/AutoImportNotificationProvider", "createNotificationPanel"));
        }
        if (!GradleProjectInfo.getInstance(this.myProject).isBuildWithGradle()) {
            return null;
        }
        String name = file.getName();
        if ("build.gradle".equals(name) || "settings.gradle".equals(name)) {
            GradleProjectSettings settings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(this.myProject);
            if (IdeInfo.getInstance().isAndroidStudio() && settings != null && settings.isUseAutoImport()) {
                return new DisableAutoImportNotificationPanel(settings);
            }
        }
        return null;
    }

    private class DisableAutoImportNotificationPanel
    extends EditorNotificationPanel {
        DisableAutoImportNotificationPanel(GradleProjectSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/android/tools/idea/gradle/notification/AutoImportNotificationProvider$DisableAutoImportNotificationPanel", "<init>"));
            }
            this.setText("Gradle 'auto-import' will considerably slow down the IDE, due to a known bug.");
            this.createActionLabel("Open bug report", () -> BrowserUtil.browse((String)"https://code.google.com/p/android/issues/detail?id=59965"));
            this.createActionLabel("Disable 'auto-import'", () -> {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/android/tools/idea/gradle/notification/AutoImportNotificationProvider$DisableAutoImportNotificationPanel", "lambda$new$1"));
                }
                settings.setUseAutoImport(false);
                AutoImportNotificationProvider.this.myNotifications.updateAllNotifications();
            });
        }
    }
}

