/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ModuleDependencyModel;
import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GradleProjectDependencyParser {
    @NotNull
    public static Function<VirtualFile, Iterable<String>> newInstance(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectDependencyParser", "newInstance"));
        }
        LoadingCache loadingCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<VirtualFile, Iterable<String>>(){

            public Iterable<String> load(@NotNull VirtualFile key) throws Exception {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/gradle/project/GradleProjectDependencyParser$1", "load"));
                }
                return GradleProjectDependencyParser.parse(key, project);
            }
        });
        if (loadingCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectDependencyParser", "newInstance"));
        }
        return loadingCache;
    }

    @NotNull
    private static Set<String> parse(@NotNull VirtualFile moduleRoot, @NotNull Project project) {
        if (moduleRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRoot", "com/android/tools/idea/gradle/project/GradleProjectDependencyParser", "parse"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectDependencyParser", "parse"));
        }
        VirtualFile buildFile = moduleRoot.findChild("build.gradle");
        if (buildFile == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectDependencyParser", "parse"));
            }
            return set;
        }
        HashSet result = Sets.newHashSet();
        GradleBuildModel buildModel = GradleBuildModel.parseBuildFile(buildFile, project);
        DependenciesModel dependenciesModel = buildModel.dependencies();
        if (dependenciesModel != null) {
            for (ModuleDependencyModel dependency : dependenciesModel.modules()) {
                String modulePath = dependency.path().value();
                result.add(modulePath);
            }
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectDependencyParser", "parse"));
        }
        return hashSet;
    }
}

