/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.compiler;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class AndroidGradleBuildProcessParametersProvider
extends BuildProcessParametersProvider {
    @NotNull
    private final Project myProject;

    public AndroidGradleBuildProcessParametersProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/build/compiler/AndroidGradleBuildProcessParametersProvider", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public List<String> getVMArguments() {
        if (!Projects.isBuildWithGradle(this.myProject)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/compiler/AndroidGradleBuildProcessParametersProvider", "getVMArguments"));
            }
            return list;
        }
        ArrayList jvmArgs = Lists.newArrayList();
        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(this.myProject);
        AndroidGradleBuildProcessParametersProvider.populateJvmArgs(buildConfiguration, jvmArgs, this.myProject);
        GradleExecutionSettings executionSettings = GradleUtil.getGradleExecutionSettings(this.myProject);
        if (executionSettings != null) {
            this.populateJvmArgs(executionSettings, (List<String>)jvmArgs);
        }
        this.populateJvmArgs(BuildSettings.getInstance(this.myProject), (List<String>)jvmArgs);
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            AndroidGradleBuildProcessParametersProvider.addHttpProxySettings(jvmArgs);
        }
        ArrayList arrayList = jvmArgs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/compiler/AndroidGradleBuildProcessParametersProvider", "getVMArguments"));
        }
        return arrayList;
    }

    @VisibleForTesting
    static void populateJvmArgs(@NotNull AndroidGradleBuildConfiguration buildConfiguration, @NotNull List<String> jvmArgs, @NotNull Project project) {
        if (buildConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildConfiguration", "com/android/tools/idea/gradle/project/build/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmArgs", "com/android/tools/idea/gradle/project/build/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/build/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.offline.mode", (boolean)GradleSettings.getInstance((Project)project).isOfflineWork()));
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.configuration.on.demand", (boolean)buildConfiguration.USE_CONFIGURATION_ON_DEMAND));
        String[] commandLineOptions = buildConfiguration.getCommandLineOptions();
        int optionCount = 0;
        for (String option : commandLineOptions) {
            String name = "com.android.studio.gradle.daemon.command.line.option." + optionCount++;
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)option));
        }
    }

    @VisibleForTesting
    void populateJvmArgs(@NotNull GradleExecutionSettings executionSettings, @NotNull List<String> jvmArgs) {
        File javaHome;
        String serviceDirectory;
        if (executionSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionSettings", "com/android/tools/idea/gradle/project/build/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmArgs", "com/android/tools/idea/gradle/project/build/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        String gradleHome = executionSettings.getGradleHome();
        if (gradleHome != null && !gradleHome.isEmpty()) {
            gradleHome = FileUtil.toSystemDependentName((String)gradleHome);
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.home.path", (String)gradleHome));
        }
        if ((serviceDirectory = executionSettings.getServiceDirectory()) != null && !serviceDirectory.isEmpty()) {
            serviceDirectory = FileUtil.toSystemDependentName((String)serviceDirectory);
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.service.dir.path", (String)serviceDirectory));
        }
        if ((javaHome = IdeSdks.getInstance().getJdkPath()) != null) {
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.java.home.path", (String)javaHome.getPath()));
        }
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.project.path", (String)Projects.getBaseDirPath(this.myProject).getPath()));
        boolean verboseProcessing = executionSettings.isVerboseProcessing();
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.use.verbose.logging", (boolean)verboseProcessing));
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            Set jvmOptions = executionSettings.getVmOptions();
            int jvmOptionCount = 0;
            for (String option : jvmOptions) {
                String name = "com.android.studio.gradle.daemon.jvm.option." + jvmOptionCount++;
                jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)option));
            }
        }
    }

    private static void addHttpProxySettings(@NotNull List<String> jvmArgs) {
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmArgs", "com/android/tools/idea/gradle/project/build/compiler/AndroidGradleBuildProcessParametersProvider", "addHttpProxySettings"));
        }
        AndroidGradleBuildProcessParametersProvider.populateHttpProxyProperties(jvmArgs, HttpConfigurable.getInstance().getJvmProperties(false, null));
    }

    @VisibleForTesting
    static void populateHttpProxyProperties(List<String> jvmArgs, List<Pair<String, String>> properties) {
        int propertyCount = properties.size();
        for (int i = 0; i < propertyCount; ++i) {
            Pair<String, String> property = properties.get(i);
            String name = "com.android.studio.gradle.proxy.property." + i;
            String value = (String)property.first + ":" + (String)property.second;
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)value));
        }
    }

    private void populateJvmArgs(@NotNull BuildSettings buildSettings, @NotNull List<String> jvmArgs) {
        if (buildSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildSettings", "com/android/tools/idea/gradle/project/build/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmArgs", "com/android/tools/idea/gradle/project/build/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        BuildMode buildMode = buildSettings.getBuildMode();
        if (buildMode == null) {
            buildMode = BuildMode.DEFAULT_BUILD_MODE;
        }
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.build.mode", (String)buildMode.toString()));
        this.populateGradleTasksToInvoke(buildMode, jvmArgs);
    }

    @VisibleForTesting
    void populateGradleTasksToInvoke(@NotNull BuildMode buildMode, @NotNull List<String> jvmArgs) {
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMode", "com/android/tools/idea/gradle/project/build/compiler/AndroidGradleBuildProcessParametersProvider", "populateGradleTasksToInvoke"));
        }
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmArgs", "com/android/tools/idea/gradle/project/build/compiler/AndroidGradleBuildProcessParametersProvider", "populateGradleTasksToInvoke"));
        }
        if (buildMode == BuildMode.ASSEMBLE_TRANSLATE) {
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.gradle.tasks.0", (String)"assembleTranslate"));
            return;
        }
        BuildSettings buildSettings = BuildSettings.getInstance(this.myProject);
        Module[] modulesToBuild = buildSettings.getModulesToBuild();
        if (modulesToBuild == null || buildMode == BuildMode.ASSEMBLE && GradleSyncState.getInstance(this.myProject).lastSyncFailed()) {
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.gradle.tasks.0", (String)"assemble"));
            return;
        }
        GradleBuildInvoker.TestCompileType testCompileType = GradleBuildInvoker.getTestCompileType(buildSettings.getRunConfigurationTypeId());
        List<String> tasks = GradleBuildInvoker.findTasksToExecute(modulesToBuild, buildMode, testCompileType);
        int taskCount = tasks.size();
        for (int i = 0; i < taskCount; ++i) {
            String name = "com.android.studio.gradle.gradle.tasks." + i;
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)tasks.get(i)));
        }
    }

    public boolean isProcessPreloadingEnabled() {
        return !GradleProjectInfo.getInstance(this.myProject).isBuildWithGradle();
    }
}

