/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.NewProjects;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public abstract class NewProjectImportGradleSyncListener
extends GradleSyncListener.Adapter {
    @Override
    public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/importing/NewProjectImportGradleSyncListener", "syncFailed"));
        }
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/project/importing/NewProjectImportGradleSyncListener", "syncFailed"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/importing/NewProjectImportGradleSyncListener", "lambda$syncFailed$0"));
            }
            NewProjectImportGradleSyncListener.createTopLevelProjectAndOpen(project);
        });
    }

    public static void createTopLevelProjectAndOpen(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/importing/NewProjectImportGradleSyncListener", "createTopLevelProjectAndOpen"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/importing/NewProjectImportGradleSyncListener", "lambda$createTopLevelProjectAndOpen$1"));
            }
            NewProjectImportGradleSyncListener.createTopLevelModule(project);
        });
        Projects.open(project);
        NewProjects.activateProjectView(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTopLevelModule(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/importing/NewProjectImportGradleSyncListener", "createTopLevelModule"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        File projectRootDir = Projects.getBaseDirPath(project);
        VirtualFile contentRoot = VfsUtil.findFileByIoFile((File)projectRootDir, (boolean)true);
        if (contentRoot != null) {
            Sdk jdk;
            File moduleFile = new File(projectRootDir, projectRootDir.getName() + ".iml");
            Module module = moduleManager.newModule(moduleFile.getPath(), StdModuleTypes.JAVA.getId());
            module.setOption("external.system.id", GradleUtil.GRADLE_SYSTEM_ID.getId());
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            model.addContentEntry(contentRoot);
            if (IdeInfo.getInstance().isAndroidStudio() && (jdk = IdeSdks.getInstance().getJdk()) != null) {
                model.setSdk(jdk);
            }
            model.commit();
            FacetManager facetManager = FacetManager.getInstance((Module)module);
            ModifiableFacetModel facetModel = facetManager.createModifiableModel();
            try {
                GradleFacet gradleFacet = GradleFacet.getInstance(module);
                if (gradleFacet == null) {
                    gradleFacet = (GradleFacet)facetManager.createFacet((FacetType)GradleFacet.getFacetType(), GradleFacet.getFacetName(), null);
                    facetModel.addFacet((Facet)gradleFacet);
                }
                ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH = ":";
                AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                if (androidFacet == null) {
                    androidFacet = (AndroidFacet)facetManager.createFacet((FacetType)AndroidFacet.getFacetType(), "Android", null);
                    facetModel.addFacet((Facet)androidFacet);
                }
                androidFacet.getProperties().ALLOW_USER_CONFIGURATION = false;
            }
            finally {
                facetModel.commit();
            }
        }
    }

    @Override
    public void syncSkipped(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/importing/NewProjectImportGradleSyncListener", "syncSkipped"));
        }
    }
}

