/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkModuleModel
implements ModuleModel {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String myModuleName;
    @NotNull
    private File myRootDirPath;
    @NotNull
    private NativeAndroidProject myAndroidProject;
    @Nullable
    private transient GradleVersion myModelVersion;
    @Nullable
    private transient CountDownLatch myProxyNativeAndroidProjectLatch;
    @Nullable
    private NativeAndroidProject myProxyNativeAndroidProject;
    @NotNull
    private Map<String, NdkVariant> myVariantsByName;
    @NotNull
    private Map<String, NativeToolchain> myToolchainsByName;
    @NotNull
    private Map<String, NativeSettings> mySettingsByName;
    @NotNull
    private String mySelectedVariantName;

    @Nullable
    public static NdkModuleModel get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "get"));
        }
        NdkFacet facet = NdkFacet.getInstance(module);
        return facet != null ? NdkModuleModel.get(facet) : null;
    }

    @Nullable
    public static NdkModuleModel get(@NotNull NdkFacet ndkFacet) {
        if (ndkFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ndkFacet", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "get"));
        }
        NdkModuleModel androidModel = ndkFacet.getNdkModuleModel();
        if (androidModel == null) {
            return null;
        }
        return androidModel;
    }

    public NdkModuleModel(@NotNull String moduleName, @NotNull File rootDirPath, @NotNull NativeAndroidProject androidProject) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "<init>"));
        }
        if (rootDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDirPath", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "<init>"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "<init>"));
        }
        this.myVariantsByName = new HashMap<String, NdkVariant>();
        this.myToolchainsByName = new HashMap<String, NativeToolchain>();
        this.mySettingsByName = new HashMap<String, NativeSettings>();
        this.myModuleName = moduleName;
        this.myRootDirPath = rootDirPath;
        this.myAndroidProject = androidProject;
        this.parseAndSetModelVersion();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.myProxyNativeAndroidProjectLatch = new CountDownLatch(1);
            this.myProxyNativeAndroidProject = ProxyUtil.reproxy(NativeAndroidProject.class, this.myAndroidProject);
            this.myProxyNativeAndroidProjectLatch.countDown();
        });
        this.populateVariantsByName();
        this.populateToolchainsByName();
        this.populateSettingsByName();
        this.initializeSelectedVariant();
    }

    private void populateVariantsByName() {
        for (NativeArtifact artifact : this.myAndroidProject.getArtifacts()) {
            String variantName = this.modelVersionIsAtLeast("2.0.0") ? artifact.getGroupName() : artifact.getName();
            NdkVariant variant = this.myVariantsByName.get(variantName);
            if (variant == null) {
                variant = new NdkVariant(variantName);
                this.myVariantsByName.put(variant.getName(), variant);
            }
            variant.addArtifact(artifact);
        }
        if (this.myVariantsByName.isEmpty()) {
            this.myVariantsByName.put("-----", new NdkVariant("-----"));
        }
    }

    private void populateToolchainsByName() {
        for (NativeToolchain toolchain : this.myAndroidProject.getToolChains()) {
            this.myToolchainsByName.put(toolchain.getName(), toolchain);
        }
    }

    private void populateSettingsByName() {
        for (NativeSettings settings : this.myAndroidProject.getSettings()) {
            this.mySettingsByName.put(settings.getName(), settings);
        }
    }

    private void initializeSelectedVariant() {
        Set<String> variantNames = this.myVariantsByName.keySet();
        assert (!variantNames.isEmpty());
        if (variantNames.size() == 1) {
            this.mySelectedVariantName = (String)Iterables.getOnlyElement(variantNames);
            return;
        }
        for (String variantName : variantNames) {
            if (!variantName.equals("debug")) continue;
            this.mySelectedVariantName = variantName;
            return;
        }
        ArrayList<String> sortedVariantNames = new ArrayList<String>(variantNames);
        Collections.sort(sortedVariantNames);
        assert (!sortedVariantNames.isEmpty());
        this.mySelectedVariantName = (String)sortedVariantNames.get(0);
    }

    private void parseAndSetModelVersion() {
        this.myModelVersion = GradleVersion.tryParse((String)this.myAndroidProject.getModelVersion());
    }

    public boolean modelVersionIsAtLeast(@NotNull String revision) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "modelVersionIsAtLeast"));
        }
        return this.myModelVersion != null && this.myModelVersion.compareIgnoringQualifiers(revision) >= 0;
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "getModuleName"));
        }
        return string;
    }

    @NotNull
    public File getRootDirPath() {
        File file = this.myRootDirPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "getRootDirPath"));
        }
        return file;
    }

    @NotNull
    public NativeAndroidProject getAndroidProject() {
        NativeAndroidProject nativeAndroidProject = this.myAndroidProject;
        if (nativeAndroidProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "getAndroidProject"));
        }
        return nativeAndroidProject;
    }

    @NotNull
    public Collection<String> getVariantNames() {
        Set<String> set = this.myVariantsByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "getVariantNames"));
        }
        return set;
    }

    @NotNull
    public Collection<NdkVariant> getVariants() {
        Collection<NdkVariant> collection = this.myVariantsByName.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "getVariants"));
        }
        return collection;
    }

    @NotNull
    public NdkVariant getSelectedVariant() {
        NdkVariant selected = this.myVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        NdkVariant ndkVariant = selected;
        if (ndkVariant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "getSelectedVariant"));
        }
        return ndkVariant;
    }

    public void setSelectedVariantName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "setSelectedVariantName"));
        }
        Collection<String> variantNames = this.getVariantNames();
        if (variantNames.contains(name)) {
            this.mySelectedVariantName = name;
        } else {
            this.initializeSelectedVariant();
        }
    }

    @Nullable
    public NativeToolchain findToolchain(@NotNull String toolchainName) {
        if (toolchainName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolchainName", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "findToolchain"));
        }
        return this.myToolchainsByName.get(toolchainName);
    }

    @Nullable
    public NativeSettings findSettings(@NotNull String settingsName) {
        if (settingsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsName", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "findSettings"));
        }
        return this.mySettingsByName.get(settingsName);
    }

    @NotNull
    public NativeAndroidProject waitForAndGetProxyAndroidProject() {
        this.waitForProxyAndroidProject();
        assert (this.myProxyNativeAndroidProject != null);
        NativeAndroidProject nativeAndroidProject = this.myProxyNativeAndroidProject;
        if (nativeAndroidProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/NdkModuleModel", "waitForAndGetProxyAndroidProject"));
        }
        return nativeAndroidProject;
    }

    public void waitForProxyAndroidProject() {
        if (this.myProxyNativeAndroidProjectLatch != null) {
            try {
                this.myProxyNativeAndroidProjectLatch.await();
            }
            catch (InterruptedException e) {
                Logger.getInstance(NdkModuleModel.class).error((Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.waitForProxyAndroidProject();
        out.writeObject(this.myModuleName);
        out.writeObject(this.myRootDirPath);
        out.writeObject(this.myProxyNativeAndroidProject);
        out.writeObject(this.mySelectedVariantName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myModuleName = (String)in.readObject();
        this.myRootDirPath = (File)in.readObject();
        this.myAndroidProject = (NativeAndroidProject)in.readObject();
        this.mySelectedVariantName = (String)in.readObject();
        this.parseAndSetModelVersion();
        this.myProxyNativeAndroidProject = this.myAndroidProject;
        this.myVariantsByName = new HashMap<String, NdkVariant>();
        this.myToolchainsByName = new HashMap<String, NativeToolchain>();
        this.mySettingsByName = new HashMap<String, NativeSettings>();
        this.populateVariantsByName();
        this.populateToolchainsByName();
        this.populateSettingsByName();
    }

    public class NdkVariant {
        @NotNull
        private final String myVariantName;
        @NotNull
        private final Map<String, NativeArtifact> myArtifactsByName;

        private NdkVariant(String variantName) {
            if (variantName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantName", "com/android/tools/idea/gradle/project/model/NdkModuleModel$NdkVariant", "<init>"));
            }
            this.myArtifactsByName = new HashMap<String, NativeArtifact>();
            this.myVariantName = variantName;
        }

        private void addArtifact(@NotNull NativeArtifact artifact) {
            if (artifact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/project/model/NdkModuleModel$NdkVariant", "addArtifact"));
            }
            this.myArtifactsByName.put(artifact.getName(), artifact);
        }

        @NotNull
        public String getName() {
            String string = this.myVariantName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/NdkModuleModel$NdkVariant", "getName"));
            }
            return string;
        }

        @NotNull
        public Collection<NativeArtifact> getArtifacts() {
            Collection<NativeArtifact> collection = this.myArtifactsByName.values();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/NdkModuleModel$NdkVariant", "getArtifacts"));
            }
            return collection;
        }

        @NotNull
        public Collection<File> getSourceFolders() {
            LinkedHashSet<File> sourceFolders = new LinkedHashSet<File>();
            for (NativeArtifact artifact : this.getArtifacts()) {
                if (NdkModuleModel.this.modelVersionIsAtLeast("2.0.0")) {
                    for (File headerRoot : artifact.getExportedHeaders()) {
                        sourceFolders.add(headerRoot);
                    }
                }
                for (NativeFolder sourceFolder : artifact.getSourceFolders()) {
                    sourceFolders.add(sourceFolder.getFolderPath());
                }
                for (NativeFile sourceFile : artifact.getSourceFiles()) {
                    File parentFile = sourceFile.getFilePath().getParentFile();
                    if (parentFile == null) continue;
                    sourceFolders.add(parentFile);
                }
            }
            ImmutableList immutableList = ImmutableList.copyOf(sourceFolders);
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/NdkModuleModel$NdkVariant", "getSourceFolders"));
            }
            return immutableList;
        }
    }
}

